/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class PlanExecutionSummarySendTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PlanExecutionSummarySendTask.class);
    private static final Function<Long, QFilter> ID_FILTER = x -> new QFilter("intelschemaid", "=", x);
    private static final Function<Date, QFilter> DATE_FILTER = x -> new QFilter("createtime", ">", x);
    private static final String KEY_EXELOG_STATUS = "execstatus";

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        block25: {
            LOG.info("start PlanExecutionSummarySendTask scheduled.");
            if (Objects.isNull(paramMap)) {
                paramMap = Collections.EMPTY_MAP;
            }
            try {
                LOG.info("start to execute PlanExecutionSummarySendTask:" + JSONUtils.toString((Object)paramMap));
            }
            catch (IOException e) {
                LOG.error("Failed to parse param:" + paramMap);
            }
            Integer lastHourCnt = Integer.parseInt(paramMap.getOrDefault("lastHours", "24").toString());
            Calendar lastDayTime = Calendar.getInstance();
            lastDayTime.add(10, -lastHourCnt.intValue());
            int curHour = Calendar.getInstance().get(11);
            try (TraceSpan span = Tracer.create((String)PlanExecutionSummarySendTask.class.getName(), (String)"wholeProcess");){
                DataSet intellSchemasSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_intellexecschema", (String)StringUtils.join((Object[])new String[]{"id,number,name,executor", "notificationtypes", "notificationusers.fbasedataid", "notificationconditions"}, (String)","), null, null);
                HashMap receiversMap = new HashMap();
                intellSchemasSet.copy().forEach(intellSchema -> {
                    long schemaId = intellSchema.getLong("id");
                    List receivers = receiversMap.computeIfAbsent(schemaId, v -> new ArrayList());
                    receivers.add(intellSchema.getLong("notificationusers.fbasedataid"));
                });
                intellSchemasSet = intellSchemasSet.select(true, new String[]{"id", "number", "name", "executor", "notificationtypes", "notificationconditions"});
                Map<Long, Map<String, Long>> intellSchemasOperSumMap = this.selectSchemaOperSumLog(new ArrayList<Long>(receiversMap.keySet()), lastDayTime.getTime());
                ArrayList<MessageInfo> waitingMessageList = new ArrayList<MessageInfo>(receiversMap.size());
                for (Row intellSchema2 : intellSchemasSet) {
                    List receivers = receiversMap.getOrDefault(intellSchema2.getLong("id"), new ArrayList());
                    String msgSendTypes = intellSchema2.getString("notificationtypes");
                    if (receivers.isEmpty() || !StringUtils.isNotEmpty((CharSequence)msgSendTypes)) continue;
                    long schemaId = intellSchema2.getLong("id");
                    Map operSumMap = intellSchemasOperSumMap.getOrDefault(schemaId, new HashMap(2));
                    long failLogCnt = operSumMap.getOrDefault("failsumqty", 0L);
                    long finishedLogCnt = operSumMap.getOrDefault("successsumqty", 0L);
                    String sendConditions = intellSchema2.getString("notificationconditions");
                    if (!this.isNeedSendNotification(sendConditions, failLogCnt, finishedLogCnt)) continue;
                    String schemaName = intellSchema2.getString("name");
                    String msgContent = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u622a\u6b62%1\u70b9\uff0c\u667a\u80fd\u65b9\u6848[%2]\u6210\u529f%3\u6761\u6570\u636e\uff0c\u5931\u8d25%4\u6761\u6570\u636e\u3002", (String)"PlanExecutionSummarySendTask_0", (String)"fi-iep-formplugin", (Object[])new Object[0]), (String)"PlanExecutionSummarySendTask_1", (String)"fi-iep-formplugin", (Object[])new Object[]{curHour, schemaName, finishedLogCnt, failLogCnt});
                    String[] channelStrs = intellSchema2.getString("notificationtypes").split(",");
                    ArrayList<MessageChannels> effectiveChannels = new ArrayList<MessageChannels>();
                    for (String channleItem : channelStrs) {
                        Optional<MessageChannels> validatedChannel;
                        Object paramValue = paramMap.get(channleItem);
                        if (Objects.nonNull(paramValue) && "0".equals(paramValue.toString()) || !(validatedChannel = this.channelNumberOf(channleItem)).isPresent()) continue;
                        effectiveChannels.add(validatedChannel.get());
                    }
                    if (effectiveChannels.isEmpty()) {
                        LOG.warn(String.format("for intell schema: %s[%s], No effective message channel available.", schemaName, schemaId));
                        continue;
                    }
                    MessageInfo waitingMessage = this.buildMessage(schemaId, msgContent, receivers, effectiveChannels);
                    waitingMessage.setSenderId(intellSchema2.getLong("executor"));
                    waitingMessageList.add(waitingMessage);
                }
                if (waitingMessageList.size() <= 0) break block25;
                try {
                    Map sendMsgResult = MessageCenterServiceHelper.batchSendMessages(waitingMessageList);
                    boolean success = (Boolean)sendMsgResult.get("success");
                    String description = (String)sendMsgResult.get("description");
                    LOG.info(String.format("successToSendMessagePlanExecutionSummarySendTask: waitingMessageList.size: %s, success: %s, description: %s", waitingMessageList.size(), success, description));
                    Map data = sendMsgResult.getOrDefault("data", new HashMap());
                    if (!data.isEmpty()) {
                        List successMsgIds = data.getOrDefault("successMsgIds", new ArrayList());
                        for (Long successMsgId : successMsgIds) {
                            LOG.info(String.format("successToSendMessagePlanExecutionSummarySendTask-success: %s, messageID: %s", null, successMsgId));
                        }
                        Map failMsgs = data.getOrDefault("failMsgs", new HashMap());
                        for (Map.Entry failMsg : failMsgs.entrySet()) {
                            MessageInfo failMessageInfo = (MessageInfo)failMsg.getKey();
                            String failDescription = (String)failMsg.getValue();
                            LOG.info(String.format("successToSendMessagePlanExecutionSummarySendTask-fail: %s, messageID: %s, description: %s", JSONUtils.toString((Object)failMessageInfo), failMessageInfo.getId(), failDescription));
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        LOG.error("FailedSendMessagePlanExecutionSummarySendTask: " + JSONUtils.toString(waitingMessageList));
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to parse message: " + waitingMessageList);
                    }
                }
            }
        }
    }

    private Map<String, Long> selectSchemaOperSumLog(Long intellSchemaId, Date beginTime) {
        return (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select sum(fsuccessbillqty) successsumqty,sum(ffailbillqty) failsumqty from  t_gl_intellopersumlog where fintelschemaid = ? and fexecenddate > ?;", (Object[])new Object[]{intellSchemaId, beginTime}, (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                HashMap<String, Long> resultMap = new HashMap<String, Long>(2);
                while (rs.next()) {
                    resultMap.put("successsumqty", rs.getLong("successsumqty"));
                    resultMap.put("failsumqty", rs.getLong("failsumqty"));
                }
                return resultMap;
            }
        });
    }

    private Map<Long, Map<String, Long>> selectSchemaOperSumLog(final List<Long> intellSchemaIds, Date beginTime) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select sum(fsuccessbillqty) successsumqty,sum(ffailbillqty) failsumqty,fintelschemaid from  t_gl_intellopersumlog where ", new Object[0]);
        sqlBuilder.appendIn(" fintelschemaid ", new ArrayList<Long>(intellSchemaIds));
        sqlBuilder.append(" and fexecenddate > ? ", new Object[]{beginTime});
        sqlBuilder.append(" group by fintelschemaid;", new Object[0]);
        return (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Long>>>(){

            public Map<Long, Map<String, Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Long>> resultMap = new HashMap<Long, Map<String, Long>>(intellSchemaIds.size());
                while (rs.next()) {
                    HashMap<String, Long> map = new HashMap<String, Long>(2);
                    map.put("successsumqty", rs.getLong("successsumqty"));
                    map.put("failsumqty", rs.getLong("failsumqty"));
                    resultMap.put(rs.getLong("fintelschemaid"), map);
                }
                return resultMap;
            }
        });
    }

    private boolean isNeedSendNotification(String sendConditions, long failedCnt, long finishedCnt) {
        if (StringUtils.isEmpty((CharSequence)sendConditions)) {
            return false;
        }
        List<String> conditionList = Arrays.asList(sendConditions.split(","));
        if (failedCnt > 0L && conditionList.contains("fail")) {
            return true;
        }
        return finishedCnt > 0L && conditionList.contains("success");
    }

    private MessageInfo buildMessage(Long schemaId, String msgContent, List<Long> receiveUserIds, List<MessageChannels> sendChannels) {
        MessageInfo message = new MessageInfo();
        message.setTitle(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u6267\u884c\u63d0\u9192", (String)"PlanExecutionSummarySendTask_1", (String)"fi-iep-formplugin", (Object[])new Object[0]));
        message.setContent(msgContent);
        LocaleString tag = new LocaleString();
        message.setMessageTag((ILocaleString)tag);
        message.setTag(ResManager.loadKDString((String)"\u7d27\u6025", (String)"PlanExecutionSummarySendTask_2", (String)"fi-iep-formplugin", (Object[])new Object[0]));
        message.setUserIds(receiveUserIds);
        message.setType("alarm");
        message.setEntityNumber("gl_intellexecschema");
        message.setOperation("modify");
        message.setBizDataId(schemaId);
        message.setPubaccNumber("flowassist");
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + String.format("/index.html?formId=%s&type=base&&pkId=%s&caption=%s", "gl_intellexecschema", schemaId, ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97\u65b9\u6848", (String)"PlanExecutionSummarySendTask_3", (String)"fi-iep-formplugin", (Object[])new Object[0]));
        message.setContentUrl(contentUrl);
        message.setNotifyType(StringUtils.join((Object[])sendChannels.stream().map(MessageChannels::getNumber).distinct().toArray(), (String)","));
        return message;
    }

    private Optional<MessageChannels> channelNumberOf(String number) {
        for (MessageChannels channel : MessageChannels.values()) {
            if (!channel.getNumber().equals(number)) continue;
            return Optional.of(channel);
        }
        return Optional.empty();
    }
}

