/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.mvc.list.ListDataProvider;
import kd.fi.iep.dao.FormDesignDao;

public class BussinessAndOperProvider
extends ListDataProvider {
    private Map<String, String> billOperMap = new HashMap<String, String>();
    private Map<String, String> formMap = new HashMap<String, String>();

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection col = super.getData(start, limit);
        if (col != null && col.size() > 0) {
            Map<String, String> periodCloseMap = FormDesignDao.getPeriodCloseForm(null);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject dynamicObject = (DynamicObject)col.get(i);
                String bill = dynamicObject.getString("bussiness");
                String oper = dynamicObject.getString("oper");
                if (bill == null || oper == null) continue;
                dynamicObject.set("bussiness", (Object)this.getFormNameZHCN(periodCloseMap, bill));
                dynamicObject.set("oper", (Object)this.getOperNameZHCN(bill, oper));
            }
        }
        return col;
    }

    private String getFormNameZHCN(Map<String, String> periodCloseMap, String bill) {
        String value = this.formMap.get(bill);
        if (value != null) {
            return value;
        }
        String name = periodCloseMap.get(bill);
        if (name == null) {
            name = FormDesignDao.getFormName(bill);
        }
        this.formMap.put(bill, name);
        return name;
    }

    private String getOperNameZHCN(String bill, String oper) {
        String key = this.createKey(bill, oper);
        String value = this.billOperMap.get(key);
        if (value != null) {
            return value;
        }
        String name = FormDesignDao.getOperationNameWithVoucher(bill, oper);
        this.billOperMap.put(key, name);
        return name;
    }

    private String createKey(String bill, String oper) {
        return bill + "_" + oper;
    }
}

