/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IntelExecShemaCalculate {
    private Set<Long> schemaIdSet;
    private static final Log log = LogFactory.getLog(IntelExecShemaCalculate.class);

    public IntelExecShemaCalculate(Set<Long> schemaIdSet) {
        this.schemaIdSet = schemaIdSet;
    }

    public IntelExecShemaCalculate(Long[] schemaIds) {
        this.schemaIdSet = new HashSet<Long>(schemaIds.length);
        Collections.addAll(this.schemaIdSet, schemaIds);
    }

    public List<Date> parserSehedulePlan(String cron, Date preDate, Date starttime) {
        return this.getDateListNew(cron);
    }

    private List<Date> getDateListNew(String cron) {
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(cron));
        Optional timeOptional = executionTime.nextExecution(ZonedDateTime.now());
        Calendar today = Calendar.getInstance();
        ArrayList<Date> intellExecuteDateList = new ArrayList<Date>(16);
        while (timeOptional.isPresent()) {
            ZonedDateTime dateTime = (ZonedDateTime)timeOptional.get();
            Date date = Date.from(dateTime.toInstant());
            Calendar instance = Calendar.getInstance();
            instance.setTime(date);
            if (instance.get(6) != today.get(6)) break;
            timeOptional = executionTime.nextExecution((ZonedDateTime)timeOptional.get());
            intellExecuteDateList.add(date);
        }
        return intellExecuteDateList;
    }
}

