/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.ConvertPath;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.info.DynamicParamModel;
import kd.fi.iep.info.ParamEntry;
import kd.fi.iep.util.IntelAccountingConstant;
import kd.fi.iep.util.StringUtils;

public class IntellExecSchemaUtil {
    public static final String BILL_NAME = "IntellCanExecute";
    public static final String FORM_FA_INITCARD_INIT = "fa_initcard_fin";
    private static final Set<String> FILTER_OPERS = new HashSet<String>(){
        private static final long serialVersionUID = -253044767116699695L;
        {
            this.add("new");
            this.add("modify");
            this.add("save");
            this.add("close");
            this.add("option");
            this.add("print");
            this.add("submitandnew");
            this.add("view");
            this.add("printsetting");
            this.add("refresh");
            this.add("copy");
            this.add("assign");
        }
    };

    public static void setBussinessComnoByData(PropertyChangedArgs e, IFormView view) {
        ChangeData[] cd = e.getChangeSet();
        if (cd[0].getNewValue() != null) {
            DynamicObject appObj = (DynamicObject)cd[0].getNewValue();
            IntellExecSchemaUtil.setBussinessComnoByData(String.valueOf(appObj.get("id")), view);
        }
    }

    public static void setBussinessComnoByData(String appid, IFormView view) {
        ArrayList<String> bizAppIds = new ArrayList<String>();
        bizAppIds.add(appid);
        DynamicObjectCollection extBizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)appid)});
        for (DynamicObject extBizApp : extBizApps) {
            bizAppIds.add(extBizApp.getString("id"));
        }
        String s = IntellExecSchemaUtil.getQuerySQL(bizAppIds.size());
        String sql = "SELECT DISTINCT e.fnumber number FROM t_meta_entity e LEFT JOIN t_meta_bizunitrelform b ON e.fid = b.FFORMID WHERE b.FBIZAPPID in " + s;
        List dataSet = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])bizAppIds.toArray(), rh -> {
            ArrayList<String> dataList = new ArrayList<String>();
            String number = null;
            block0: while (rh.next()) {
                number = rh.getString("number");
                Object opts = null;
                List ops = EntityMetadataCache.getDataEntityOperate((String)number);
                for (Map each : ops) {
                    opts = each.get("opbiz");
                    if (opts == null) continue;
                    List oos = opts;
                    for (String eac : oos) {
                        if (eac.indexOf(BILL_NAME) <= -1) continue;
                        dataList.add(number);
                        continue block0;
                    }
                }
            }
            return dataList;
        });
        List<String> dapBill = IntellExecSchemaUtil.getDapBillEntitys(bizAppIds);
        for (String string : dapBill) {
            if (dataSet.contains(string)) continue;
            dataSet.add(string);
        }
        List<ConvertPath> paths = IntellExecSchemaUtil.loadAllConvertPaths(bizAppIds);
        block2: for (ConvertPath convertPath : paths) {
            String sourceNumber = convertPath.getSourceEntityNumber();
            if (dataSet.contains(sourceNumber)) continue;
            List ops = EntityMetadataCache.getDataEntityOperate((String)sourceNumber);
            Map<String, String> operMap = FormDesignDao.getFormOperMap(sourceNumber);
            for (Map operMpas : ops) {
                if (!operMpas.get("type").equals("pushandsave") || operMap.get(operMpas.get("key")) == null) continue;
                dataSet.add(sourceNumber);
                continue block2;
            }
        }
        ArrayList<ComboItem> arrayList = new ArrayList<ComboItem>(dataSet.size());
        for (String business : dataSet) {
            ComboItem comboItem = new ComboItem();
            LocaleString name = new LocaleString(ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"IntellExecSchemaUtil_0", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            name = "gl_initaccountbalance".equals(business) ? new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u521d\u59cb\u4f59\u989d", (String)"IntellExecSchemaUtil_1", (String)"fi-iep-formplugin", (Object[])new Object[0])) : new LocaleString(FormDesignDao.getFormNameWithPeriodClose(business, appid));
            comboItem.setValue(business);
            comboItem.setCaption(name);
            arrayList.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)view.getControl("bussiness");
        comboEdit.setComboItems(arrayList);
        ComboEdit operCombo = (ComboEdit)view.getControl("oper");
        operCombo.setComboItems(new ArrayList());
    }

    private static String getQuerySQL(int size) {
        StringBuilder sb = new StringBuilder();
        sb.append("(?");
        for (int i = 0; i < size - 1; ++i) {
            sb.append(",?");
        }
        return sb.append(")").toString();
    }

    public static List<String> getDapBillEntitys(List<String> appIds) {
        QFilter qf = new QFilter("isdap", "=", (Object)Boolean.TRUE);
        QFilter qf2 = new QFilter("billentity.bizappid", "in", appIds);
        DynamicObjectCollection dapconfigs = QueryServiceHelper.query((String)"ai_dapconfig", (String)"id,isdap,billentity", (QFilter[])new QFilter[]{qf, qf2});
        ArrayList<String> bills = new ArrayList<String>();
        for (DynamicObject dapconfig : dapconfigs) {
            bills.add(dapconfig.getString("billentity"));
        }
        return bills;
    }

    private static List<ConvertPath> loadAllConvertPaths(List<String> appIds) {
        String localeId = Lang.get().toString();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.FSourceEntityNumber, t1_l.FName AS FSourceEntityName ");
        sBuilder.append("      ,t0.FTargetEntityNumber, t2_l.FName AS FTargetEntityName ");
        sBuilder.append("      ,t0.FBizAppId ");
        sBuilder.append("      ,t1.FBizAppId AS FSourceBizAppId, t2.FBizAppId AS FTargetBizAppId ");
        sBuilder.append("FROM T_BOTP_ConvertRule t0 ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign t1 ON (t0.FSourceEntityNumber = t1.FNumber) ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign t2 ON (t0.FTargetEntityNumber = t2.FNumber) ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign_L t1_l ON (t0.FSourceEntityNumber = t1_l.FNumber and t1_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign_L t2_l ON (t0.FTargetEntityNumber = t2_l.FNumber and t2_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("WHERE t0.FType <> '2' AND t1.FBizAppId in (").append(StringUtils.toSQLString(appIds)).append(")");
        ResultSetHandler<Set<ConvertPath>> action = new ResultSetHandler<Set<ConvertPath>>(){

            public Set<ConvertPath> handle(ResultSet rs) throws Exception {
                HashSet<ConvertPath> paths = new HashSet<ConvertPath>(rs.getRow());
                while (rs.next()) {
                    ConvertPath path = new ConvertPath();
                    path.setSourceEntityNumber(rs.getString("FSourceEntityNumber"));
                    path.setSourceEntityName(rs.getString("FSourceEntityName"));
                    path.setTargetEntityNumber(rs.getString("FTargetEntityNumber"));
                    path.setTargetEntityName(rs.getString("FTargetEntityName"));
                    path.setBizAppId(rs.getString("FBizAppId"));
                    path.setSourceBizAppId(rs.getString("FSourceBizAppId"));
                    path.setTargetBizAppId(rs.getString("FTargetBizAppId"));
                    paths.add(path);
                }
                return paths;
            }
        };
        Set convertPaths = (Set)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), null, (ResultSetHandler)action);
        return new ArrayList<ConvertPath>(convertPaths);
    }

    public static String setOperComboListOperByData(PropertyChangedArgs e, IFormView view) {
        view.getModel().setValue("oper", null);
        ChangeData[] cd = e.getChangeSet();
        String number = (String)cd[0].getNewValue();
        if (number == null) {
            return number;
        }
        return IntellExecSchemaUtil.setOperComboByData(number, view);
    }

    public static String getRealEntity(String formId) {
        return formId;
    }

    public static String setOperComboByData(String formId, IFormView view) {
        String type;
        String operKey2;
        List ops;
        String os;
        String sql = "SELECT DISTINCT e.fnumber number, e.fkey oper FROM t_meta_entity e LEFT JOIN t_meta_bizunitrelform b ON e.fid = b.FFORMID left join t_meta_formdesign c on c.fentityid = e.fid WHERE c.fnumber = ?";
        Object[] dataResult = (Object[])DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new String[]{formId}, rh -> {
            Object[] result = new Object[2];
            String realFormId = null;
            HashSet<String> dataList = new HashSet<String>();
            while (rh.next()) {
                if (realFormId == null) {
                    realFormId = rh.getString("number");
                }
                Object opts = null;
                List ops = EntityMetadataCache.getDataEntityOperate((String)realFormId);
                block1: for (Map each : ops) {
                    opts = each.get("opbiz");
                    if (opts == null) continue;
                    List oos = opts;
                    for (String eac : oos) {
                        if (eac.indexOf(BILL_NAME) <= -1) continue;
                        dataList.add(each.get("key").toString());
                        continue block1;
                    }
                }
            }
            result[0] = realFormId;
            result[1] = dataList;
            return result;
        });
        Object tempEntity = dataResult[0];
        if (tempEntity != null && kd.bos.util.StringUtils.isNotEmpty((String)(os = tempEntity.toString()))) {
            formId = os;
        }
        Set dataSet = (Set)dataResult[1];
        Map<String, String> operMap = FormDesignDao.getFormOperMap(formId);
        String bizappId = ((DynamicObject)view.getModel().getValue("bizapp")).getString("id");
        ArrayList<String> appIds = new ArrayList<String>(1);
        appIds.add(bizappId);
        List<ConvertPath> paths = IntellExecSchemaUtil.loadAllConvertPaths(appIds);
        ArrayList<String> pathBill = new ArrayList<String>(paths.size());
        for (ConvertPath path : paths) {
            pathBill.add(path.getSourceEntityNumber());
        }
        boolean hasBuildVoucher = false;
        if (pathBill.contains(formId)) {
            ops = EntityMetadataCache.getDataEntityOperate((String)formId);
            for (Object operMpas : ops) {
                operKey2 = operMpas.get("key").toString();
                type = operMpas.get("type").toString();
                if (!"pushandsave".equals(type) && (!"generatevoucher".equals(type) || FORM_FA_INITCARD_INIT.equals(formId))) continue;
                dataSet.add(operKey2);
            }
        }
        ops = EntityMetadataCache.getDataEntityOperate((String)formId);
        for (Object operMpas : ops) {
            operKey2 = operMpas.get("key").toString();
            type = operMpas.get("type").toString();
            if (!"generatevoucher".equals(type) || FORM_FA_INITCARD_INIT.equals(formId)) continue;
            hasBuildVoucher = true;
            dataSet.add(operKey2);
            operMap.put("generatevoucher", IntelAccountingConstant.getGENVOUCHER());
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(dataSet.size() + ops.size() + 1);
        for (String operKey2 : dataSet) {
            if (operKey2.isEmpty() || FILTER_OPERS.contains(operKey2)) continue;
            String nameStr = operMap.get(operKey2);
            if (kd.bos.util.StringUtils.isEmpty((String)nameStr)) {
                nameStr = operKey2;
            }
            LocaleString name = new LocaleString(nameStr);
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(operKey2);
            comboItem.setCaption(name);
            list.add(comboItem);
        }
        if (!hasBuildVoucher && IntellExecSchemaUtil.isDapBillEntitys(formId)) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue("buildvoucher");
            comboItem.setCaption(new LocaleString(IntelAccountingConstant.getGENVOUCHER()));
            list.add(comboItem);
        }
        ComboEdit combo = (ComboEdit)view.getControl("oper");
        combo.setComboItems(list);
        if (list.size() > 0) {
            combo.selectedStore((ComboItem)list.get(0));
        }
        return formId;
    }

    private static boolean isDapBillEntitys(String formId) {
        QFilter qf = new QFilter("isdap", "=", (Object)Boolean.TRUE);
        QFilter qf2 = new QFilter("billentity.id", "=", (Object)formId);
        boolean isDap = QueryServiceHelper.exists((String)"ai_dapconfig", (QFilter[])new QFilter[]{qf, qf2});
        return isDap;
    }

    public static List<DynamicParamModel> getParamList(QFilter[] qf) {
        String selectors = "bizapp,bussiness,oper,entryentity.id,entryentity.param,entryentity.paramname,entryentity.comboval,entryentity.require,entryentity.paramval,entryentity.paramdesc,entryentity.paramtype";
        DynamicObject[] paramCol = BusinessDataServiceHelper.load((String)"gl_intellexecparam", (String)selectors, (QFilter[])qf);
        ArrayList<DynamicParamModel> list = new ArrayList<DynamicParamModel>(paramCol.length);
        for (DynamicObject paramObj : paramCol) {
            DynamicParamModel model = new DynamicParamModel();
            DynamicObject app = paramObj.getDynamicObject("bizapp");
            model.setAppId(app == null ? "" : app.getPkValue().toString());
            model.setBusiness(paramObj.getString("bussiness"));
            model.setOper(paramObj.getString("oper"));
            DynamicObjectCollection entrys = paramObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                ParamEntry paramEntry = new ParamEntry();
                paramEntry.setId(entry.getString("id"));
                paramEntry.setNumber(entry.getString("param"));
                paramEntry.setName(entry.getString("paramname"));
                paramEntry.setRequire(entry.getBoolean("require"));
                paramEntry.setParamval(entry.getString("paramval"));
                paramEntry.setParamdesc(entry.getString("paramdesc"));
                paramEntry.setParamtype(entry.getString("paramtype"));
                paramEntry.setComboVal((Object)entry.getString("comboval"));
                model.addParams(paramEntry);
            }
            list.add(model);
        }
        return list;
    }

    public static boolean isGenerateVoucherOperation(String bussiness, String operationName) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)bussiness);
        for (Map each : ops) {
            String operationkey = String.valueOf(each.get("key"));
            String type = String.valueOf(each.get("type"));
            if (!Objects.nonNull(operationkey) || !operationkey.equals(operationName)) continue;
            return "buildvoucher".equals(type) || "generatevoucher".equals(type);
        }
        return false;
    }

    public static boolean isPushandsaveOperation(String bussiness, String operationName) {
        Map each = null;
        try {
            each = EntityMetadataCache.getDataEntityOperate((String)bussiness, (String)operationName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return each != null && "pushandsave".equals(each.get("type"));
    }
}

