/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.mvc.list.ListDataProvider;
import kd.fi.iep.info.IntellSchemeExecInfo;

public class IntellSchemaAndDetailsProvider
extends ListDataProvider {
    private static final CacheConfigInfo localConfig = new CacheConfigInfo();

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection col = super.getData(start, limit);
        List intelschemaIds = col.stream().map(dyn -> dyn.getLong("intelschemaid.id")).collect(Collectors.toList());
        col.forEach(dyn -> {
            IntellSchemeExecInfo instance;
            Long intelSchemaId;
            if (dyn.get("execstatus").equals("1") && Objects.nonNull(intelSchemaId = (Long)dyn.get("intelschemaid.id")) && Objects.nonNull(instance = IntellSchemeExecInfo.getInstance((long)intelSchemaId))) {
                dyn.set("executedetails", (Object)instance.getExecDetails());
            }
        });
        return col;
    }

    private Map<Long, Integer> getSchemeFailSumCount() {
        LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("gl_intellschemalog", "schemeIdByfailCount", localConfig);
        HashMap cacheMap = (HashMap)localcache.get("schemeIdByfailCount");
        if (Objects.isNull(cacheMap)) {
            HashMap schemeIdByfailCount = new HashMap(10);
            DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"select count(1) failSumPkIdSize,fintelschemaid from t_gl_intellschemalog where fsrcbillid > 0 group by fintelschemaid;", rs -> {
                while (rs.next()) {
                    schemeIdByfailCount.put(rs.getLong("fintelschemaid"), rs.getInt("failSumPkIdSize"));
                }
                return null;
            });
            localcache.put("schemeIdByfailCount", schemeIdByfailCount);
            cacheMap = schemeIdByfailCount;
        }
        return cacheMap;
    }

    private Map<Long, Integer> getSchemeFailSumCount(List<Long> intelschemaIds) {
        if (intelschemaIds.size() == 0) {
            return new HashMap<Long, Integer>();
        }
        HashMap<Long, Integer> schemeIdByfailCount = new HashMap<Long, Integer>(intelschemaIds.size());
        String joinIntelschemaIds = StringUtils.join((Object[])intelschemaIds.toArray(), (String)",");
        DB.query((DBRoute)DBRoute.of((String)"fi"), (String)("select count(1) failSumPkIdSize,fintelschemaid from t_gl_intellschemalog where fintelschemaid in (" + joinIntelschemaIds + ") and fsrcbillid > 0 group by fintelschemaid;"), rs -> {
            while (rs.next()) {
                schemeIdByfailCount.put(rs.getLong("fintelschemaid"), rs.getInt("failSumPkIdSize"));
            }
            return null;
        });
        return schemeIdByfailCount;
    }

    static {
        localConfig.setMaxItemSize(100000);
        localConfig.setTimeout(60);
    }
}

