/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenBillUtils {
    private OpenBillUtils() {
    }

    public static void openSchema(IFormView view, DynamicObject dyn) {
        OpenBillUtils.openFormByPKId(view, dyn.getDynamicObject("intelschemaid").getLong("id"), "gl_intellexecschema");
    }

    public static void openExecOperLog(IFormView view, DynamicObject dyn) {
        QFilter filter = new QFilter("schemasumlogid", "=", (Object)dyn.getLong("id"));
        OpenBillUtils.openBillList(view, "gl_intellopersumlog", filter, null);
    }

    public static void openExecOperDetailLog(IFormView view, DynamicObject dyn) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("intelschemaid", dyn.getLong("intelschemaid.id"));
        params.put("intelschemasumlogid", dyn.getLong("id"));
        OpenBillUtils.openBillList(view, "iep_intellexecdetaillog", null, params);
    }

    public static void openExecOperDetailLogByOper(IFormView view, DynamicObject dyn) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("intelschemaid", dyn.getLong("intelschemaid.id"));
        params.put("intelschemasumlogid", dyn.getLong("schemasumlogid"));
        QFilter filter = new QFilter("opersumlogid", "=", (Object)dyn.getLong("id"));
        OpenBillUtils.openBillList(view, "iep_intellexecdetaillog", filter, params);
    }

    public static void openExecDetailLog(IFormView view, DynamicObject dyn) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        qfilters.add(new QFilter("intelschemaid", "=", (Object)dyn.getLong("intelschemaid.id")));
        qfilters.add(new QFilter("srcbillid", "!=", (Object)0));
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("intelschemaid", dyn.getLong("intelschemaid.id"));
        OpenBillUtils.openBillErrorList(view, "iep_intellexecdetaillog", qfilters, params);
    }

    private static void openBillErrorList(IFormView view, String formKey, List<QFilter> qfilters, Map<String, Object> params) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formKey);
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        ListFilterParameter filterParameter = new ListFilterParameter();
        if (Objects.nonNull(qfilters)) {
            filterParameter.setQFilters(qfilters);
        }
        parameter.setListFilterParameter(filterParameter);
        if (Objects.nonNull(params)) {
            parameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)parameter);
    }

    private static void openBillList(IFormView view, String formKey, QFilter filter, Map<String, Object> params) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formKey);
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        ListFilterParameter filterParameter = new ListFilterParameter();
        if (Objects.nonNull(filter)) {
            filterParameter.getQFilters().add(filter);
        }
        parameter.setListFilterParameter(filterParameter);
        if (Objects.nonNull(params)) {
            parameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)parameter);
    }

    private static void openFormByPKId(IFormView view, Object pkId, String bussiness) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(bussiness);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)parameter);
    }

    public static boolean isExistSchedule(Object pkId, String scheduleId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"gl_intellexecschema");
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((Object[])new Object[]{pkId}, (DynamicObjectType)type);
        Object sheduleplanid = scheduleId;
        if (Objects.nonNull(dobjs) && dobjs.length > 0) {
            sheduleplanid = dobjs[0].get("sheduleplanid");
        }
        QFilter qf = new QFilter("id", "=", sheduleplanid);
        DynamicObject jobDb = QueryServiceHelper.queryOne((String)"sch_schedule", (String)"job", (QFilter[])new QFilter[]{qf});
        return Objects.nonNull(jobDb);
    }
}

