/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.iep.cache.LastDateCache;
import kd.fi.iep.info.IntellAcaountExeInfo;
import kd.fi.iep.util.IntelExecShemaCalculate;

public class ScheduleCalculateUtil {
    public static List<IntellAcaountExeInfo> execShemaCalculate(long schemaId) {
        ArrayList<IntellAcaountExeInfo> dataList = new ArrayList<IntellAcaountExeInfo>();
        DynamicObject cols = BusinessDataServiceHelper.loadSingleFromCache((Object)schemaId, (String)"gl_intellexecschema", (String)"id,sheduleplanid");
        if (cols == null) {
            return dataList;
        }
        DynamicObject shedulePlan = BusinessDataServiceHelper.loadSingleFromCache((Object)cols.getString("sheduleplanid"), (String)"sch_schedule", (String)"id,plan,starttime,endtime");
        if (shedulePlan == null) {
            return dataList;
        }
        HashSet<Long> schemaIdSet = new HashSet<Long>();
        schemaIdSet.add(schemaId);
        IntelExecShemaCalculate intellCal = new IntelExecShemaCalculate(schemaIdSet);
        ScheduleCalculateUtil.calcute(dataList, intellCal, shedulePlan, schemaId);
        return dataList;
    }

    public static List<IntellAcaountExeInfo> execShemaCalculate(Long[] schemaIds) {
        ArrayList<IntellAcaountExeInfo> dataList = new ArrayList<IntellAcaountExeInfo>();
        if (schemaIds == null || schemaIds.length == 0) {
            return dataList;
        }
        Map cols = BusinessDataServiceHelper.loadFromCache((Object[])schemaIds, (String)"gl_intellexecschema");
        if (cols == null) {
            return dataList;
        }
        HashMap<String, Long> planScheduleMap = new HashMap<String, Long>();
        HashSet<String> scheduleIds = new HashSet<String>(cols.size());
        String scheduleId = "";
        for (Map.Entry id : cols.entrySet()) {
            DynamicObject schema = (DynamicObject)cols.get(id.getKey());
            if (schema == null) continue;
            scheduleId = schema.getString("sheduleplanid");
            planScheduleMap.put(scheduleId, (Long)id.getKey());
            scheduleIds.add(scheduleId);
        }
        Map sheduleMap = BusinessDataServiceHelper.loadFromCache((Object[])scheduleIds.toArray(), (String)"sch_schedule");
        if (sheduleMap == null) {
            return dataList;
        }
        IntelExecShemaCalculate intellCal = new IntelExecShemaCalculate(schemaIds);
        DynamicObject shedulePlan = null;
        long schemaId = 0L;
        for (Map.Entry id : sheduleMap.entrySet()) {
            shedulePlan = (DynamicObject)sheduleMap.get(id.getKey());
            schemaId = (Long)planScheduleMap.get(id.getKey());
            ScheduleCalculateUtil.calcute(dataList, intellCal, shedulePlan, schemaId);
        }
        return dataList;
    }

    private static void calcute(List<IntellAcaountExeInfo> dataList, IntelExecShemaCalculate intellCal, DynamicObject shedulePlan, Long schemaId) {
        List<Date> intellExecuteDateList;
        Date preDate = new Date();
        Date lastdate = LastDateCache.get(schemaId);
        if (lastdate != null) {
            preDate = lastdate;
        }
        if ((intellExecuteDateList = intellCal.parserSehedulePlan(shedulePlan.getString("plan"), preDate, shedulePlan.getDate("starttime"))) == null || intellExecuteDateList.isEmpty()) {
            return;
        }
        Date endtime = shedulePlan.getDate("endtime");
        Date nowtime = new Date();
        for (Date date : intellExecuteDateList) {
            if (nowtime.compareTo(date) > 0 || date.compareTo(endtime) >= 0) continue;
            dataList.add(new IntellAcaountExeInfo(schemaId.longValue(), date, "0"));
        }
    }
}

