/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.accsys;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AccountBookInfo
implements Serializable {
    private static final long serialVersionUID = -451463358628060096L;
    private long id;
    private long org;
    private long bookstype;
    private String bookstypeNum;
    private long basecurrency;
    private long periodtype;
    private long startperiod;
    private long curperiod;
    private long exratetable;
    private long accounttable;
    private long cashinitperiod;
    private long accountingsys;
    private boolean isendinit;
    private String enable;
    private boolean isbizunit;
    private static final String selectFields = "org,bookstype,bookstype.number,basecurrency,periodtype,startperiod,curperiod,exratetable,accounttable,cashinitperiod,isendinit,enable,isbizunit,accountingsys";

    public AccountBookInfo(String orgNum, String booktypeNum) {
        QFilter qorg = new QFilter("org.number", "=", (Object)orgNum);
        QFilter qbooktype = new QFilter("bookstype.number", "=", (Object)booktypeNum);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{qorg, qbooktype});
        if (obj == null) {
            return;
        }
        this.initVal(obj);
    }

    public AccountBookInfo(long orgId, long bookTypeId) {
        QFilter qorg = new QFilter("org", "=", (Object)orgId);
        QFilter qbooktype = new QFilter("bookstype", "=", (Object)bookTypeId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{qorg, qbooktype});
        if (obj == null) {
            return;
        }
        this.initVal(obj);
    }

    private void initVal(DynamicObject obj) {
        this.id = obj.getLong("id");
        this.org = obj.getLong("org.id");
        this.bookstype = obj.getLong("bookstype.id");
        this.bookstypeNum = obj.getString("bookstype.number");
        this.accounttable = obj.getLong("accounttable.id");
        this.basecurrency = obj.getLong("basecurrency.id");
        this.periodtype = obj.getLong("periodtype.id");
        this.startperiod = obj.getLong("startperiod.id");
        this.curperiod = obj.getLong("curperiod.id");
        this.exratetable = obj.getLong("exratetable.id");
        this.cashinitperiod = obj.getLong("cashinitperiod.id");
        this.accountingsys = obj.getLong("accountingsys.id");
        this.isendinit = obj.getBoolean("isendinit");
        this.isbizunit = obj.getBoolean("isbizunit");
        this.enable = obj.getString("enable");
    }

    public AccountBookInfo(long bookId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)bookId, (String)"gl_accountbook", (String)selectFields);
        if (obj == null) {
            return;
        }
        this.initVal(obj);
    }

    public long getId() {
        return this.id;
    }

    public long getOrgId() {
        return this.org;
    }

    public long getBookTypeId() {
        return this.bookstype;
    }

    public String getBookTypeNum() {
        return this.bookstypeNum;
    }

    public long getBaseCurrencyId() {
        return this.basecurrency;
    }

    public long getPeriodTypeId() {
        return this.periodtype;
    }

    public long getStartPeriodId() {
        return this.startperiod;
    }

    public long getCurPeriodId() {
        return this.curperiod;
    }

    public long getCurPeriodId(long openedPeriodId) {
        if (openedPeriodId > 0L) {
            return openedPeriodId;
        }
        return this.curperiod;
    }

    public long getExrateTableId() {
        return this.exratetable;
    }

    public long getAccountTableId() {
        return this.accounttable;
    }

    public long getCashinitPeriodId() {
        return this.cashinitperiod;
    }

    public long getAccountingsysId() {
        return this.accountingsys;
    }

    public boolean isIsendinit() {
        return this.isendinit;
    }

    public String getEnable() {
        return this.enable;
    }

    public boolean isIsbizunit() {
        return this.isbizunit;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccountBookInfo) {
            return this.id == ((AccountBookInfo)obj).getId();
        }
        return false;
    }

    public String toString() {
        return "id:" + this.id + ";org:" + this.org + ";bookstype:" + this.bookstype + ";basecurrency:" + this.basecurrency + ";periodtype:" + this.periodtype + ";startperiod:" + this.startperiod + ";curperiod:" + this.curperiod + ";accounttable:" + this.accounttable + ";exratetable:" + this.exratetable + ";cashinitperiod:" + this.cashinitperiod + ";isendinit:" + this.isendinit + ";enable:" + this.enable;
    }
}

