/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.dataclear;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class BusinessTaskDataClear
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(BusinessTaskDataClear.class);
    private static final String QUERY_SQL_COUNT = "select count(*) from t_gl_businesstask;";
    private static final String QUERY_SQL = "select fbusiness ,foper ,fentityid from t_gl_businesstask;";
    private static final String QUERY_BIZ_BILL_SQL = " select fid,fcreatetime from %s where fid in ( %s )";
    private static final String QUERY_BIZ_BILL_NOCREATETIME_SQL = " select fid from %s where fid in ( %s )";
    private static final String QUERY_REPEAT_SQL = " select MAX(fid) fid from t_gl_businesstask where fentityid in ( %s ) and fbusiness =  '%s' group by fbusiness,fentityid having count(*) > 1;";
    private static final String QUERY_DAP_SQL = "select fsourcebillid from t_ai_daptracker where fsourcebillid in ( %s ) and fbilltype = '%s'";
    private static final String DELETE_SQL = "delete from t_gl_businesstask  where fentityid in (%s) and fbusiness = '%s';";
    private static final String DELETE_REPEAT_SQL = "delete from t_gl_businesstask  where fentityid in (%s) and fbusiness = '%s' and fid not in (%s);";
    private Date lessDate;
    private Map<String, List<Long>> curBatchBillIdMap = null;
    private static final int BATCH_SIZE = 1000;
    private static ThreadPool threadPoolCash = ThreadPools.newFixedThreadPool((String)"fi/iep/businesstaskclear", (int)5);

    public BusinessTaskDataClear(Date lessDate) {
        this.lessDate = lessDate;
    }

    public BusinessTaskDataClear(Date lessDate, Map<String, List<Long>> curBatchBillIdMap) {
        this.lessDate = lessDate;
        this.curBatchBillIdMap = curBatchBillIdMap;
    }

    public Boolean ExecuteSqlWithResult() {
        try {
            this.clearBusinessTask();
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    private void clearBusinessTask() {
        Row next;
        Long count;
        DataSet countDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)QUERY_SQL_COUNT);
        if (countDs.hasNext() && (count = (next = countDs.next()).getLong(0)) > 20000000L && Objects.isNull(this.lessDate)) {
            LOGGER.info("\u6570\u636e\u91cf{}\u8d85\u8fc72\u5343\u4e07\uff0c\u8bf7\u624b\u52a8\u6e05\u7406\u767d\u540d\u5355\u6570\u636e ", (Object)count);
            return;
        }
        try (DataSet ds = DB.queryDataSet((String)BusinessTaskDataClear.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)QUERY_SQL);){
            int i = 1;
            HashMap<String, List<Long>> mapBillIdMap = new HashMap<String, List<Long>>(16);
            while (ds.hasNext()) {
                Row next2 = ds.next();
                mapBillIdMap.compute(next2.getString("fbusiness"), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Long>(16);
                    }
                    v.add(next2.getLong("fentityid"));
                    return v;
                });
                if (i == 10000) {
                    i = 1;
                    this.batchClearBusinessTask(mapBillIdMap);
                    mapBillIdMap = new HashMap(16);
                }
                ++i;
            }
            this.batchClearBusinessTask(mapBillIdMap);
        }
    }

    private void batchClearBusinessTask(Map<String, List<Long>> curBatchBillIdMap) {
        if (curBatchBillIdMap.size() > 0) {
            LOGGER.info("\u672c\u6b21\u5f00\u59cb\u6e05\u7406\u6570\u636e\u5927\u5c0f{}", (Object)curBatchBillIdMap.size());
            threadPoolCash.execute((Runnable)new BusinessTaskDataClear(this.lessDate, curBatchBillIdMap));
        }
    }

    @Override
    public void run() {
        this.doClearBusinessTask(this.curBatchBillIdMap);
        this.curBatchBillIdMap.clear();
    }

    private void doClearBusinessTask(Map<String, List<Long>> mapBillIdMap) {
        for (Map.Entry<String, List<Long>> map : mapBillIdMap.entrySet()) {
            String bizBillKey = map.getKey();
            List<Long> entityiIdlst = map.getValue();
            int batch_index = (int)Math.ceil((double)entityiIdlst.size() * 1.0 / 1000.0);
            for (int i = 0; i < batch_index; ++i) {
                int toIndex = i == batch_index - 1 ? entityiIdlst.size() : 1000 * (i + 1);
                ArrayList<Long> curBatch = new ArrayList<Long>(entityiIdlst.subList(1000 * i, toIndex));
                LOGGER.info("\u5f00\u59cb\u6e05\u7406\u4e1a\u52a1\u7c7b\u578b{}\u5927\u5c0f{}", (Object)bizBillKey, (Object)curBatch.size());
                this.batchClearBusinessTask(curBatch, bizBillKey);
            }
        }
    }

    private void batchClearBusinessTask(List<Long> fentityiIdlst, String bizBillKey) {
        MainEntityType bizEntityType = this.deleteNoExitsNumber(fentityiIdlst, bizBillKey);
        if (Objects.nonNull(bizEntityType)) {
            Object next;
            String queryBizBillSql = String.format(QUERY_BIZ_BILL_SQL, bizEntityType.getAlias(), this.getStringByList(fentityiIdlst));
            if (Objects.isNull(bizEntityType.getAllFields().get("fcreatetime"))) {
                queryBizBillSql = String.format(QUERY_BIZ_BILL_NOCREATETIME_SQL, bizEntityType.getAlias(), this.getStringByList(fentityiIdlst));
            }
            ArrayList<Long> srcIdlst = new ArrayList<Long>(16);
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)bizEntityType.getDBRouteKey()), (String)queryBizBillSql);){
                while (ds.hasNext()) {
                    next = ds.next();
                    srcIdlst.add(next.getLong("fid"));
                }
            }
            fentityiIdlst.removeAll(srcIdlst);
            this.executeDelete(fentityiIdlst, bizBillKey);
            LOGGER.info("\u5220\u9664\u4e0d\u5b58\u5728\u6e90\u5355\u7684\u767d\u540d\u5355");
            if (srcIdlst.size() > 0) {
                String repeat = String.format(QUERY_REPEAT_SQL, this.getStringByList(srcIdlst), bizBillKey);
                DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)repeat);
                next = null;
                try {
                    ArrayList<Long> preserveIds = new ArrayList<Long>(16);
                    while (ds.hasNext()) {
                        Row next2 = ds.next();
                        preserveIds.add(next2.getLong("fid"));
                    }
                    this.executeDeleteRepeat(srcIdlst, bizBillKey, preserveIds);
                    LOGGER.info("\u5220\u9664\u91cd\u590d\u6570\u636e");
                }
                catch (Throwable preserveIds) {
                    next = preserveIds;
                    throw preserveIds;
                }
                finally {
                    if (ds != null) {
                        if (next != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable preserveIds) {
                                ((Throwable)next).addSuppressed(preserveIds);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                ArrayList<Long> dapBill = new ArrayList<Long>(16);
                String query_dap_sql = String.format(QUERY_DAP_SQL, this.getStringByList(srcIdlst), bizBillKey);
                try (DataSet ds2 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)query_dap_sql);){
                    while (ds2.hasNext()) {
                        Row next3 = ds2.next();
                        dapBill.add(next3.getLong("fsourcebillid"));
                    }
                    this.executeDelete(dapBill, bizBillKey);
                    LOGGER.info("\u5220\u9664\u5df2\u751f\u6210\u51ed\u8bc1,\u767d\u540d\u5355\u8fd8\u5b58\u5728\u7684\u6570\u636e");
                }
                if (Objects.nonNull(this.lessDate)) {
                    queryBizBillSql = queryBizBillSql + " and fcreatetime < ? ";
                    try {
                        ds2 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)bizEntityType.getDBRouteKey()), (String)queryBizBillSql, (Object[])new Object[]{this.lessDate});
                        var10_17 = null;
                        try {
                            ArrayList<Long> longTime = new ArrayList<Long>(16);
                            while (ds2.hasNext()) {
                                Row next4 = ds2.next();
                                longTime.add(next4.getLong("fid"));
                            }
                            this.executeDelete(longTime, bizBillKey);
                            LOGGER.info("\u5220\u9664\u957f\u65f6\u95f4\u4e0d\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e");
                        }
                        catch (Throwable throwable) {
                            var10_17 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (ds2 != null) {
                                if (var10_17 != null) {
                                    try {
                                        ds2.close();
                                    }
                                    catch (Throwable throwable) {
                                        var10_17.addSuppressed(throwable);
                                    }
                                } else {
                                    ds2.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Throwable)e);
                    }
                }
            }
            QFilter filter = new QFilter("entityid", "in", srcIdlst);
            filter.and("business", "=", (Object)"gl_voucher");
            DeleteServiceHelper.delete((String)"iep_businesstask", (QFilter[])filter.toArray());
        }
    }

    private MainEntityType deleteNoExitsNumber(List<Long> srcIdlst, String bizBillKey) {
        try {
            return EntityMetadataCache.getDataEntityType((String)bizBillKey);
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"BusinessTaskDataClear_0", (String)"fi-iep-common", (Object[])new Object[0]);
            if (ex.getMessage().contains(msg)) {
                this.executeDelete(srcIdlst, bizBillKey);
            }
            return null;
        }
    }

    private void executeDelete(List<Long> srcIdlst, String bizBillKey) {
        if (srcIdlst.size() > 0) {
            String delete_sql = String.format(DELETE_SQL, this.getStringByList(srcIdlst), bizBillKey);
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)delete_sql);
        }
    }

    private void executeDeleteRepeat(List<Long> srcIdlst, String bizBillKey, List<Long> preserveIds) {
        if (srcIdlst.size() > 0 && preserveIds.size() > 0) {
            String delete_repeat_sql = String.format(DELETE_REPEAT_SQL, this.getStringByList(srcIdlst), bizBillKey, this.getStringByList(preserveIds));
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)delete_repeat_sql);
        }
    }

    private String getStringByList(List<Long> idlst) {
        return StringUtils.join((Object[])idlst.toArray(), (String)",");
    }
}

