/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;

public class DataSetHelper {
    private DataSetHelper() {
    }

    public static DataSet createDatSet(Class clazz, List<String> fields, List<DataType> dataType, List<List<Object>> fValList) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[fields.size()]), (DataType[])dataType.toArray(new DataType[dataType.size()]));
        Algo algo = Algo.create((String)(Objects.isNull(clazz) ? "" : clazz.getName()));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (List<Object> row : fValList) {
            builder.append(row.toArray(new Object[row.size()]));
        }
        return builder.build();
    }

    public static List<Long> extractLongColumnValues(DataSet dataSet, String columnName, boolean isAddNullIfEmpty) {
        HashSet<Long> data = new HashSet<Long>(16);
        try (DataSet dsCopy = dataSet.copy();){
            dsCopy.forEach(x -> {
                if (Objects.isNull(x.get(columnName))) {
                    return;
                }
                Long v = Long.parseLong(x.get(columnName).toString());
                if (Objects.nonNull(v) && v > 0L) {
                    data.add(v);
                }
            });
        }
        if (data.isEmpty() && isAddNullIfEmpty) {
            data.add(0L);
        }
        return new ArrayList<Long>(data);
    }

    public static List<Object> extractColumnValues(DataSet dataSet, String columnName) {
        ArrayList<Object> data = new ArrayList<Object>(16);
        try (DataSet dsCopy = dataSet.copy();){
            dsCopy.forEach(x -> {
                Object v = x.get(columnName);
                if (Objects.nonNull(v)) {
                    data.add(v);
                }
            });
        }
        return data;
    }

    public static boolean isIdListEmpty(List<Long> ids) {
        return CollectionUtils.isEmpty(ids) || ids.size() == 1 && 0L == ids.get(0);
    }

    public static DataSet createEmptyDataSet() {
        return DataSetHelper.createDatSet(DataSetHelper.class, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static String printDataSet(DataSet dataSet, Integer maxRows) {
        if (Objects.isNull(dataSet)) {
            return "null";
        }
        if (Objects.isNull(maxRows)) {
            maxRows = 100;
        }
        int[] colWidths = null;
        int[] charMaxSizes = null;
        try (DataSet dataSetCopy = dataSet.copy();){
            RowMeta rowType = dataSetCopy.getRowMeta();
            colWidths = new int[rowType.getFields().length];
            charMaxSizes = new int[rowType.getFields().length];
            for (int i = 0; i < colWidths.length; ++i) {
                String colAlias = rowType.getFields()[i].getAlias();
                colWidths[i] = StringUtils.isEmpty((Object)colAlias) ? 10 : colAlias.length();
                charMaxSizes[i] = StringUtils.isEmpty((Object)colAlias) ? 10 : colAlias.length();
            }
            int rowIndex = 0;
            Iterator iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                for (int i = 0; i < rowType.getFields().length; ++i) {
                    Object value = row.get(rowType.getFields()[i].getAlias());
                    if (!Objects.nonNull(value)) continue;
                    String valueStr = String.valueOf(value);
                    int length = 0;
                    if (!StringUtils.isEmpty((Object)valueStr)) {
                        for (char c : valueStr.toCharArray()) {
                            if (!DataSetHelper.isChinese(c)) {
                                ++length;
                                continue;
                            }
                            length += 2;
                        }
                    }
                    if (length > colWidths[i]) {
                        colWidths[i] = length;
                    }
                    if (valueStr.length() <= charMaxSizes[i]) continue;
                    charMaxSizes[i] = valueStr.length();
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        try (DataSet dataSetCopy = dataSet.copy();){
            RowMeta rowType = dataSetCopy.getRowMeta();
            for (int i = 0; i < rowType.getFieldNames().length; ++i) {
                sb.append(rowType.getFieldNames()[i]).append("s|");
            }
            sb.append('\n');
            int rowIndex = 0;
            Iterator iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                int i;
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                String[] rowValues = new String[rowType.getFieldCount()];
                for (i = 0; i < rowType.getFieldCount(); ++i) {
                    Object value = row.get(rowType.getFields()[i].getAlias());
                    rowValues[i] = Objects.isNull(value) ? "null" : String.valueOf(value);
                }
                for (i = 0; i < rowValues.length; ++i) {
                    sb.append(rowValues[i]);
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }
}

