/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    private static Log logger = LogFactory.getLog(DateUtils.class);
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final String FORMAT_HHMMSS = "yyyyMMddhhmmss";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getNextSeconds(Date date, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, second);
        return c.getTime();
    }

    public static Date getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = (int)diff + 1;
        return days;
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static Date stringToDate(String datestr, String dateformat) {
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            return df.parse(datestr);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s\u3002", (String)"DateUtils_2", (String)"fi-iep-common", (Object[])new Object[0]), datestr, dateformat)});
        }
    }

    public static int getDay(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(8));
    }

    public static int getMonth(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(5, 7));
    }

    public static int getYear(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(0, 4));
    }

    public static Date getMinMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static String formatString(Date date, String forPattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(forPattern);
        return sdf.format(date);
    }

    public static Date getBeforeDate(Date endDate, Date currDate) {
        if (endDate.compareTo(currDate) > 0) {
            return currDate;
        }
        return endDate;
    }
}

