/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.util.DataSetHelper;
import kd.fi.iep.util.report.GroupStringAggFunction;

public class GLDataUtil {
    private GLDataUtil() {
    }

    public static DataSet buildVoucherDescDataset(List<Long> voucherIds) {
        DataSet voucherIdDescDs = QueryServiceHelper.queryDataSet((String)GLDataUtil.class.getName(), (String)"gl_voucher", (String)"id voucherid,entries.edescription vouchersummary", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds)}, null).groupBy(new String[]{"voucherid"}).agg((CustomAggFunction)new GroupStringAggFunction(GroupStringAggFunction.class.getName(), ";"), "vouchersummary", "vouchersummary").finish().select("voucherid,vouchersummary");
        return voucherIdDescDs;
    }

    public static DataSet buildNoticeVoucherDataset(List<Long> voucherIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("voucher", "in", voucherIds), new QFilter("noticetype", "=", (Object)"0")};
        DataSet acnoticeDs = QueryServiceHelper.queryDataSet((String)GLDataUtil.class.getName(), (String)"gl_acnotice", (String)"id noticebillid,voucher voucherid", (QFilter[])qFilters, null);
        DataSet dapDs = QueryServiceHelper.queryDataSet((String)GLDataUtil.class.getName(), (String)"ai_daptracker", (String)"sourcebillid noticebillid, voucherid noticevoucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", DataSetHelper.extractLongColumnValues(acnoticeDs, "noticebillid", true))}, null);
        return acnoticeDs.leftJoin(dapDs).on("noticebillid", "noticebillid").select(new String[]{"noticebillid", "voucherid"}, new String[]{"noticevoucherid"}).finish();
    }

    public static DataSet queryAllBillFromImageShareCenter(List<String> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return DataSetHelper.createDatSet(GLDataUtil.class, Arrays.asList("billid", "billtype", "imagenumber"), Arrays.asList(DataType.LongType, DataType.StringType, DataType.StringType), Collections.EMPTY_LIST);
        }
        DataSet imageDs = QueryServiceHelper.queryDataSet((String)GLDataUtil.class.getName(), (String)"task_billimagemap", (String)"billid billid,billtype billtype,imagenumber imagenumber", (QFilter[])new QFilter[]{new QFilter("billid", "in", billIds)}, null);
        DataSet imageDsCopy = imageDs.copy();
        ArrayList<List<Object>> newDsData = new ArrayList<List<Object>>(imageDsCopy.count("billid", false));
        imageDs.forEach(x -> {
            ArrayList<Object> row = new ArrayList<Object>(3);
            row.add(Long.parseLong(x.get("billid").toString()));
            row.add(x.getString("billtype"));
            row.add(x.getString("imagenumber"));
            newDsData.add(row);
        });
        return DataSetHelper.createDatSet(GLDataUtil.class, Arrays.asList("billid", "billtype", "imagenumber"), Arrays.asList(DataType.LongType, DataType.StringType, DataType.StringType), newDsData);
    }
}

