/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.IListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.iep.cache.CacheKey;
import kd.fi.iep.cache.CacheKeyPrefix;
import kd.fi.iep.cache.LocalCacheHelper;
import kd.fi.iep.exception.BOSException;
import kd.fi.iep.util.ContextUtil;
import org.apache.commons.lang3.ArrayUtils;

public class GLUtil {
    public static final Long MAX_PERIOD = 99999999999L;
    public static final Long TYPE_PERIOD_L = 100000000L;
    public static final Long YEAR_PERIOD_L = 10000L;
    public static final String entityID_exchangeRate = "bd_exrate_tree";
    private static final String ACCOUNTTYPE = "local-accttype-key";
    private static final String ASSGRPMAP = "assgrp-local-map";

    public static long retainPeriodType(long period) {
        return period / TYPE_PERIOD_L * TYPE_PERIOD_L;
    }

    public static long retainPeriodYear(long period) {
        return period / YEAR_PERIOD_L * YEAR_PERIOD_L;
    }

    public static boolean isZero(BigDecimal val) {
        return val.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isPkValNull(Object pkVal) {
        return StringUtils.isBlank((Object)pkVal) || "0".equals(String.valueOf(pkVal));
    }

    public static boolean isPkValNotNull(Object pkVal) {
        return !GLUtil.isPkValNull(pkVal);
    }

    public static void getLeafIds(Set<Long> acctIds, Set<Long> leafIds, boolean isLeaf) {
        QFilter fparent = new QFilter("parent", "in", acctIds);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accountview", (String)"id,parent,level,isleaf", (QFilter[])fparent.toArray());
        HashSet<Long> unLeafAcctIds = new HashSet<Long>();
        if (col != null) {
            for (DynamicObject obj : col) {
                long acctId = obj.getLong("id");
                if (isLeaf) {
                    if (obj.getBoolean("isleaf")) {
                        leafIds.add(acctId);
                        continue;
                    }
                    unLeafAcctIds.add(acctId);
                    continue;
                }
                leafIds.add(acctId);
                unLeafAcctIds.add(acctId);
            }
        }
        if (unLeafAcctIds.size() > 0) {
            GLUtil.getLeafIds(unLeafAcctIds, leafIds, isLeaf);
        }
    }

    public static long getYear(long periodid) {
        return periodid / YEAR_PERIOD_L - periodid / TYPE_PERIOD_L * TYPE_PERIOD_L / YEAR_PERIOD_L;
    }

    public static DynamicObject getMaxPeriodByType(long periodType) {
        QFilter typeFilter = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObjectCollection dataSet = QueryServiceHelper.query((String)"GLUtil.getMaxPeriodByType", (String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{typeFilter}, (String)"id desc", (int)1);
        return (DynamicObject)dataSet.get(0);
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        return GLUtil.getPeriodByDate(date, periodType, Boolean.TRUE);
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType, Boolean includeAdjust) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = GLUtil.getPeriodByDate(date, selectField, periodType, includeAdjust);
        if (!period.isEmpty()) {
            return (DynamicObject)period.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType, Boolean includeAdjust) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        QFilter f = new QFilter("beginDate", "<=", (Object)c.getTime());
        QFilter g = new QFilter("enddate", ">=", (Object)c.getTime());
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        if (!includeAdjust.booleanValue()) {
            t = t.and(new QFilter("isadjustperiod", "=", (Object)includeAdjust));
        }
        return QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t}, (String)"number");
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType) {
        return GLUtil.getPeriodByDate(date, selectField, periodType, Boolean.TRUE);
    }

    public static Set<Long> getPeriodIdSet(Date beginDate, Date endDate) {
        QFilter beginDateFilter = new QFilter("begindate", ">=", (Object)beginDate);
        QFilter endDateFilter = new QFilter("enddate", "<=", (Object)endDate);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter});
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        try {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", "<", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)1);
            if (coll == null || coll.isEmpty()) {
                return null;
            }
            return (DynamicObject)coll.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        return GLUtil.getNextPeriod(curPeriodId, true);
    }

    public static DynamicObject getNextPeriod(Object curPeriodId, boolean isAdjustPeriod) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", ">", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = null;
            if (isAdjustPeriod) {
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id", (int)1);
            } else {
                QFilter filterAdjustPeriod = new QFilter("isadjustperiod", "=", (Object)isAdjustPeriod);
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, filterAdjustPeriod}, (String)"id", (int)1);
            }
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return nextPeriod;
    }

    public static DynamicObject getPreviousYearLastPeriod(long curPeriodId) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            long periodyear = currPeriod.getLong("periodyear") - 1L;
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            QFilter filterYear = new QFilter("periodyear", "=", (Object)periodyear);
            DynamicObjectCollection coll = null;
            coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterType, filterYear}, (String)"id desc", (int)1);
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return nextPeriod;
    }

    public static DynamicObject getPreviousYearMinPeriod(long curPeriodId) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            long periodyear = currPeriod.getLong("periodyear") - 1L;
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            QFilter filterYear = new QFilter("periodyear", "=", (Object)periodyear);
            DynamicObjectCollection coll = null;
            coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterType, filterYear}, (String)"id", (int)1);
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return nextPeriod;
    }

    public static long getPreviousYearSamePeriod(long curPeriodId) {
        long samePeriod = 0L;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            long num = curPeriodId % YEAR_PERIOD_L;
            samePeriod = (curPeriodId / YEAR_PERIOD_L - 1L) * YEAR_PERIOD_L + num;
            boolean exists = QueryServiceHelper.exists((String)"bd_period", (Object)samePeriod);
            if (!exists) {
                samePeriod = 0L;
            }
        }
        return samePeriod;
    }

    public static boolean isCashAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        return acct.getBoolean("iscash") || acct.getBoolean("isbank") || acct.getBoolean("iscashequivalent");
    }

    public static boolean isCashAcct(Row row) {
        return row.getBoolean("entries.account.iscash") != false || row.getBoolean("entries.account.isbank") != false || row.getBoolean("entries.account.iscashequivalent") != false;
    }

    public static boolean isPLAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        Map<Long, Boolean> map = GLUtil.getAcctType();
        return map.get(acct.getLong("accounttype.id")) == null ? false : map.get(acct.getLong("accounttype.id"));
    }

    public static Map<Long, Boolean> getAcctType() {
        HashMap<Long, Boolean> map = (HashMap<Long, Boolean>)ThreadCache.get((Object)ACCOUNTTYPE);
        if (null == map) {
            map = new HashMap<Long, Boolean>();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accounttype", (String)"id,accounttype", null);
            for (DynamicObject obj : col) {
                if ("4".equals(obj.getString("accounttype"))) {
                    map.put(obj.getLong("id"), Boolean.TRUE);
                    continue;
                }
                map.put(obj.getLong("id"), Boolean.FALSE);
            }
            ThreadCache.put((Object)ACCOUNTTYPE, map);
        }
        return map;
    }

    public static boolean isPLAcct(long acctTypeId) {
        if (acctTypeId == 0L) {
            return false;
        }
        Map<Long, Boolean> map = GLUtil.getAcctType();
        return map.get(acctTypeId) == null ? false : map.get(acctTypeId);
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    public static List<String> getDataSetCols(DataSet ds, String ... excludeFields) {
        List<String> excludeFieldList = ArrayUtils.isEmpty((Object[])excludeFields) ? Collections.EMPTY_LIST : Arrays.asList(excludeFields);
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (excludeFieldList.contains(field.getName())) continue;
            list.add(field.getName());
        }
        return list;
    }

    public static List<String> getDataSetColsAdd(DataSet ds, String ... includeFields) {
        List<String> includeFieldList = ArrayUtils.isEmpty((Object[])includeFields) ? Collections.EMPTY_LIST : Arrays.asList(includeFields);
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        list.addAll(Arrays.asList(fields).stream().map(x -> x.getName()).collect(Collectors.toList()));
        includeFieldList.stream().filter(x -> !list.contains(x)).forEach(x -> list.add((String)x));
        return list;
    }

    public static List<Long> getPeriodIds(String compare, Long period) {
        if (period == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(period / TYPE_PERIOD_L));
        QFilter periodFilter = new QFilter("id", compare, (Object)period);
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, periodFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        if (compare.equalsIgnoreCase("<") || compare.equalsIgnoreCase("<=")) {
            result.add(0L);
        } else if (compare.equalsIgnoreCase(">") || compare.equalsIgnoreCase(">=")) {
            result.add(MAX_PERIOD);
        }
        return result;
    }

    public static List<Long> getPeriodIds(Long begin, Long end) {
        if (end == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(end / TYPE_PERIOD_L));
        QFilter beginFilter = new QFilter("id", ">=", (Object)begin);
        QFilter endFilter = new QFilter("id", "<=", (Object)end);
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, beginFilter, endFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        return result;
    }

    public static long getMaxPeriodIdByCount(long startPeriodId, int count) {
        long maxPeriodId = 0L;
        if (startPeriodId == 0L) {
            return maxPeriodId;
        }
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(startPeriodId / TYPE_PERIOD_L));
        QFilter beginFilter = new QFilter("id", ">=", (Object)startPeriodId);
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, beginFilter}, (String)"id asc", (int)count);){
            for (Row r : rs) {
                long id = r.getLong("id");
                if (maxPeriodId >= id) continue;
                maxPeriodId = id;
            }
            long l = maxPeriodId;
            return l;
        }
    }

    public static DataSet getCurYearMaxPeriod(long periodId, String sel) {
        if (periodId == 0L) {
            return null;
        }
        String entityName = "bd_period";
        QFilter fid = new QFilter("id", "=", (Object)periodId);
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getCurYearMaxPeriod", (String)entityName, (String)"id, periodtype, periodyear, periodnumber", (QFilter[])fid.toArray(), null);
        Iterator iterator = periodSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            QFilter filterType = new QFilter("periodtype.id", "=", row.get("periodtype"));
            QFilter filterYear = new QFilter("periodyear", "=", row.get("periodyear"));
            QFilter filterNum = new QFilter("periodnumber", ">=", row.get("periodnumber"));
            try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getCurYearMaxPeriod", (String)entityName, (String)sel, (QFilter[])new QFilter[]{filterType, filterYear, filterNum}, (String)"id desc", (int)1);){
                DataSet dataSet = rs;
                return dataSet;
            }
        }
        return null;
    }

    public static DynamicObject getCurYearMinPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", currPeriod.get("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new BOSException(e);
        }
    }

    public static Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new BOSException(e);
        }
    }

    public static DynamicObjectCollection getSetCoderules(String billStatus, String ordId) {
        QFilter[] qfilters;
        QFilter fenable = new QFilter("enable", "=", (Object)"1");
        QFilter fbizobjectid = new QFilter("bizobjectid", "=", (Object)"gl_voucher");
        QFilter fpro = new QFilter("conditionentry.property.bizobjectid", "=", (Object)"gl_voucher");
        QFilter fpro1 = new QFilter("conditionentry.property.number", "=", (Object)"billstatus");
        if ("B".equals(billStatus) || "C".equals(billStatus)) {
            QFilter fvalue = new QFilter("conditionentry.propertyvalue.value", "=", (Object)billStatus);
            qfilters = new QFilter[]{fenable, fbizobjectid, fpro, fpro1, fvalue};
        } else {
            qfilters = new QFilter[]{fenable, fbizobjectid};
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_coderule", (String)"id,appmode", (QFilter[])qfilters);
        return col;
    }

    public static Map<String, List<Long>> getBookTypeAndAccountTable(Long org) {
        QFilter f1 = new QFilter("org", "=", (Object)org);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"accounttable, bookstype.accounttype type", (QFilter[])new QFilter[]{f1});
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        for (DynamicObject dyn : dyns) {
            String type = dyn.getString("type");
            if (result.get(type) == null) {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(dyn.getLong("accounttable"));
                result.put(type, list);
                continue;
            }
            ((List)result.get(type)).add(dyn.getLong("accounttable"));
        }
        return result;
    }

    public static List<Long> getAccounttableIdByOrg(Long org) {
        QFilter f1 = new QFilter("org", "=", (Object)org);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{f1});
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject dyn : dyns) {
            list.add(dyn.getLong("accounttable"));
        }
        return list;
    }

    public static DynamicObject getParentsControl(Long orgId, List<Long> voucherTypeIds, List<Long> accountTables) {
        QFilter f1 = new QFilter("org.id", "=", (Object)orgId);
        QFilter f2 = new QFilter("view.treetype", "=", (Object)"10");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{f1, f2});
        if (dyn == null || dyn.getLong("parent") == orgId.longValue()) {
            return null;
        }
        Long parentId = dyn.getLong("parent");
        if (parentId == null || parentId == 0L) {
            return null;
        }
        DynamicObject controlInformation = GLUtil.getControlMsg(parentId, voucherTypeIds);
        if (controlInformation != null && accountTables.contains(controlInformation.get("accounttable"))) {
            return controlInformation;
        }
        DynamicObject control = GLUtil.getParentsControl(parentId, voucherTypeIds, accountTables);
        return control;
    }

    public static DynamicObject getParentsControl(Long orgId, List<Long> voucherTypeIds, Long accountTableId) {
        QFilter f1 = new QFilter("org.id", "=", (Object)orgId);
        QFilter f2 = new QFilter("view.treetype", "=", (Object)"10");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{f1, f2});
        if (dyn == null || dyn.getLong("parent") == orgId.longValue()) {
            return null;
        }
        Long parentId = dyn.getLong("parent");
        if (parentId == null || parentId == 0L) {
            return null;
        }
        DynamicObject controlInformation = GLUtil.getControlMsg(parentId, voucherTypeIds);
        if (controlInformation != null && accountTableId.longValue() == controlInformation.getLong("accounttable")) {
            return controlInformation;
        }
        DynamicObject control = GLUtil.getParentsControl(parentId, voucherTypeIds, accountTableId);
        return control;
    }

    public static DynamicObject getControlMsg(Long orgId, List<Long> voucherTypeIds) {
        QFilter typeIdFilter = new QFilter("vouchertype", "in", voucherTypeIds);
        QFilter orgIdDilter = new QFilter("orgid", "=", (Object)orgId);
        DynamicObject controlInformation = QueryServiceHelper.queryOne((String)"gl_controlinformation", (String)"id,accounttable", (QFilter[])new QFilter[]{orgIdDilter, typeIdFilter});
        return controlInformation;
    }

    public static Long getMastIdById(Long typeid) {
        QFilter f1 = new QFilter("id", "=", (Object)typeid);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query_gl_voucher_getMasterid", (String)"gl_vouchertype", (String)"masterid", (QFilter[])new QFilter[]{f1}, null);){
            if (ds.hasNext()) {
                Long l = ds.next().getLong("masterid");
                return l;
            }
        }
        return 0L;
    }

    public static List<Long> getIdsByMasterId(Long masterId) {
        QFilter f1 = new QFilter("masterid", "=", (Object)masterId);
        ArrayList<Long> typeIds = new ArrayList<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query_gl_voucher_getIds", (String)"gl_vouchertype", (String)"id", (QFilter[])new QFilter[]{f1}, null);){
            for (Row rs : ds) {
                typeIds.add(rs.getLong("id"));
            }
        }
        return typeIds;
    }

    public static int getCFItemMaxLevel(Object orgId) {
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)((Long)orgId));
        DynamicObjectCollection dync = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"level", (QFilter[])new QFilter[]{qFilter}, (String)"level desc", (int)1);
        String level = "0";
        if (dync != null && !dync.isEmpty()) {
            level = ((DynamicObject)dync.get(0)).getString("level");
        }
        return Integer.parseInt(level);
    }

    public static Map<Long, String> getVoucherLinkUpBills(List<Long> voucherIds) {
        QFilter voucherIdf = new QFilter("voucherid", "in", voucherIds);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype,sourcebillid", (QFilter[])new QFilter[]{voucherIdf});
        HashMap<Long, String> sourceInfos = new HashMap<Long, String>();
        for (DynamicObject dyo : dyos) {
            Long[] ids = new Long[]{dyo.getLong("sourcebillid")};
            List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)dyo.getString("billtype"), (String)"", (Long[])ids);
            sourceInfos.put(dyo.getLong("sourcebillid"), dyo.getString("billtype"));
            List<BFRowLinkUpNode> childNodes = GLUtil.getChildNodes(bfRowLinkUpNodes);
            for (BFRowLinkUpNode node : childNodes) {
                Long tableId = node.getRowId().getMainTableId();
                TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
                String sourcebillType = tableDefine.getEntityNumber();
                sourceInfos.put(node.getRowId().getBillId(), sourcebillType);
            }
        }
        return sourceInfos;
    }

    private static List<BFRowLinkUpNode> getChildNodes(List<BFRowLinkUpNode> bfRowLinkUpNodes) {
        ArrayList<BFRowLinkUpNode> childNodes = new ArrayList<BFRowLinkUpNode>();
        for (BFRowLinkUpNode node : bfRowLinkUpNodes) {
            if (node.findAllSourceNodes() != null && !node.findAllSourceNodes().isEmpty()) {
                childNodes.add(node);
                childNodes.addAll(GLUtil.getChildNodes(node.findAllSourceNodes()));
                continue;
            }
            childNodes.add(node);
        }
        return childNodes;
    }

    public static Long getAccIdByMasterId(long orgId, long masterid) {
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{acctFilter, new QFilter("masterid", "=", (Object)masterid)});
        return acct == null ? null : Long.valueOf(acct.getLong("id"));
    }

    public static List<Object> getIdsFromDynCollection(DynamicObjectCollection dyos, String keyfield) {
        ArrayList<Object> r = new ArrayList<Object>();
        for (DynamicObject dyo : dyos) {
            r.add(dyo.get(keyfield));
        }
        return r;
    }

    public static DynamicObjectCollection getRealAccts(long orgId, long acctTableId, List<String> numbers, String selectFields) {
        QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter qtable = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter qnum = new QFilter("number", "in", numbers);
        QFilter[] qfilters = new QFilter[]{qtable, qids, qnum};
        DynamicObjectCollection accts = QueryServiceHelper.query((String)"bd_accountview", (String)selectFields, (QFilter[])qfilters);
        return accts;
    }

    public static String queryActDCByMasterID(Long orgId, Long masterid, String defaultDC) {
        String actDC = defaultDC;
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("masterid", "=", (Object)masterid)};
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"dc", (QFilter[])filters);
        if (obj != null) {
            actDC = obj.getString("dc");
        }
        return actDC;
    }

    public static String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(GLUtil.printError(t.getCause())).append("\n");
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            t.printStackTrace(writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.append(sW.toString()).toString();
    }

    public static List<Object> getIdsByMasterIds(String entityId, Collection<Long> masterIds, String orderBys, int top) {
        QFilter masterIdFilter = new QFilter("masterid", "in", masterIds);
        return QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])masterIdFilter.toArray(), (String)orderBys, (int)top);
    }

    public static Object getSystemParam(String paramName, Long org) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        AppParam param = new AppParam(appId, "10", org, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramName);
    }

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        int precision;
        BigDecimal exchangeRate = null;
        DynamicObject rateObj = GLUtil.getExchangeRateInfo(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
        if (null != rateObj) {
            exchangeRate = rateObj.getBigDecimal("excval");
            precision = rateObj.getInt("precision");
            if (precision != 0) {
                exchangeRate = exchangeRate.setScale(precision, 4);
            }
        }
        if (exchangeRate != null) {
            return exchangeRate;
        }
        rateObj = GLUtil.getExchangeRateInfo(exchangeTableID, targetCurrencyID, sourceCurrencyID, date);
        if (null != rateObj) {
            exchangeRate = rateObj.getBigDecimal("indirectexrate");
            precision = rateObj.getInt("precision");
            if (precision != 0) {
                exchangeRate = exchangeRate.setScale(precision, 4);
            }
        }
        return exchangeRate;
    }

    public static int getRatePrecision(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        int precision = 8;
        if (sourceCurrencyID.equals(targetCurrencyID)) {
            return precision;
        }
        DynamicObject rateObj = GLUtil.getExchangeRateInfo(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
        if (null != rateObj) {
            return rateObj.getInt("precision") == 0 ? precision : rateObj.getInt("precision");
        }
        DynamicObject exRateObj = GLUtil.getExchangeRateInfo(exchangeTableID, targetCurrencyID, sourceCurrencyID, date);
        if (null != exRateObj) {
            return exRateObj.getInt("precision") == 0 ? precision : exRateObj.getInt("precision");
        }
        return precision;
    }

    public static DynamicObject getExchangeRateInfo(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter exchangeTableFilter = new QFilter("exctable", "=", (Object)exchangeTableID);
        filterList.add(exchangeTableFilter);
        QFilter sourceCurrencyFilter = new QFilter("orgcur", "=", (Object)sourceCurrencyID);
        filterList.add(sourceCurrencyFilter);
        QFilter targetCurrencyFilter = new QFilter("cur", "=", (Object)targetCurrencyID);
        filterList.add(targetCurrencyFilter);
        QFilter targetEnableFilter = new QFilter("enable", "=", (Object)"1");
        filterList.add(targetEnableFilter);
        if (date != null) {
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            filterList.add(dateFilter);
        }
        String selectFields = "id,excval,indirectexrate,precision,foreignexcid,effectdate";
        String orderBys = "effectdate desc";
        int top = 3;
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        DynamicObjectCollection list = orm.query(entityID_exchangeRate, selectFields, filters, orderBys, top);
        if (list != null) {
            if (list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return (DynamicObject)list.get(0);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            DynamicObject[] result = new DynamicObject[3];
            String dateStr = null;
            for (DynamicObject obj : list) {
                if (dateStr != null) {
                    if (!dateStr.equals(format.format(obj.getDate("effectdate")))) break;
                    GLUtil.resolve(result, obj);
                    continue;
                }
                dateStr = format.format(obj.getDate("effectdate"));
                GLUtil.resolve(result, obj);
            }
            return result[1] != null ? result[1] : (result[0] != null ? result[0] : result[2]);
        }
        return null;
    }

    private static void resolve(DynamicObject[] result, DynamicObject obj) {
        String excid = obj.getString("foreignexcid");
        if (excid.equals("1")) {
            result[0] = obj;
        } else if (excid.equals("2")) {
            result[1] = obj;
        } else if (excid.equals("3")) {
            result[2] = obj;
        }
    }

    public static List<Long> getCustomFilterIds(IFormView view, String fieldName) {
        IListView listView = (IListView)view;
        ControlFilters c = listView.getControlFilters();
        if (c == null) {
            return null;
        }
        List result = c.getFilter(fieldName);
        ArrayList<Long> ids = new ArrayList<Long>(result.size());
        for (Object v : result) {
            if ("".equals(v.toString())) continue;
            ids.add(Long.valueOf(v.toString()));
        }
        return ids;
    }

    public static Long getCustomFilterId(IFormView view, String fieldName) {
        List<Long> list = GLUtil.getCustomFilterIds(view, fieldName);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private static Map<Object, DynamicObject> getAsstacttypes(String flexfield) {
        if (ThreadCache.get((Object)ASSGRPMAP) == null) {
            QFilter q = new QFilter("flexfield", "=", (Object)flexfield);
            Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"number,valuetype,valuesource,assistanttype, disprops", (QFilter[])new QFilter[]{q});
            HashMap<String, Map> assMap = new HashMap<String, Map>();
            assMap.put(flexfield, asstacttypes);
            ThreadCache.put((Object)ASSGRPMAP, assMap);
            return asstacttypes;
        }
        Map assMap = (Map)ThreadCache.get((Object)ASSGRPMAP);
        if (assMap.containsKey(flexfield)) {
            return (Map)assMap.get(flexfield);
        }
        QFilter q = new QFilter("flexfield", "=", (Object)flexfield);
        Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"number,valuetype,valuesource,assistanttype, disprops", (QFilter[])new QFilter[]{q});
        assMap.put(flexfield, asstacttypes);
        return asstacttypes;
    }

    private static void appendAssgrpProp(DynamicObject basedata, String flexName, StringBuffer itemStr, String disprop, String nameProp, String numberProp, String splitStr) {
        if (null == disprop) {
            disprop = "2";
        }
        switch (disprop) {
            case "1": {
                itemStr.append(flexName).append(":").append(basedata.getString(numberProp)).append(splitStr);
                break;
            }
            case "2": {
                itemStr.append(flexName).append(":").append(basedata.getString(nameProp)).append(splitStr);
                break;
            }
            case "3": {
                itemStr.append(flexName).append(":").append(basedata.getString(numberProp)).append(",").append(basedata.getString(nameProp)).append(splitStr);
                break;
            }
            default: {
                itemStr.append(flexName).append(":").append(basedata.getString(nameProp)).append(splitStr);
            }
        }
    }

    public static boolean hasPermission(String permItemId, Long orgId, String entityNum) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        int result = PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (String)"DIM_ORG", orgIds, (String)appId, (String)entityNum, (String)permItemId);
        return result == 1;
    }

    public static List<List<Object>> getAllUseOrg(String entityType) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appid = "gl";
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityType, (String)"47150e89000000ac");
        ArrayList<List<Object>> viewOrgIds = new ArrayList<List<Object>>();
        if (result == null) {
            return viewOrgIds;
        }
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        String orgFuncPro = "org.fisaccounting";
        QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)"1");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        String view = null;
        view = null == ctrlview ? "16" : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)"1");
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3, orgFuncFilter} : new QFilter[]{idsFilter, f2, f3, orgFuncFilter};
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getAllUseOrg", (String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])qfilters, null);){
            while (dt.hasNext()) {
                Row row = dt.next();
                ArrayList<Object> par = new ArrayList<Object>(2);
                par.add(row.getLong("org.id"));
                par.add(row.getString("org.name"));
                viewOrgIds.add(par);
            }
        }
        return viewOrgIds;
    }

    public static String getDefaultUseOrg(List<List<Object>> col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(col.get(0).get(0));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (List<Object> obj : col) {
            if (longinOrg != Long.parseLong(String.valueOf(obj.get(0)))) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    public static long getFilterInitDefOrgId(IPageCache pageCache, String entityId) {
        String orgidStr = pageCache.get("orgid");
        if (orgidStr != null) {
            return Long.parseLong(orgidStr);
        }
        long deforgId = 0L;
        String deforg = pageCache.get("deforg");
        if (deforg == null) {
            deforg = GLUtil.getDefaultUseOrg(GLUtil.getAllUseOrg(entityId));
            if (deforg != null) {
                pageCache.put("deforg", deforg);
                deforgId = Long.parseLong(deforg);
            }
        } else {
            deforgId = Long.parseLong(deforg);
        }
        return deforgId;
    }

    public static String getErrorInfoByOperationResult(OperationResult result) {
        StringBuilder msg = new StringBuilder();
        if (!result.isSuccess()) {
            int successCount = result.getSuccessPkIds().size();
            if (successCount > 0) {
                msg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f%d\u6761\u6570\u636e,\u90e8\u5206\u5931\u8d25", (String)"GLUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), successCount));
            } else {
                msg.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"GLUtil_1", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            List infos = result.getAllErrorOrValidateInfo();
            for (IOperateInfo info : infos) {
                msg.append("\n");
                msg.append(info.getMessage());
            }
        }
        return msg.toString();
    }

    public static List<Long> getOpenPeriod(long orgId, long booktypeId) {
        CacheKey key = CacheKey.getCacheKey(CacheKeyPrefix.GL_OPENPERIOD, orgId, booktypeId);
        ArrayList<Long> ids = LocalCacheHelper.get(key, List.class);
        if (ids == null) {
            ids = new ArrayList<Long>(10);
            QFilter forg = new QFilter("org", "=", (Object)orgId);
            QFilter fbooktype = new QFilter("booktype", "=", (Object)booktypeId);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.GLUtil.getOpenPeriod", (String)"gl_openedperiod", (String)"period", (QFilter[])new QFilter[]{forg, fbooktype}, null);){
                Iterator iter = ds.iterator();
                Row row = null;
                while (iter.hasNext()) {
                    row = (Row)iter.next();
                    ids.add(row.getLong("period"));
                }
            }
            LocalCacheHelper.put(key, ids);
        }
        return ids;
    }
}

