/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class GlFormUtil {
    public static void goChronologicalPageVoucher(IFormView view) {
        GlFormUtil.goChronologicalPage(view, "gl_voucher", null);
    }

    public static void goChronologicalPageVoucher(IFormView view, String filterParameter) {
        GlFormUtil.goChronologicalPage(view, "gl_voucher", filterParameter);
    }

    public static void goChronologicalPage(IFormView view, String pageKey, String filterParameter) {
        GlFormUtil.goChronologicalPage(view, pageKey, filterParameter, null);
    }

    public static void goChronologicalPage(IFormView view, String pageKey, String filterParameter, List<SqlParameter> sqlParameters) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(pageKey);
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabap");
        if (null != filterParameter) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            if (StringUtils.isNotEmpty((String)filterParameter)) {
                listFilterParameter.setFilter(QFilter.fromSerializedString((String)filterParameter));
            }
            showParameter.setListFilterParameter(listFilterParameter);
        }
        showParameter.setCustomParam("source", (Object)"GLUtil");
        view.showForm((FormShowParameter)showParameter);
    }

    public static DynamicObject getCurYearMaxPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getCurYearMinPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static BigDecimal setScale(BigDecimal val, int scale) {
        if (val == null) {
            return val;
        }
        return val.setScale(scale, 4);
    }

    public static DynamicObject getSamePeriodOfYear(long curperiodID, int beforeValue) {
        QFilter filterNum2;
        QFilter filterYear2;
        DynamicObject result = null;
        String entityName = "bd_period";
        String selector = "id,name,periodtype,periodyear,periodnumber,begindate,enddate";
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)entityName, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curperiodID)});
        if (taskObjs == null || taskObjs.length == 0) {
            return result;
        }
        DynamicObject curPeriod = taskObjs[0];
        QFilter filterType2 = new QFilter("periodtype", "=", curPeriod.get("periodtype_id"));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"gl.glutil.samePeriodOfYear", (String)entityName, (String)selector, (QFilter[])new QFilter[]{filterType2, filterYear2 = new QFilter("periodyear", "=", (Object)(curPeriod.getInt("periodyear") - beforeValue)), filterNum2 = new QFilter("periodnumber", "=", (Object)curPeriod.getInt("periodnumber"))}, null);
        if (cols.size() > 0) {
            result = (DynamicObject)cols.get(0);
        }
        return result;
    }

    public static Long getDefaultAcctOrg(List<Long> orgPkList) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        if (orgPkList.contains(curLoginOrg)) {
            return curLoginOrg;
        }
        if (!orgPkList.isEmpty()) {
            return orgPkList.get(0);
        }
        return null;
    }

    public static <K, V> void putMap(Map<K, Set<V>> map, K key, V value) {
        if (map.containsKey(key)) {
            Set<V> accSet = map.get(key);
            accSet.add(value);
            map.put(key, accSet);
        } else {
            HashSet<V> accSet = new HashSet<V>();
            accSet.add(value);
            map.put(key, accSet);
        }
    }

    public static void setF7ClickFilter(BasedataEdit edit, QFilter qFilter) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (qFilter != null) {
            list.add(qFilter);
        }
        edit.setQFilters(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> queryVoucherId(List<Long> srcentityIDs) {
        QFilter filter = new QFilter("srcentity", "in", srcentityIDs);
        ArrayList<Long> voucherId = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"gl_adjratevoucherref.getVoucherID", (String)"gl_voucherrelation", (String)"targentity", (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : dataSet) {
                voucherId.add(row.getLong("targentity"));
            }
        }
        return voucherId;
    }

    public static Map<String, Object> getDptNameByUserId(Long creatorId) {
        HashMap<String, Object> userDpt = new HashMap<String, Object>();
        userDpt.put("dpt", 0L);
        userDpt.put("dptName", null);
        String selectField = "id,entryentity.dpt,entryentity.ispartjob,entryentity.dpt.name,name";
        QFilter idFilter = new QFilter("id", "=", (Object)creatorId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl.TransPLProgramEditPlugin.getDptNameByUserId", (String)"bos_user", (String)selectField, (QFilter[])new QFilter[]{idFilter}, (String)"");
        if (collection.isEmpty()) {
            return userDpt;
        }
        for (DynamicObject userObj : collection) {
            boolean ispartjob = userObj.getBoolean("entryentity.ispartjob");
            if (ispartjob) continue;
            userDpt.put("dpt", userObj.get("entryentity.dpt"));
            userDpt.put("dptName", userObj.getString("entryentity.dpt.name"));
            return userDpt;
        }
        return userDpt;
    }

    public static String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }

    public static DynamicObject fromDynamicString(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }
}

