/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.util.DataSetHelper;
import kd.fi.iep.util.DateUtils;

public class IEPDataUtil {
    protected static final Log LOG = LogFactory.getLog(IEPDataUtil.class);

    private IEPDataUtil() {
    }

    public static int countTodayScanData(boolean isJustFiled, long userId) {
        Date now = new Date();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("createtime", "<", (Object)DateUtils.getDataFormat(now, false)));
        filters.add(new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat(now, true)));
        filters.add(new QFilter("scanperson", "=", (Object)userId));
        if (isJustFiled) {
            filters.add(new QFilter("filingstatus", "=", (Object)"1"));
        }
        int count = 0;
        try (DataSet filingDataDs = QueryServiceHelper.queryDataSet((String)IEPDataUtil.class.getName(), (String)"gl_filingdata", (String)"billid", (QFilter[])filters.toArray(new QFilter[0]), null);){
            count = filingDataDs.count("billid", true);
        }
        return count;
    }

    public static int countTodayFiledData(long userId) {
        Date now = new Date();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("filingdate", "<", (Object)DateUtils.getDataFormat(now, false)));
        filters.add(new QFilter("filingdate", ">=", (Object)DateUtils.getDataFormat(now, true)));
        filters.add(new QFilter("filingperson", "=", (Object)userId));
        int count = 0;
        try (DataSet filingDataDs = QueryServiceHelper.queryDataSet((String)IEPDataUtil.class.getName(), (String)"gl_filingdata", (String)"billid", (QFilter[])filters.toArray(new QFilter[0]), null);){
            count = filingDataDs.count("billid", true);
        }
        return count;
    }

    public static DataSet buildBillNumberDs(DataSet rawDs) {
        Assert.isTrue((boolean)Objects.nonNull(rawDs.getRowMeta().getField("billid")));
        Assert.isTrue((boolean)Objects.nonNull(rawDs.getRowMeta().getField("billtype")));
        HashMap entityNameIdsMap = new HashMap(8);
        try (DataSet rawDsCopy = rawDs.copy();){
            rawDsCopy.forEach(x -> {
                String billType = x.getString("billtype");
                if (!entityNameIdsMap.containsKey(billType)) {
                    entityNameIdsMap.put(billType, new HashSet());
                }
                ((Set)entityNameIdsMap.get(billType)).add(x.getLong("billid"));
            });
        }
        DataSet baseDs = DataSetHelper.createDatSet(IEPDataUtil.class, Arrays.asList("billid", "billno"), Arrays.asList(DataType.LongType, DataType.StringType), Collections.EMPTY_LIST);
        String selectProperties = "id billid,billno billno";
        String selectPropertiesWithNumber = "id billid,number billno";
        for (Map.Entry entityEntry : entityNameIdsMap.entrySet()) {
            String entityNumber = (String)entityEntry.getKey();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            try {
                DataSet entryDs = null;
                entryDs = QueryServiceHelper.queryDataSet((String)IEPDataUtil.class.getName(), (String)entityNumber, (String)(Objects.nonNull(entityType.getProperty("number")) ? selectPropertiesWithNumber : selectProperties), (QFilter[])new QFilter[]{new QFilter("id", "in", new ArrayList((Collection)entityEntry.getValue()))}, null);
                baseDs = baseDs.union(entryDs);
            }
            catch (Exception e) {
                LOG.warn(String.format("query_entity_number failed on %s", entityNumber), (Throwable)e);
            }
        }
        return baseDs;
    }
}

