/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.cache.CacheHelper;
import kd.fi.iep.cache.CacheModule;
import kd.fi.iep.cache.DistributeCache;
import kd.fi.iep.constant.Constants;
import kd.fi.iep.util.DataSetHelper;
import kd.fi.iep.util.DateUtils;
import kd.fi.iep.util.GLUtil;
import kd.fi.iep.util.IEPDataUtil;
import kd.fi.iep.util.QueryBuilderUtils;
import org.apache.commons.lang3.StringUtils;

public class VoucherFileHistQueryRpt
extends AbstractReportListDataPlugin {
    protected static final Log LOG = LogFactory.getLog(VoucherFileHistQueryRpt.class);
    private static final String KEY_voucherid = "voucherid";
    private static final QFilter VOUCHER_FILTER_DAP = new QFilter("sourcetype", "in", Collections.singletonList("4"));
    private static final QFilter VOUCHER_FILTER_MANUAL = new QFilter("sourcetype", "in", Arrays.asList("0", "8"));

    public DataSet query(ReportQueryParam reportQueryParam, Object obj) throws Throwable {
        return this.queryVoucher(reportQueryParam);
    }

    public DataSet queryVoucher(ReportQueryParam param) {
        DataSet voucherBillDs = this.fetchFilterVoucherIds(param);
        List voucherIds = DataSetHelper.extractLongColumnValues((DataSet)voucherBillDs, (String)KEY_voucherid, (boolean)false);
        if (!DataSetHelper.isIdListEmpty((List)voucherIds)) {
            String voucherSelect = "vouchertype.name vouchertype,billno vouchernumber,debitlocamount voucheramount,id voucherid,creator vouchercreator,creator.picturefield vouchercreatoravatar, book.basecurrency bookcurrency, org entryorg, period entryperiod,bookeddate,sourcesys, vdescription vouchersummary";
            DataSet voucherInfoDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)voucherSelect, (QFilter[])new QFilter("id", "in", (Object)voucherIds).toArray(), null);
            DataSet voucherBillEnhanceDs = voucherBillDs.leftJoin(voucherInfoDs).on(KEY_voucherid, KEY_voucherid).select(GLUtil.getDataSetCols((DataSet)voucherBillDs).toArray(new String[0]), GLUtil.getDataSetCols((DataSet)voucherInfoDs, (String[])new String[]{KEY_voucherid}).toArray(new String[0])).finish();
            DataSet billVoucherFilingDs = voucherBillEnhanceDs.join(this.getBillFilingInfo(voucherIds), JoinType.LEFT).on(KEY_voucherid, KEY_voucherid).select(GLUtil.getDataSetCols((DataSet)voucherBillEnhanceDs).toArray(new String[0]), new String[]{"filingstatus", "filingperson", "filingdate"}).finish();
            DataSet billVoucherFilingStatusFilterDs = null;
            int filingStatus = this.getFilterFilingStatus(param);
            billVoucherFilingStatusFilterDs = filingStatus > 0 ? billVoucherFilingDs.filter("filingstatus = '" + filingStatus + "'") : billVoucherFilingDs;
            this.cacheVoucherStatistic(param, billVoucherFilingStatusFilterDs.copy());
            voucherIds = DataSetHelper.extractLongColumnValues((DataSet)billVoucherFilingStatusFilterDs, (String)KEY_voucherid, (boolean)false);
            if (!DataSetHelper.isIdListEmpty((List)voucherIds)) {
                DataSet entityMetaDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_entitymeta", (String)"number billtype,name billtypename", null, null);
                DataSet enhanceBillTypeNameDs = billVoucherFilingStatusFilterDs.join(entityMetaDs, JoinType.LEFT).on("billtype", "billtype").select(GLUtil.getDataSetCols((DataSet)billVoucherFilingStatusFilterDs).toArray(new String[0]), new String[]{"billtypename"}).finish();
                DataSet enhanceBillNoDs = enhanceBillTypeNameDs.leftJoin(IEPDataUtil.buildBillNumberDs((DataSet)enhanceBillTypeNameDs)).on("billid", "billid").select(GLUtil.getDataSetCols((DataSet)enhanceBillTypeNameDs).toArray(new String[0]), new String[]{"billno"}).finish();
                return enhanceBillNoDs;
            }
        }
        this.clearCacheData(param);
        return DataSetHelper.createEmptyDataSet();
    }

    private List<Long> getFilterOrgIds(ReportQueryParam reportQueryParam) {
        return reportQueryParam.getFilter().getDynamicObjectCollection("orgs").stream().map(x -> x.getLong("id")).collect(Collectors.toList());
    }

    private long getFilterBookTypeId(ReportQueryParam reportQueryParam) {
        return ((DynamicObject)reportQueryParam.getFilter().getValue("booktype")).getLong("id");
    }

    private int getFilterFilingStatus(ReportQueryParam reportQueryParam) {
        return reportQueryParam.getFilter().getInt("filestatus");
    }

    private DataSet fetchFilterVoucherIds(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DataSet dapVoucherDs = null;
        DataSet manVoucherDs = null;
        Boolean isShowTodayScanBills = reportQueryParam.getFilter().getBoolean("isshowtodayscan");
        if (isShowTodayScanBills.booleanValue()) {
            Date now = new Date();
            QFilter scanEndFilter = new QFilter("createtime", "<", (Object)DateUtils.getDataFormat((Date)now, (boolean)false));
            QFilter scanStartFilter = new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)now, (boolean)true));
            QFilter idValidFilter = new QFilter(KEY_voucherid, "!=", (Object)0);
            ArrayList<Long> todayScanVoucherIds = new ArrayList<Long>(16);
            try (DataSet todayScanedVoucherDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_filingdata", (String)KEY_voucherid, (QFilter[])new QFilter[]{scanStartFilter, scanEndFilter, idValidFilter}, null);){
                todayScanedVoucherDs.forEach(x -> todayScanVoucherIds.add(x.getLong(KEY_voucherid)));
            }
            if (CollectionUtils.isEmpty(todayScanVoucherIds)) {
                return DataSetHelper.createEmptyDataSet();
            }
            dapVoucherDs = this.getExistDAPRelationVouchers(null, todayScanVoucherIds);
            manVoucherDs = this.getUserManualRelationVouchers(null, todayScanVoucherIds);
        } else {
            List<Long> orgIds = this.getFilterOrgIds(reportQueryParam);
            long bookTypeId = this.getFilterBookTypeId(reportQueryParam);
            QFilter orgFilter = new QFilter("org", "in", orgIds);
            QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
            QFilter periodFilter = new QFilter("period", "=", ((DynamicObject)filterInfo.getValue("period")).getPkValue());
            QFilter voucherFilter = filterInfo.getCommFilter("gl_voucher");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
            filters.add(orgFilter);
            if (Objects.nonNull(bookTypeFilter)) {
                filters.add(bookTypeFilter);
            }
            if (Objects.nonNull(periodFilter)) {
                filters.add(periodFilter);
            }
            if (Objects.nonNull(voucherFilter)) {
                filters.add(voucherFilter);
            }
            dapVoucherDs = this.getExistDAPRelationVouchers(filters, null);
            manVoucherDs = this.getUserManualRelationVouchers(filters, null);
        }
        return dapVoucherDs.union(manVoucherDs);
    }

    private DataSet getExistDAPRelationVouchers(List<QFilter> commonFilters, List<Long> specificVoucherIds) {
        DataSet voucherIdDs = null;
        QFilter dapFilter = QFilter.joinSQL((String)"gl_voucher", (String)"inner join t_ai_daptracker dap on dap.fvoucherid = gl_voucher.fid and dap.fbilltype != 'ai_event'", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(specificVoucherIds)) {
            voucherIdDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{dapFilter, new QFilter("id", "in", specificVoucherIds), VOUCHER_FILTER_DAP}, null, (int)100000);
        } else {
            ArrayList<QFilter> dapFilterChain = new ArrayList<QFilter>(8);
            dapFilterChain.add(dapFilter);
            dapFilterChain.addAll(commonFilters);
            dapFilterChain.add(VOUCHER_FILTER_DAP);
            voucherIdDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id", (QFilter[])dapFilterChain.toArray(new QFilter[0]), null, (int)100000).groupBy(new String[]{"id"}).finish().select("id");
        }
        List voucherIds = DataSetHelper.extractLongColumnValues((DataSet)voucherIdDs, (String)"id", (boolean)true);
        DataSet dapRelationDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ai_daptracker", (String)"sourcebillid billid,billtype billtype,voucherid voucherid", (QFilter[])new QFilter[]{new QFilter(KEY_voucherid, "in", (Object)voucherIds), new QFilter("billtype", "!=", (Object)"ai_event")}, null);
        DataSet voucherBillDapDs = voucherIdDs.join(dapRelationDs).on("id", KEY_voucherid).select(Constants.EMPTY_STR_ARRAY, GLUtil.getDataSetCols((DataSet)dapRelationDs).toArray(new String[0])).finish();
        return voucherBillDapDs;
    }

    private DataSet getUserManualRelationVouchers(List<QFilter> commonFilters, List<Long> specificVoucherIds) {
        DataSet voucherIdDs = null;
        if (!CollectionUtils.isEmpty(specificVoucherIds)) {
            voucherIdDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", specificVoucherIds), VOUCHER_FILTER_MANUAL}, null);
        } else {
            ArrayList<QFilter> manualFilterChain = new ArrayList<QFilter>(commonFilters);
            manualFilterChain.add(VOUCHER_FILTER_MANUAL);
            voucherIdDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id", (QFilter[])manualFilterChain.toArray(new QFilter[0]), null).groupBy(new String[]{"id"}).finish().select("id");
        }
        DataSet fillingRelationDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_filingdata", (String)"billid billid,billtype billtype,voucherid voucherid", null, null);
        DataSet billVoucherDapDs = voucherIdDs.join(fillingRelationDs).on("id", KEY_voucherid).select(Constants.EMPTY_STR_ARRAY, GLUtil.getDataSetCols((DataSet)fillingRelationDs).toArray(new String[0])).finish();
        return billVoucherDapDs;
    }

    private DataSet mapVoucherByDAP(List<Long> voucherIds) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ai_daptracker", (String)"sourcebillid billid,'' billno,billtype billtype,voucherid voucherid", (QFilter[])new QFilter[]{new QFilter(KEY_voucherid, "in", voucherIds), new QFilter("billtype", "!=", (Object)"ai_event")}, null);
    }

    private DataSet getBillFilingInfo(List<Long> voucherIds) {
        ArrayList rowData = new ArrayList(CollectionUtils.isEmpty(voucherIds) ? 8 : voucherIds.size());
        new HashSet<Long>(voucherIds).stream().forEach(x -> rowData.add(Collections.singletonList(x)));
        DataSet voucherIdDs = DataSetHelper.createDatSet(((Object)((Object)this)).getClass(), Collections.singletonList(KEY_voucherid), Collections.singletonList(DataType.LongType), rowData);
        QFilter voucherFilter = new QFilter(KEY_voucherid, "in", voucherIds);
        QFilter filedFilter = new QFilter("filingstatus", "=", (Object)"1");
        String selectedProps = QueryBuilderUtils.joinForSelect((String[])new String[]{"id", KEY_voucherid, "filingstatus", "filingperson", "filingdate"});
        DataSet rawFiledDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_filingdata", (String)selectedProps, (QFilter[])new QFilter[]{voucherFilter, filedFilter}, null);
        DataSet filedVoucherDs = rawFiledDs.groupBy(new String[]{KEY_voucherid}).maxP("filingdate", "id").finish().join(rawFiledDs, JoinType.LEFT).on("id", "id").select(Constants.EMPTY_STR_ARRAY, selectedProps.split(",")).finish();
        DataSet voucherFileDs = voucherIdDs.join(filedVoucherDs, JoinType.LEFT).on(KEY_voucherid, KEY_voucherid).select(new String[]{KEY_voucherid}, new String[]{"filingstatus", "filingperson", "filingdate"}).finish().select(new String[]{KEY_voucherid, "filingperson", "filingdate", "case when $p != '1' then '2' else '1' end $p".replace("$p", "filingstatus")});
        return voucherFileDs;
    }

    private void cacheVoucherStatistic(ReportQueryParam param, DataSet billVoucherFilingDs) {
        String pageID;
        FilterItemInfo pageIDInfo = param.getFilter().getFilterItem("pageID");
        String string = pageID = Objects.isNull(pageIDInfo.getValue()) ? "" : pageIDInfo.getValue().toString();
        if (StringUtils.isEmpty((CharSequence)pageID)) {
            return;
        }
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        if (!StringUtils.isEmpty((CharSequence)pageID)) {
            cache.remove(pageID);
        }
        HashMap<String, AppVoucherStatisticInfo> appGroupMap = new HashMap<String, AppVoucherStatisticInfo>(8);
        try (DataSet voucherGroupDs = billVoucherFilingDs.groupBy(new String[]{KEY_voucherid, "sourcesys", "filingstatus"}).finish().groupBy(new String[]{"sourcesys", "filingstatus"}).count("statuscnt").finish();){
            while (voucherGroupDs.hasNext()) {
                Row row = voucherGroupDs.next();
                String appId = row.getString("sourcesys");
                if (!appGroupMap.containsKey(appId)) {
                    appGroupMap.put(appId, new AppVoucherStatisticInfo(appId));
                }
                int status = row.getInteger("filingstatus");
                int count = row.getInteger("statuscnt");
                if (status == 1) {
                    ((AppVoucherStatisticInfo)appGroupMap.get(appId)).setFiledCount(count);
                    continue;
                }
                ((AppVoucherStatisticInfo)appGroupMap.get(appId)).setUnfiledCount(count);
            }
        }
        cache.put(pageID, SerializationUtils.toJsonString(new ArrayList(appGroupMap.values())));
        billVoucherFilingDs.close();
    }

    private void clearCacheData(ReportQueryParam param) {
        String pageID;
        FilterItemInfo pageIDInfo = param.getFilter().getFilterItem("pageID");
        String string = pageID = Objects.isNull(pageIDInfo.getValue()) ? "" : pageIDInfo.getValue().toString();
        if (!StringUtils.isEmpty((CharSequence)pageID)) {
            DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
            cache.remove(pageID);
        }
    }

    public static final class AppVoucherStatisticInfo
    implements Serializable {
        private String sourceAppId;
        private Integer filedCount = 0;
        private Integer unfiledCount = 0;

        public AppVoucherStatisticInfo() {
        }

        private AppVoucherStatisticInfo(String sourceAppId) {
            this.sourceAppId = sourceAppId;
        }

        private AppVoucherStatisticInfo(String sourceAppId, Integer filedCount, Integer unfiledCount) {
            this.sourceAppId = sourceAppId;
            this.filedCount = filedCount;
            this.unfiledCount = unfiledCount;
        }

        public String getSourceAppId() {
            return this.sourceAppId;
        }

        public void setSourceAppId(String sourceAppId) {
            this.sourceAppId = sourceAppId;
        }

        public Integer getFiledCount() {
            return this.filedCount;
        }

        public void setFiledCount(Integer filedCount) {
            this.filedCount = filedCount;
        }

        public Integer getUnfiledCount() {
            return this.unfiledCount;
        }

        public void setUnfiledCount(Integer unfiledCount) {
            this.unfiledCount = unfiledCount;
        }

        public int getTotal() {
            return this.getFiledCount() + this.getUnfiledCount();
        }

        public String toString() {
            return "AppVoucherStatisticInfo{sourceApp='" + this.sourceAppId + '\'' + ", filedCount=" + this.filedCount + ", unfiledCount=" + this.unfiledCount + '}';
        }
    }
}

