/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.report.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.accsys.AccSysUtil;
import kd.fi.iep.accsys.AccountBookInfo;
import kd.fi.iep.cache.CacheHelper;
import kd.fi.iep.cache.CacheModule;
import kd.fi.iep.cache.DistributeCache;
import kd.fi.iep.common.ViewUtils;
import kd.fi.iep.constant.Voucher;
import kd.fi.iep.report.VoucherFileHistQueryRpt;
import kd.fi.iep.report.util.IepReportMsgs;
import kd.fi.iep.util.GLUtil;
import kd.fi.iep.util.GlFormUtil;
import kd.fi.iep.util.PermissonType;
import org.apache.commons.lang3.StringUtils;

public class VoucherFileHistFormRpt
extends AbstractReportFormPlugin {
    private static final String FILTER_PANEL_VOUCHER = "voucherfiltergridap";
    private static final Set<String> HYPER_LINK_FIELDS = new HashSet<String>();
    private static final String KEY_REPORT_CONTAINER = "reportlistap";
    private static final String KEY_orgs = "orgs";
    private static final String KEY_booktype = "booktype";
    private static final String KEY_periodtype = "periodtype";
    private static final String KEY_period = "period";
    private static final boolean IS_ORG_SUPVIR = true;
    private static final String KEY_CHART_CONTAINER = "sourceappchart";

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_PANEL_VOUCHER);
        filterGrid.setEntityNumber("gl_voucher");
        ArrayList<String> filterFileds = new ArrayList<String>(4);
        filterFileds.add("billno");
        filterFileds.add(Voucher.join((String[])new String[]{"creator", "number"}));
        filterFileds.add(Voucher.join((String[])new String[]{"vouchertype", "number"}));
        filterFileds.add("edescription");
        filterGrid.setFilterFieldKeys(filterFileds);
        this.getView().setVisible(Boolean.FALSE, new String[]{"isshowtodayscan"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl(KEY_REPORT_CONTAINER);
        list.addHyperClickListener(evt -> {
            String clickFieldName = evt.getFieldName();
            if (HYPER_LINK_FIELDS.contains(clickFieldName)) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_REPORT_CONTAINER);
                DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
                if ("billno".equals(clickFieldName)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId(rowData.getString("billtype"));
                    showParameter.setPkId(rowData.get("billid"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                } else if ("vouchernumber".equals(clickFieldName)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("gl_voucher");
                    showParameter.setPkId(rowData.get("voucherid"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        });
        BasedataEdit bePeriod = (BasedataEdit)this.getControl(KEY_period);
        bePeriod.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            Object objOrgs = model.getValue(KEY_orgs);
            if (objOrgs == null) {
                return;
            }
            DynamicObjectCollection dyOrgs = (DynamicObjectCollection)objOrgs;
            HashSet<Object> orgIds = new HashSet<Object>(dyOrgs.size());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            for (DynamicObject dyOrg : dyOrgs) {
                orgIds.add(dyOrg.get("fbasedataid.id"));
                filters.add(new QFilter("org", "in", orgIds));
            }
            Object objBookType = model.getValue(KEY_booktype);
            if (objBookType != null) {
                DynamicObject dyBookType = (DynamicObject)objBookType;
                filters.add(new QFilter("bookstype", "=", dyBookType.getPkValue()));
            }
            filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"iep.vouhistbeff7.booktype", (String)"gl_accountbook", (String)"id,periodtype,startperiod", (QFilter[])filters.toArray(new QFilter[0]), null);){
                Iterator iter = ds.iterator();
                HashSet<Object> pookTpepkIds = new HashSet<Object>(16);
                Long minStartPeriod = 0L;
                Long startPeriod = 0L;
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    pookTpepkIds.add(row.get(KEY_periodtype));
                    startPeriod = row.getLong("startperiod");
                    if (minStartPeriod != 0L && minStartPeriod <= startPeriod) continue;
                    minStartPeriod = startPeriod;
                }
                ArrayList<QFilter> QFilters = new ArrayList<QFilter>(2);
                QFilters.add(new QFilter(KEY_periodtype, "in", pookTpepkIds));
                QFilters.add(new QFilter("id", ">=", (Object)minStartPeriod));
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                filterParam.getQFilters().addAll(QFilters);
            }
        });
        BasedataEdit beOrg = (BasedataEdit)this.getControl(KEY_orgs);
        beOrg.addBeforeF7SelectListener(evt -> {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"iep.vouhistbeff7.orgs", (String)"gl_accountbook", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("isbizunit", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)}, null);){
                Iterator iter = ds.iterator();
                HashSet<Object> pkIds = new HashSet<Object>(16);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    pkIds.add(row.get("org"));
                }
                if (!pkIds.isEmpty()) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                    listFilterParameter.setFilter(new QFilter("id", "in", pkIds));
                }
            }
        });
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Boolean isShowTodayScanBills = queryParam.getFilter().getBoolean("isshowtodayscan");
        if (!isShowTodayScanBills.booleanValue()) {
            if (this.getCurrentModelOrgIds().size() == 0) {
                this.getView().showTipNotification(IepReportMsgs.requireOrg());
                return false;
            }
            if (filterInfo.getLong(KEY_booktype) == 0L) {
                this.getView().showTipNotification(IepReportMsgs.requireBookType());
                return false;
            }
            if (filterInfo.getLong(KEY_periodtype) == 0L) {
                this.getView().showTipNotification(IepReportMsgs.requirePeriodType());
                return false;
            }
            if (filterInfo.getLong(KEY_period) == 0L) {
                this.getView().showTipNotification(IepReportMsgs.requirePeriod());
                return false;
            }
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_PANEL_VOUCHER);
        FilterCondition cond = filterGrid.getFilterGridState().getFilterCondition();
        ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
        IUserService userService = (IUserService)this.getView().getService(IUserService.class);
        queryParam.getFilter().addCommFilter("gl_voucher", cond, timeService, userService);
        FilterItemInfo pageFilterItem = queryParam.getFilter().getFilterItem("pageID");
        if (Objects.nonNull(pageFilterItem)) {
            pageFilterItem.setValue((Object)this.getView().getPageId());
        } else {
            queryParam.getFilter().addFilterItem("pageID", (Object)this.getView().getPageId());
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        this.getModel().setValue("isshowtodayscan", (Object)Boolean.FALSE);
        this.switchPanel(true);
        this.managerChart(queryParam);
    }

    private void managerChart(ReportQueryParam queryParam) {
        FilterItemInfo pageIDInfo = queryParam.getFilter().getFilterItem("pageID");
        String pageID = Objects.isNull(pageIDInfo.getValue()) ? "" : pageIDInfo.getValue().toString();
        List<VoucherFileHistQueryRpt.AppVoucherStatisticInfo> appVoucherInfos = this.getCachedChartData(pageID);
        if (CollectionUtils.isEmpty(appVoucherInfos)) {
            this.switchChart(false);
            return;
        }
        this.switchChart(true);
        Chart customChart = (Chart)this.getControl(KEY_CHART_CONTAINER);
        customChart.clearData();
        customChart.setShowTitle(false);
        customChart.setShowTooltip(true);
        customChart.setShowLegend(true);
        customChart.setLegendAlign(XAlign.center, YAlign.top);
        customChart.setMargin(Position.bottom, "40px");
        customChart.setMargin(Position.left, "20px");
        Axis xaxis = customChart.createXAxis("", AxisType.category);
        xaxis.setPosition(Position.bottom);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        BarSeries expireSeries = customChart.createBarSeries(IepReportMsgs.titleFiled());
        String stack = "sss";
        expireSeries.setStack(stack);
        expireSeries.setBarWidth("40%");
        expireSeries.setColor("#80c342");
        expireSeries.getLabel().setShow(false);
        BarSeries expireSeries2 = customChart.createBarSeries(IepReportMsgs.titleUnderFile());
        expireSeries2.setStack(stack);
        expireSeries2.setBarWidth("40%");
        expireSeries2.setColor("#6680fb");
        expireSeries2.getLabel().setShow(false);
        DynamicObjectCollection appMetaInfos = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", appVoucherInfos.stream().map(VoucherFileHistQueryRpt.AppVoucherStatisticInfo::getSourceAppId).collect(Collectors.toList()))});
        Map<Object, DynamicObject> appMetaInfoMap = appMetaInfos.stream().collect(Collectors.toMap(appMetaInfo -> appMetaInfo.get("id"), appMetaInfo -> appMetaInfo));
        appVoucherInfos.sort(new Comparator<VoucherFileHistQueryRpt.AppVoucherStatisticInfo>(){

            @Override
            public int compare(VoucherFileHistQueryRpt.AppVoucherStatisticInfo o1, VoucherFileHistQueryRpt.AppVoucherStatisticInfo o2) {
                return Integer.compare(o2.getFiledCount() + o2.getUnfiledCount(), o1.getFiledCount() + o1.getUnfiledCount());
            }
        });
        ArrayList<String> xDimensions = new ArrayList<String>(appVoucherInfos.size());
        ArrayList<Integer> ydata1 = new ArrayList<Integer>(appVoucherInfos.size());
        ArrayList<Integer> ydata2 = new ArrayList<Integer>(appVoucherInfos.size());
        for (VoucherFileHistQueryRpt.AppVoucherStatisticInfo appVoucherInfo : appVoucherInfos) {
            xDimensions.add(appMetaInfoMap.get(appVoucherInfo.getSourceAppId()).getString("name"));
            ydata1.add(appVoucherInfo.getFiledCount());
            ydata2.add(appVoucherInfo.getUnfiledCount());
        }
        xaxis.setCategorys(xDimensions);
        Axis yAxis = customChart.createYAxis(IepReportMsgs.titleVoucherAmount(), AxisType.value);
        yAxis.setPropValue("axisTick", axisTick);
        int maxCount = appVoucherInfos.get(0).getTotal();
        this.setYAxisMaxValue(yAxis, maxCount);
        expireSeries.setData((Number[])ydata1.toArray(new Integer[0]));
        expireSeries2.setData((Number[])ydata2.toArray(new Integer[0]));
        customChart.refresh();
    }

    private void switchPanel(boolean isShow) {
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"flexpanelap"});
    }

    private void switchChart(boolean isShow) {
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"titlecontainer"});
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"chartcontainer"});
    }

    private List<VoucherFileHistQueryRpt.AppVoucherStatisticInfo> getCachedChartData(String pageId) {
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            return Collections.EMPTY_LIST;
        }
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        String cacheData = cache.get(pageId);
        if (StringUtils.isEmpty((CharSequence)cacheData)) {
            return Collections.EMPTY_LIST;
        }
        List appVoucherInfos = SerializationUtils.fromJsonStringToList((String)cacheData, VoucherFileHistQueryRpt.AppVoucherStatisticInfo.class);
        return appVoucherInfos;
    }

    private void setYAxisMaxValue(Axis yAxis, double maxTask) {
        double baseParam = maxTask <= 100.0 ? 25.0 : (maxTask > 100.0 && maxTask <= 500.0 ? 50.0 : (maxTask > 500.0 && maxTask <= 1000.0 ? 100.0 : (maxTask > 1000.0 && maxTask <= 5000.0 ? 500.0 : (maxTask > 5000.0 && maxTask <= 10000.0 ? 1000.0 : (maxTask > 10000.0 && maxTask <= 50000.0 ? 5000.0 : (maxTask >= 50000.0 && maxTask < 100000.0 ? 10000.0 : 50000.0))))));
        Double yMaxValue = BigDecimal.valueOf(maxTask).compareTo(new BigDecimal(0)) != 0 && BigDecimal.valueOf(maxTask % baseParam).compareTo(new BigDecimal(0)) == 0 ? maxTask : (double)(Math.floorDiv((long)maxTask, (long)baseParam) + 1L) * baseParam;
        Double interval = yMaxValue / 5.0;
        if (maxTask < 10.0) {
            yAxis.setMax((Number)10);
        } else {
            yAxis.setMax((Number)yMaxValue);
            yAxis.setInterval((Number)interval);
        }
    }

    private Double getMaxNumber(Double[] ary, Double[] ary2) {
        if (ary == null || ary.length == 0) {
            return 10.0;
        }
        Double max = ary[0];
        for (int i = 0; i < ary.length && i < ary2.length && ary2[i] != null && ary[i] != null; ++i) {
            max = Math.max(ary[i] + ary2[i], max);
        }
        return max;
    }

    public void afterCreateNewData(EventObject e) {
        this.initOrg();
        this.setMulBookType(this.getCurrentModelOrgIds());
    }

    private List<Long> getCurrentModelOrgIds() {
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_orgs);
        return dynamicObjects.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    private List<Long> getAvailableBookTypeIds(List<Long> orgIds) {
        HashSet bookIdSet = new HashSet();
        if (Objects.nonNull(orgIds)) {
            orgIds.stream().forEach(x -> bookIdSet.addAll(AccSysUtil.getAllBookFromAccSys((long)x)));
        }
        return new ArrayList<Long>(bookIdSet);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        switch (propertyName) {
            case "orgs": {
                this.setMulBookType(this.getCurrentModelOrgIds());
                break;
            }
            case "booktype": {
                Long bookTypeId = ((DynamicObject)value).getLong("id");
                this.setBook(bookTypeId);
                break;
            }
            case "periodtype": {
                String str = this.getPageCache().get("ptSpMap");
                Map ptSpMap = (Map)GLUtil.fromSerializedString((String)str);
                long periodTypeId = ((DynamicObject)value).getLong("id");
                this.setPeriodFilter(Collections.singletonList(periodTypeId));
                break;
            }
            case "period": {
                break;
            }
        }
    }

    private void setMulBookType(List<Long> orgList) {
        Long defaultBookType = null;
        LinkedHashSet<Long> bookTypes = new LinkedHashSet<Long>();
        QFilter orgFiler = new QFilter("org", "in", orgList);
        List ids = AccSysUtil.getBookTypeDataPermission(orgList);
        if (ids != null) {
            orgFiler = orgFiler.and(new QFilter("bookstype", "in", (Object)ids));
        }
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler, entityFilter});
        HashSet<Long> childOrg = new HashSet<Long>(8);
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            if ("1".equals(bt.getString("type"))) {
                defaultBookType = bt.getLong("id");
            }
            childOrg.add(bt.getLong("org"));
        }
        this.getPageCache().put("_childOrgSet", GLUtil.toSerializedString(childOrg));
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.iterator().next();
        }
        if (defaultBookType == null) {
            this.clearControlByKey(KEY_booktype);
            this.clearControlByKey(KEY_periodtype);
            this.clearControlByKey(KEY_period);
            return;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setBT(Collection<Long> bookTypes, long defaultBookType) {
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl(KEY_booktype);
        ViewUtils.setF7ClickFilter((BasedataEdit)bookTypeEdit, (QFilter)new QFilter("id", "in", bookTypes));
        this.getView().setVisible(Boolean.valueOf(bookTypes.size() > 1), new String[]{KEY_booktype});
        this.getModel().setValue(KEY_booktype, (Object)defaultBookType);
        this.setBook(defaultBookType);
    }

    private void setBook(Long bookTypeId) {
        List bookInfoList;
        IDataModel model = this.getModel();
        Set childOrgSet = new HashSet();
        String str = this.getPageCache().get("_childOrgSet");
        if (str != null) {
            childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
        }
        if (CollectionUtils.isEmpty((Collection)(bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)bookTypeId)))) {
            this.clearControlByKey(KEY_periodtype);
            this.clearControlByKey(KEY_period);
        }
        HashSet<Long> periodTypes = new HashSet<Long>(bookInfoList.size());
        long defaultPeriodType = 0L;
        Long defaultCurPeriod = 0L;
        HashMap ptSpMap = new HashMap();
        for (int i = 0; i < bookInfoList.size(); ++i) {
            AccountBookInfo book = (AccountBookInfo)bookInfoList.get(i);
            long periodTypeId = book.getPeriodTypeId();
            long curPeriodId = book.getCurPeriodId();
            GlFormUtil.putMap(ptSpMap, (Object)periodTypeId, (Object)curPeriodId);
            periodTypes.add(periodTypeId);
            if (i != 0) continue;
            defaultPeriodType = periodTypeId;
            defaultCurPeriod = book.getCurPeriodId();
        }
        this.getPageCache().put("ptSpMap", GLUtil.toSerializedString(ptSpMap));
        this.setPeriodFilter(new ArrayList<Long>(ptSpMap.keySet()));
        this.getView().setVisible(Boolean.valueOf(periodTypes.size() > 1), new String[]{KEY_periodtype});
        BasedataEdit periodTypeEdit = (BasedataEdit)this.getControl(KEY_periodtype);
        ViewUtils.setF7ClickFilter((BasedataEdit)periodTypeEdit, (QFilter)new QFilter("id", "in", periodTypes));
        model.setValue(KEY_periodtype, (Object)defaultPeriodType);
        model.setValue(KEY_period, (Object)defaultCurPeriod);
    }

    public void setBookTypeView(List<Long> orgs) {
        HashSet bookIdSet = new HashSet();
        orgs.stream().forEach(x -> bookIdSet.addAll(AccSysUtil.getAllBookFromAccSys((long)x)));
        if (bookIdSet.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_booktype});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_booktype});
        }
    }

    private void setEntityBookType(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        List<Long> bookIds = this.getAvailableBookTypeIds(orgIds);
        if (CollectionUtils.isEmpty(bookIds)) {
            return;
        }
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl(KEY_booktype);
        ViewUtils.setF7ClickFilter((BasedataEdit)bookTypeEdit, (QFilter)new QFilter("id", "in", bookIds));
        this.getView().setVisible(Boolean.valueOf(bookIds.size() > 1), new String[]{KEY_booktype});
        Long defaultBookType = bookIds.get(0);
        this.getModel().setValue(KEY_booktype, (Object)defaultBookType);
    }

    private void setPeriodFilter(List<Long> periodTypeIds) {
        BasedataEdit periodEdit = (BasedataEdit)this.getControl(KEY_period);
        ViewUtils.setF7ClickFilter((BasedataEdit)periodEdit, (QFilter)new QFilter("periodtype.id", "in", periodTypeIds));
    }

    private void clearControlByKey(String controlKey) {
        this.getModel().setValue(controlKey, null);
        ViewUtils.setF7ClickFilter((BasedataEdit)((BasedataEdit)this.getControl(controlKey)), (QFilter)new QFilter("id", "=", (Object)-1));
    }

    private void initOrg() {
        List orgList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.VIEW);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl(KEY_orgs);
        orgEdit.setQFilter(new QFilter("id", "in", (Object)orgList));
        Long defaultOrgId = GlFormUtil.getDefaultAcctOrg((List)orgList);
        if (Objects.nonNull(defaultOrgId)) {
            this.getModel().setValue(KEY_orgs, (Object)BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{defaultOrgId}, (String)"bos_org"));
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String formatedFilterString = evt.getFormatedFilterString();
        boolean isSingleOrgManageMode = SingleOrgContextHelper.isSingleOrgManageMode();
        if (isSingleOrgManageMode) {
            return;
        }
        Long parentOrg = AccSysUtil.getParentOrgByChildre(this.getCurrentModelOrgIds());
        String name = "";
        if (parentOrg != null && parentOrg != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)parentOrg, (String)"bos_org", (String)"name");
            name = org.getString("name");
        }
        String result = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%s; ", (String)"VoucherFileHistReport_9", (String)"fi-iep-report", (Object[])new Object[0]), name) + formatedFilterString;
        evt.setFormatedFilterString(result);
    }

    static {
        HYPER_LINK_FIELDS.add("billno");
        HYPER_LINK_FIELDS.add("vouchernumber");
    }
}

