/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.fatvs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class SkillRunnableImpl
implements ISkillRunnable {
    private static final String ALGO_KEY = SkillRunnableImpl.class.getName();
    private static final Log logger = LogFactory.getLog(SkillRunnableImpl.class);
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"ISkillRunnable_Pa");

    public SkillRunResult pullData(SkillRunContext runContext) {
        SkillRunResult skillResult = runContext.getSkillResult();
        String skillNum = runContext.getSkillNum();
        Date startTime = runContext.getStartTime();
        Date endTime = runContext.getEndTime();
        List<Tuple<String, String>> modelData = this.getModelData();
        Map<String, Integer> indicators = this.processIndicatorCalculation(modelData, startTime, endTime);
        List<Map<String, String>> list = this.processResultData(indicators);
        skillResult.setData(list);
        skillResult.setDate(runContext.getStartTime());
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(indicators.get("timeAllocatedCount"));
        return skillResult;
    }

    private List<Map<String, String>> processResultData(Map<String, Integer> indicators) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Integer allocatedOrgCount = indicators.get("allocatedOrgCount");
        Integer orgCount = indicators.get("orgCount");
        Integer rules = indicators.get("rules");
        HashMap<String, String> param2Map = new HashMap<String, String>();
        param2Map.put("name", ResManager.loadKDString((String)"\u5206\u644a\u89c4\u5219\u6570", (String)"SkillRunnableImpl_0", (String)"fi-pa-mservice", (Object[])new Object[0]));
        param2Map.put("value", rules + "");
        param2Map.put("valueType", "0");
        param2Map.put("number", "ftgzs");
        HashMap<String, String> param3Map = new HashMap<String, String>();
        param3Map.put("name", ResManager.loadKDString((String)"\u5df2\u5206\u644a\u7ec4\u7ec7/\u603b\u6570", (String)"SkillRunnableImpl_1", (String)"fi-pa-mservice", (Object[])new Object[0]));
        param3Map.put("value", allocatedOrgCount + "/" + orgCount);
        param3Map.put("valueType", "2");
        param3Map.put("number", "yftzz");
        list.add(param2Map);
        list.add(param3Map);
        return list;
    }

    private boolean checkIsCreateTime(String entity) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        return entityType.getFields().containsKey("createtime");
    }

    private Map<String, Integer> processIndicatorCalculation(List<Tuple<String, String>> datas, Date startTime, Date endTime) {
        ArrayList<Future> futures = new ArrayList<Future>(datas.size());
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)-1);
        for (Tuple<String, String> data : datas) {
            boolean isTime = false;
            String entity = (String)data.item1;
            QFilter timeFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            String orgNumber = (String)data.item2;
            StringBuilder fields = new StringBuilder(orgNumber);
            fields.append(",id").append(",datastatus");
            if (this.checkIsCreateTime(entity)) {
                isTime = true;
                fields.append(",createtime");
                timeFilter = new QFilter("createtime", ">=", (Object)startTime).and("createtime", "<", (Object)endTime);
            }
            boolean flag = isTime;
            QFilter finalTimeFilter = timeFilter;
            Future task = pool.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
            futures.add(task);
        }
        Iterator iterator = futures.iterator();
        int timeAllocatedCount = 0;
        int allocatedCount = 0;
        HashSet allocatedOrgIds = new HashSet(10);
        HashSet orgIds = new HashSet(10);
        while (iterator.hasNext()) {
            Future current = (Future)iterator.next();
            try {
                FourTuple result = (FourTuple)current.get();
                timeAllocatedCount += ((Integer)result.item1).intValue();
                allocatedCount += ((Integer)result.item2).intValue();
                allocatedOrgIds.addAll((Collection)result.item3);
                orgIds.addAll((Collection)result.item4);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(String.format("[FI-PA] Occurred an interruptedException, e:%s", e));
            }
            catch (ExecutionException e) {
                logger.error(String.format("[FI-PA] Occurred an Exception, e:%s", e));
            }
        }
        int allocatedOrgCount = allocatedOrgIds.size();
        int orgCount = orgIds.size();
        int rules = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_sharerulenew", (String)"id", null, null);){
            rules = dataSet.count("id", true);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(7);
        map.put("timeAllocatedCount", timeAllocatedCount);
        map.put("allocatedCount", allocatedCount);
        map.put("allocatedOrgCount", allocatedOrgCount);
        map.put("orgCount", orgCount);
        map.put("rules", rules);
        return map;
    }

    private List<Tuple<String, String>> getModelData() {
        QFilter filter = new QFilter("tablenumber", "!=", (Object)"").and("tablenumber", "!=", (Object)" ");
        QFilter orgFilter = new QFilter("dimension_entry.necessity_dim", "=", (Object)"0");
        ArrayList<Tuple<String, String>> datas = new ArrayList<Tuple<String, String>>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_analysismodel", (String)"tablenumber,dimension_entry.dimension.number,dimension_entry.necessity_dim", (QFilter[])new QFilter[]{filter, orgFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String tableNumber = "pa_" + row.getString("tablenumber");
                String orgDimensionNumber = row.getString("dimension_entry.dimension.number");
                if (StringUtils.isBlank((CharSequence)orgDimensionNumber)) continue;
                datas.add((Tuple<String, String>)new Tuple((Object)tableNumber, (Object)orgDimensionNumber));
            }
        }
        return datas;
    }
}

