/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.mservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class AllocationRuleUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(AllocationRuleUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            String resultStr = this.upgradeAllocationRule();
            String msg = "UpgradeAllocationRule upgrade succeed! info:" + resultStr;
            upgradeResult.setSuccess(true);
            upgradeResult.setLog(msg);
            logger.info("[FI-PA] " + msg);
        }
        catch (Exception e) {
            String msg = "UpgradeAllocationRule upgrade failed! error:" + e.getMessage();
            upgradeResult.setSuccess(false);
            upgradeResult.setEl("error");
            upgradeResult.setErrorInfo(msg);
            upgradeResult.setLog(msg);
            logger.error("[FI-PA] " + msg, (Throwable)e);
        }
        return upgradeResult;
    }

    private String upgradeAllocationRule() {
        logger.info("[FI-PA] UpgradeAllocationRule start!");
        StringBuilder resultSb = new StringBuilder();
        MainEntityType meta = null;
        try {
            meta = EntityMetadataCache.getDataEntityType((String)"pa_sharerulenew");
            resultSb.append("1.checkMeta success!");
        }
        catch (Exception e) {
            logger.error("[FI-PA] Check meta:pa_sharerulenew not exist!", (Throwable)e);
            resultSb.append("1.checkMeta is not exist!");
        }
        if (meta != null) {
            try {
                DBRoute dbRoute = DBRoute.of((String)meta.getDBRouteKey());
                String sql = "select fid from t_pa_sharerulenew where fsendrate is null or fsendrate = 0";
                List idList = (List)DB.query((DBRoute)dbRoute, (String)sql, rs -> {
                    ArrayList<Long> ids = new ArrayList<Long>(10);
                    while (rs.next()) {
                        Long id = rs.getLong(1);
                        ids.add(id);
                    }
                    return ids;
                });
                resultSb.append("2.queryId success!");
                if (!idList.isEmpty()) {
                    Date date = new Date();
                    BigDecimal percent = new BigDecimal(100).setScale(2, RoundingMode.HALF_UP);
                    String updateSql = "UPDATE t_pa_sharerulenew SET fmodifytime=?, fsendrate=? WHERE fid=?";
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(idList.size());
                    for (int i = 0; i < idList.size(); ++i) {
                        paramsList.add(new Object[]{date, percent, idList.get(i)});
                    }
                    DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
                }
                resultSb.append("3.batchUpdate success!");
            }
            catch (Exception e) {
                logger.error("[FI-PA] Exec sql error!", (Throwable)e);
                throw e;
            }
        }
        logger.info("[FI-PA] UpgradeAllocationRule end!");
        return resultSb.toString();
    }
}

