/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cvp;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.pa.cost.CostAttributeEnum;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.EntryTreeNode;

public class CvprofitSchemaSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validateEntry(dataEntity);
        }
    }

    private void validateEntry(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection treeentryentity = dataEntity.getDataEntity().getDynamicObjectCollection("treeentryentity");
        Set attributeSet = treeentryentity.stream().map(dynamicObject -> dynamicObject.getString("attribute")).collect(Collectors.toSet());
        if (!attributeSet.contains(CostAttributeEnum.ATTRIBUTE_5.getCode())) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u65b9\u6848\u5b9a\u4e49\u4e2d\u589e\u52a0\u201d\u5c5e\u6027\u201c\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"CvprofitSchemaSaveValidator_0", (String)"fi-pa-opplugin", (Object[])new Object[0]), CostAttributeEnum.ATTRIBUTE_5.getDesc()));
        }
        if (!attributeSet.contains(CostAttributeEnum.ATTRIBUTE_6.getCode())) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u65b9\u6848\u5b9a\u4e49\u4e2d\u589e\u52a0\u201d\u5c5e\u6027\u201c\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"CvprofitSchemaSaveValidator_0", (String)"fi-pa-opplugin", (Object[])new Object[0]), CostAttributeEnum.ATTRIBUTE_6.getDesc()));
        }
        if (!attributeSet.contains(CostAttributeEnum.ATTRIBUTE_1.getCode()) && !attributeSet.contains(CostAttributeEnum.ATTRIBUTE_3.getCode())) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u65b9\u6848\u5b9a\u4e49\u4e2d\u589e\u52a0\u201d\u5c5e\u6027\u201c\u4e3a\u201c%1$s\u201d\u6216\u201c%2$s\u201d\u7684\u6570\u636e\u3002", (String)"CvprofitSchemaSaveValidator_1", (String)"fi-pa-opplugin", (Object[])new Object[0]), CostAttributeEnum.ATTRIBUTE_1.getDesc(), CostAttributeEnum.ATTRIBUTE_3.getDesc()));
        }
        if (!attributeSet.contains(CostAttributeEnum.ATTRIBUTE_2.getCode()) && !attributeSet.contains(CostAttributeEnum.ATTRIBUTE_4.getCode())) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u65b9\u6848\u5b9a\u4e49\u4e2d\u589e\u52a0\u201d\u5c5e\u6027\u201c\u4e3a\u201c%1$s\u201d\u6216\u201c%2$s\u201d\u7684\u6570\u636e\u3002", (String)"CvprofitSchemaSaveValidator_1", (String)"fi-pa-opplugin", (Object[])new Object[0]), CostAttributeEnum.ATTRIBUTE_2.getDesc(), CostAttributeEnum.ATTRIBUTE_4.getDesc()));
        }
        String datasourcetype = dataEntity.getDataEntity().getString("datasourcetype");
        EntryTreeNode root = CvprofitBusinessHelper.buildTreeNode((DynamicObjectCollection)treeentryentity);
        List nodes = root.getNodes(false);
        for (EntryTreeNode node : nodes) {
            if (!node.isLeaf()) continue;
            this.valiNotNull(dataEntity, node.getData(), "attribute");
            if ("1".equals(datasourcetype)) {
                this.valiNotNull(dataEntity, node.getData(), "evaluation");
                continue;
            }
            if (!"2".equals(datasourcetype)) continue;
            this.valiNotNull(dataEntity, node.getData(), "fixedvalue");
        }
    }

    private void valiNotNull(ExtendedDataEntity dataEntity, DynamicObject entry, String field) {
        LocaleString displayName = entry.getDataEntityType().getDisplayName();
        IDataEntityProperty property = (IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)field);
        IDataEntityProperty property_valid = property instanceof LargeTextProp ? (IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)(field + "_tag")) : property;
        if (property_valid.isEmpty((Object)entry)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u5355\u636e\u4f53\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u3002", (String)"CvprofitSchemaSaveValidator_2", (String)"fi-pa-opplugin", (Object[])new Object[0]), displayName, entry.get("seq"), property.getDisplayName()));
        }
    }
}

