/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.opplugin;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class BusinessRuleDeleteOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] sucessObjs = e.getDataEntities();
        if (sucessObjs.length <= 0) {
            return;
        }
        Object[] ids = new Object[sucessObjs.length];
        int index = 0;
        for (DynamicObject sucessObj : sucessObjs) {
            ids[index++] = sucessObj.get("id");
        }
        Map dataMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)sucessObjs[0].getDynamicObjectType().getName());
        ArrayList<Long> shareRuleIdList = new ArrayList<Long>(10);
        ArrayList<Long> derivationRuleIdList = new ArrayList<Long>(10);
        for (DynamicObject sucessObj : dataMap.values()) {
            DynamicObjectCollection stepEntry = sucessObj.getDynamicObjectCollection("stepentry");
            block10: for (DynamicObject dynamicObject : stepEntry) {
                String handType;
                switch (handType = dynamicObject.getString("cardhandletype")) {
                    case "A": {
                        derivationRuleIdList.add(dynamicObject.getLong("cardderivationmodel_id"));
                        continue block10;
                    }
                    case "B": {
                        shareRuleIdList.add(dynamicObject.getLong("cardsharemodel_id"));
                        continue block10;
                    }
                }
                throw new KDBizException("unsupport cardhandletype");
            }
        }
        if (!shareRuleIdList.isEmpty()) {
            DeleteServiceHelper.delete((String)"pa_sharerulenew", (QFilter[])new QFilter[]{new QFilter("id", "in", shareRuleIdList)});
        }
        if (!derivationRuleIdList.isEmpty()) {
            DeleteServiceHelper.delete((String)"pa_derivationrule", (QFilter[])new QFilter[]{new QFilter("id", "in", derivationRuleIdList)});
        }
    }
}

