/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.dataAdjust.DataAdjustUtils;

public class DataAdjustValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(DataAdjustValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length != 1) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String billstatus = bill.getString("billstatus");
            if ("A".equals(billstatus) && !DataAdjustUtils.checkAdjustJsonDataRight((DynamicObject)bill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u8c03\u6574\u5355\u7ef4\u5ea6\u6216\u5ea6\u91cf\u4e0e\u5206\u6790\u6a21\u578b\u4e0d\u4e00\u81f4\u3002", (String)"DataAdjustValidator_1", (String)"fi-pa-opplugin", (Object[])new Object[0]));
                return;
            }
            if (DataAdjustUtils.getUnValidRowBillNo((DynamicObject[])new DynamicObject[]{bill}).isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u8c03\u6574\u5355\u5b58\u5728\u6e90\u6570\u636e\u5931\u6548\u884c\uff0c\u8bf7\u66ff\u6362\u6b63\u786e\u7684\u6e90\u6570\u636e\u3002", (String)"DataAdjustValidator_0", (String)"fi-pa-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

