/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.common.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.pa.common.cache.IDataCacheModule;

public class DistributeCacheUtil {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(IDataCacheModule.PA.name(), new DistributeCacheHAPolicy(true, true));

    private static String getAcctId() {
        String acctId = new StringBuilder(64).append(RequestContext.get().getAccountId()).toString();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"PAUtil_1", (String)"fi-pa-common", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static void put(String key, Object value, int timeoutSeconds) {
        String valJson = SerializationUtils.toJsonString((Object)value);
        cache.put(DistributeCacheUtil.getAcctId() + key, (Object)valJson, timeoutSeconds);
    }

    public static <T> T get(String key, Class<T> clazz) {
        String json = (String)cache.get(DistributeCacheUtil.getAcctId() + key);
        return (T)(json != null && !json.isEmpty() ? SerializationUtils.fromJsonString((String)json, clazz) : null);
    }

    public static void expireAfter(String key, int timeoutSeconds) {
        cache.expireAfter(DistributeCacheUtil.getAcctId() + key, timeoutSeconds);
    }
}

