/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.formula.FormulaEngine;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.util.ScriptBuilder;

public class CalculateCondition {
    private String entityNumber;
    private CRValByConditions crValByConditions;
    private String conditionScript;
    private MainEntityType billEntity;
    private List<String> expressList;
    private Set<String> fieldSet;

    public CalculateCondition() {
        this.expressList = new ArrayList<String>(2);
        this.fieldSet = new HashSet<String>(2);
    }

    public CalculateCondition(String entityNumber, CRValByConditions crValByConditions) {
        this.entityNumber = entityNumber;
        this.crValByConditions = crValByConditions;
        this.billEntity = EntityMetadataCache.getDataEntityType((String)entityNumber);
        this.expressList = new ArrayList<String>(2);
        this.fieldSet = new HashSet<String>(2);
    }

    public CalculateCondition(String entityNumber, String formulaStr) {
        this.entityNumber = entityNumber;
        this.crValByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)formulaStr, CRValByConditions.class);
        this.billEntity = EntityMetadataCache.getDataEntityType((String)entityNumber);
        this.expressList = new ArrayList<String>(2);
        this.fieldSet = new HashSet<String>(2);
    }

    public void tranCondition() {
        if (StringUtils.isNotEmpty((String)this.conditionScript)) {
            return;
        }
        List conditionList = this.crValByConditions.getItems();
        if (conditionList == null || conditionList.isEmpty()) {
            return;
        }
        StringBuilder scriptBuilder = new StringBuilder();
        int i = 0;
        for (CRValByCondition item : conditionList) {
            CRCondition condition = item.getCondition();
            String express = this.filterToExpress(condition.getFilterCondition());
            String ifStm = String.format("if (%s) {\n   return %d;\n}\n", express, i);
            scriptBuilder.append(ifStm);
            ++i;
        }
        this.conditionScript = scriptBuilder.toString();
    }

    public String filterToExpress(FilterCondition filterCondition) {
        ScriptBuilder scriptBuilder = new ScriptBuilder(this.billEntity, filterCondition);
        ScriptBuilder.ValueAndDesc buildScripts = scriptBuilder.buildScript();
        return buildScripts.getValue();
    }

    public Set<String> parseProperty() {
        List conditionList = this.crValByConditions.getItems();
        if (conditionList == null || conditionList.isEmpty()) {
            return this.fieldSet;
        }
        if (!this.fieldSet.isEmpty()) {
            return this.fieldSet;
        }
        Map allFields = this.billEntity.getAllFields();
        for (CRValByCondition item : conditionList) {
            String[] scriptFieldArray;
            CRCondition condition = item.getCondition();
            FilterCondition filter = condition.getFilterCondition();
            List list = filter.getFilterRow();
            for (SimpleFilterRow filterRow : list) {
                String filterName = this.suppertEntry(filterRow.getFieldName(), allFields);
                this.fieldSet.add(filterName);
            }
            String expression = item.getFormula().getExpression();
            for (String scriptField : scriptFieldArray = FormulaEngine.extractVariables((String)expression)) {
                String fullFieldName = this.suppertEntry(scriptField, allFields);
                this.fieldSet.add(fullFieldName);
                if (fullFieldName.equals(scriptField)) continue;
                expression = expression.replaceAll(scriptField, '(' + fullFieldName + ')');
            }
            this.expressList.add(expression);
        }
        return this.fieldSet;
    }

    private String suppertEntry(String field, Map<String, IDataEntityProperty> allFields) {
        IDataEntityProperty property;
        IDataEntityType parent;
        String metaField = field;
        if (field.indexOf(".") > 0) {
            metaField = field.substring(0, field.indexOf("."));
        }
        if (!this.entityNumber.equals((parent = (property = allFields.get(metaField)).getParent()).getName())) {
            metaField = parent.getName() + "." + field;
            IDataEntityType grandParent = parent.getParent();
            if (!this.entityNumber.equals(grandParent.getName())) {
                metaField = grandParent.getName() + "." + metaField;
            }
        } else {
            metaField = field;
        }
        return metaField;
    }

    public String getCalculateExpress(int index) {
        String express = this.expressList.get(index);
        return express;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public void setCrValByConditions(CRValByConditions crValByConditions) {
        this.crValByConditions = crValByConditions;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public CRValByConditions getCrValByConditions() {
        return this.crValByConditions;
    }

    public String getConditionScript() {
        return this.conditionScript;
    }

    public MainEntityType getBillEntity() {
        return this.billEntity;
    }
}

