/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.enums.DateRangeEnum;
import kd.fi.pa.enums.TimeTypeEnum;
import kd.fi.pa.utils.DateUtil;

@Deprecated
public class DataExtractingDTO
implements Serializable {
    private static final long serialVersionUID = -5283703363117606552L;
    private Set<Long> orgIdSet;
    private String timeType;
    private Date startDate;
    private Date endDate;
    private String periodBaseData;
    private Set<Long> periodIdSet;

    public DataExtractingDTO() {
    }

    public DataExtractingDTO(Set<Long> orgIdSet, String timeType, Date startDate, Date endDate, String periodBaseData, Set<Long> periodIdSet) {
        this.orgIdSet = orgIdSet;
        this.timeType = timeType;
        this.startDate = startDate;
        this.endDate = endDate;
        this.periodBaseData = periodBaseData;
        this.periodIdSet = periodIdSet;
    }

    public static DataExtractingDTO parseSyncDataParam(DynamicObject syncParamDynamicObject) {
        DynamicObjectCollection orgColDy = syncParamDynamicObject.getDynamicObjectCollection("org");
        Set<Long> orgIdSet = orgColDy.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        String timeType = syncParamDynamicObject.getString("timetype");
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum(timeType);
        String periodBaseData = null;
        Set periodIdSet = null;
        Date startDate = null;
        Date endDate = null;
        block0 : switch (timeTypeEnum) {
            case PERIOD: {
                periodBaseData = syncParamDynamicObject.getString("periodbasedata");
                if (StringUtils.equals((CharSequence)"bd_period", (CharSequence)periodBaseData)) {
                    DynamicObjectCollection acpdColDy = syncParamDynamicObject.getDynamicObjectCollection("accountperiod");
                    periodIdSet = acpdColDy.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    break;
                }
                if (!StringUtils.equals((CharSequence)"pa_analysisperiod", (CharSequence)periodBaseData)) break;
                DynamicObjectCollection anpdColDy = syncParamDynamicObject.getDynamicObjectCollection("analysisperiod");
                periodIdSet = anpdColDy.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
                break;
            }
            case DATE: {
                String dateRange = syncParamDynamicObject.getString("daterange");
                int count = syncParamDynamicObject.getInt("count");
                Date rangeStartDate = syncParamDynamicObject.getDate("range_startdate");
                Date rangeEndDate = syncParamDynamicObject.getDate("range_enddate");
                Date date = syncParamDynamicObject.getDate("date");
                DateRangeEnum dateRangeEnum = DateRangeEnum.getDateRangeEnum(dateRange);
                switch (dateRangeEnum) {
                    case OTHER_DAYS: {
                        if (count == 0) {
                            startDate = DateUtil.getCurrentDate();
                            endDate = DateUtil.getNextDay(DateUtil.getCurrentDate(), 1);
                            break block0;
                        }
                        startDate = DateUtil.getLastDay(DateUtil.getCurrentDate(), count);
                        endDate = DateUtil.getCurrentDate();
                        break block0;
                    }
                    case FEW_DAYS_AGO: {
                        if (count == 0) {
                            endDate = DateUtil.getNextDay(DateUtil.getCurrentDate(), 1);
                            break block0;
                        }
                        endDate = DateUtil.getLastDay(DateUtil.getCurrentDate(), count - 1);
                        break block0;
                    }
                    case SOME_DAYS: {
                        startDate = rangeStartDate;
                        endDate = DateUtil.getNextDay(rangeEndDate, 1);
                        break block0;
                    }
                    case EQUAL_DAY: {
                        startDate = date;
                        endDate = DateUtil.getNextDay(date, 1);
                        break block0;
                    }
                    case LARGE_DAY: {
                        startDate = DateUtil.getNextDay(date, 1);
                        break block0;
                    }
                    case LESS_DAY: {
                        endDate = date;
                        break block0;
                    }
                }
                break;
            }
        }
        DataExtractingDTO dataExtractingDTO = new DataExtractingDTO();
        dataExtractingDTO.setOrgIdSet(orgIdSet);
        dataExtractingDTO.setTimeType(timeType);
        dataExtractingDTO.setPeriodBaseData(periodBaseData);
        dataExtractingDTO.setPeriodIdSet(periodIdSet);
        dataExtractingDTO.setStartDate(startDate);
        dataExtractingDTO.setEndDate(endDate);
        return dataExtractingDTO;
    }

    public Long[] getOrgIds() {
        return this.orgIdSet.toArray(new Long[0]);
    }

    public Long[] getPeriodIds() {
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum(this.timeType);
        switch (timeTypeEnum) {
            case PERIOD: {
                return this.periodIdSet.toArray(new Long[0]);
            }
        }
        return new Long[0];
    }

    public QFilter getOrgQFilter(String orgField) {
        return new QFilter(orgField, "in", this.orgIdSet);
    }

    public QFilter getPeriodQFilter(String periodField) {
        QFilter periodFilter = null;
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum(this.timeType);
        switch (timeTypeEnum) {
            case PERIOD: {
                periodFilter = new QFilter(periodField, "in", this.periodIdSet);
                break;
            }
            case DATE: {
                if (this.startDate != null && this.endDate != null) {
                    periodFilter = new QFilter(periodField, ">=", (Object)this.startDate).and(new QFilter(periodField, "<", (Object)this.endDate));
                    break;
                }
                if (this.startDate != null) {
                    periodFilter = new QFilter(periodField, ">=", (Object)this.startDate);
                    break;
                }
                if (this.endDate == null) break;
                periodFilter = new QFilter(periodField, "<", (Object)this.endDate);
                break;
            }
        }
        return periodFilter;
    }

    public Set<Long> getOrgIdSet() {
        return this.orgIdSet;
    }

    public void setOrgIdSet(Set<Long> orgIdSet) {
        this.orgIdSet = orgIdSet;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getPeriodBaseData() {
        return this.periodBaseData;
    }

    public void setPeriodBaseData(String periodBaseData) {
        this.periodBaseData = periodBaseData;
    }

    public Set<Long> getPeriodIdSet() {
        return this.periodIdSet;
    }

    public void setPeriodIdSet(Set<Long> periodIdSet) {
        this.periodIdSet = periodIdSet;
    }
}

