/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.dto;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.enums.AnalysisPeriodEnum;
import kd.fi.pa.enums.DateRangeEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.TimeTypeEnum;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.utils.DateUtil;

public class DataProcessDTO
implements Serializable {
    private static final long serialVersionUID = -4258999352367842019L;
    private Long analysisSystemId;
    private Long analysisModelId;
    private Long businessPlanId;
    private Long businessRuleId;
    private Set<Long> orgIdSet;
    private String timeType;
    private Date startDate;
    private Date endDate;
    private String periodBaseData;
    private Set<Long> periodIdSet;

    public static List<DataProcessDTO> batchParseSyncDataParam(Collection<DynamicObject> syncParamDyCollections) {
        return syncParamDyCollections.stream().map(DataProcessDTO::parseSyncDataParam).collect(Collectors.toList());
    }

    public static DataProcessDTO parseSyncDataParam(DynamicObject syncParamDynamicObject) {
        Long systemId = syncParamDynamicObject.getLong("system_id");
        Long modelId = syncParamDynamicObject.getLong("model_id");
        Long businessPlanId = syncParamDynamicObject.getLong("businessplan_id");
        Long businessRuleId = syncParamDynamicObject.getLong("businessrule_id");
        DynamicObjectCollection orgColDy = syncParamDynamicObject.getDynamicObjectCollection("org");
        Set<Long> orgIdSet = orgColDy.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        String periodBaseData = null;
        HashSet<Long> periodIdSet = new HashSet<Long>(4);
        Date startDate = null;
        Date endDate = null;
        String timeType = syncParamDynamicObject.getString("timetype");
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum(timeType);
        switch (timeTypeEnum) {
            case PERIOD: {
                periodBaseData = syncParamDynamicObject.getString("periodbasedata");
                if (StringUtils.equals((CharSequence)"pa_analysisperiod", (CharSequence)periodBaseData)) {
                    QFilter analysisPeriodFilter = DataProcessDTO.getAnalysisPeriodQFilter(syncParamDynamicObject);
                    QFilter analysisAdjustFilter = new QFilter("isadjust", "=", (Object)"0");
                    QFilter analysisEnableFilter = new QFilter("enable", "=", (Object)"1");
                    DynamicObject analysisPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysisperiod", (QFilter[])new QFilter[]{analysisPeriodFilter, analysisEnableFilter, analysisAdjustFilter});
                    if (analysisPeriodDy != null) {
                        periodIdSet.add(analysisPeriodDy.getLong("id"));
                    }
                }
                if (!StringUtils.equals((CharSequence)"bd_period", (CharSequence)periodBaseData)) break;
                DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
                QFilter periodTypeQFilter = PAExecutorHelper.getBaseQFilter(analysisModel, DimensionNecessityEnum.PERIOD.getCode());
                DynamicObject periodTypeObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodtype", (QFilter[])periodTypeQFilter.toArray());
                Long periodTypeId = periodTypeObj.getLong("periodtype");
                QFilter accountPeriodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
                QFilter accountPeriodQFilter = DataProcessDTO.getAccountPeriodQFilter(syncParamDynamicObject);
                QFilter accountAdjustFilter = new QFilter("isadjustperiod", "=", (Object)"0");
                DynamicObject accountPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{accountPeriodTypeFilter, accountPeriodQFilter, accountAdjustFilter});
                if (accountPeriodDy == null) break;
                periodIdSet.add(accountPeriodDy.getLong("id"));
                break;
            }
            case DATE: {
                Date[] dates = DataProcessDTO.getDateRange(syncParamDynamicObject);
                startDate = dates[0];
                endDate = dates[1];
                break;
            }
        }
        DataProcessDTO dataProcessDTO = new DataProcessDTO();
        dataProcessDTO.setAnalysisSystemId(systemId);
        dataProcessDTO.setAnalysisModelId(modelId);
        dataProcessDTO.setBusinessPlanId(businessPlanId);
        dataProcessDTO.setBusinessRuleId(businessRuleId);
        dataProcessDTO.setOrgIdSet(orgIdSet);
        dataProcessDTO.setTimeType(timeType);
        dataProcessDTO.setPeriodBaseData(periodBaseData);
        dataProcessDTO.setPeriodIdSet(periodIdSet);
        dataProcessDTO.setStartDate(startDate);
        dataProcessDTO.setEndDate(endDate);
        return dataProcessDTO;
    }

    public static Date[] getDateRange(DynamicObject syncParamDynamicObject) {
        String dateRange = syncParamDynamicObject.getString("daterange");
        int count = syncParamDynamicObject.getInt("count");
        Date rangeStartDate = syncParamDynamicObject.getDate("range_startdate");
        Date rangeEndDate = syncParamDynamicObject.getDate("range_enddate");
        Date date = syncParamDynamicObject.getDate("date");
        Date startDate = null;
        Date endDate = null;
        DateRangeEnum dateRangeEnum = DateRangeEnum.getDateRangeEnum(dateRange);
        switch (dateRangeEnum) {
            case OTHER_DAYS: {
                if (count == 0) {
                    startDate = DateUtil.getCurrentDate();
                    endDate = DateUtil.getNextDay(DateUtil.getCurrentDate(), 1);
                    break;
                }
                startDate = DateUtil.getLastDay(DateUtil.getCurrentDate(), count);
                endDate = DateUtil.getCurrentDate();
                break;
            }
            case FEW_DAYS_AGO: {
                if (count == 0) {
                    endDate = DateUtil.getNextDay(DateUtil.getCurrentDate(), 1);
                    break;
                }
                endDate = DateUtil.getLastDay(DateUtil.getCurrentDate(), count - 1);
                break;
            }
            case SOME_DAYS: {
                startDate = rangeStartDate;
                endDate = DateUtil.getNextDay(rangeEndDate, 1);
                break;
            }
            case EQUAL_DAY: {
                startDate = date;
                endDate = DateUtil.getNextDay(date, 1);
                break;
            }
            case LARGE_DAY: {
                startDate = DateUtil.getNextDay(date, 1);
                break;
            }
            case LESS_DAY: {
                endDate = date;
                break;
            }
        }
        return new Date[]{startDate, endDate};
    }

    public static QFilter getAnalysisPeriodQFilter(DynamicObject syncParamDynamicObject) {
        String analysisPeriod = syncParamDynamicObject.getString("analysisperiodtype");
        if (StringUtils.isEmpty((CharSequence)analysisPeriod)) {
            return null;
        }
        int year = 0;
        int quarter = 0;
        int month = 0;
        Date curDate = DateUtil.getCurrentDate();
        AnalysisPeriodEnum analysisPeriodEnum = AnalysisPeriodEnum.getAnalysisPeriodEnum(analysisPeriod);
        switch (analysisPeriodEnum) {
            case CUR_MONTH: {
                year = DateUtil.getYear(curDate);
                quarter = DateUtil.getQuarter(curDate);
                month = DateUtil.getMonth(curDate);
                break;
            }
            case LAST_MONTH: {
                Date lastMonthDate = DateUtil.getLastMonth(curDate, 1);
                year = DateUtil.getYear(lastMonthDate);
                quarter = DateUtil.getQuarter(lastMonthDate);
                month = DateUtil.getMonth(lastMonthDate);
                break;
            }
            case CUR_QUARTER: {
                year = DateUtil.getYear(curDate);
                quarter = DateUtil.getQuarter(curDate);
                break;
            }
            case LAST_QUARTER: {
                Date lastQuarterDate = DateUtil.getLastQuarter(curDate, 1);
                year = DateUtil.getYear(lastQuarterDate);
                quarter = DateUtil.getQuarter(lastQuarterDate);
                break;
            }
            case CUR_YEAR: {
                year = DateUtil.getYear(curDate);
                break;
            }
            case LAST_YEAR: {
                Date lastYearDate = DateUtil.getLastYear(curDate, 1);
                year = DateUtil.getYear(lastYearDate);
                break;
            }
        }
        return new QFilter("year", "=", (Object)year).and("quarter", "=", (Object)quarter).and("month", "=", (Object)month);
    }

    public static QFilter getAccountPeriodQFilter(DynamicObject syncParamDynamicObject) {
        String offSet = syncParamDynamicObject.getString("periodoffset");
        if (StringUtils.isEmpty((CharSequence)offSet)) {
            return null;
        }
        Date curDate = DateUtil.getCurrentDate();
        Date lastMonthDate = DateUtil.getLastMonth(curDate, Integer.parseInt(offSet));
        int year = DateUtil.getYear(lastMonthDate);
        int quarter = DateUtil.getQuarter(lastMonthDate);
        int month = DateUtil.getMonth(lastMonthDate);
        return new QFilter("periodyear", "=", (Object)year).and("periodquarter", "=", (Object)quarter).and("periodnumber", "=", (Object)month);
    }

    public void setAnalysisSystemId(Long analysisSystemId) {
        this.analysisSystemId = analysisSystemId;
    }

    public Long getAnalysisModelId() {
        return this.analysisModelId;
    }

    public void setAnalysisModelId(Long analysisModelId) {
        this.analysisModelId = analysisModelId;
    }

    public Long getBusinessPlanId() {
        return this.businessPlanId;
    }

    public void setBusinessPlanId(Long businessPlanId) {
        this.businessPlanId = businessPlanId;
    }

    public Long getBusinessRuleId() {
        return this.businessRuleId;
    }

    public void setBusinessRuleId(Long businessRuleId) {
        this.businessRuleId = businessRuleId;
    }

    public Set<Long> getOrgIdSet() {
        return this.orgIdSet;
    }

    public void setOrgIdSet(Set<Long> orgIdSet) {
        this.orgIdSet = orgIdSet;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getPeriodBaseData() {
        return this.periodBaseData;
    }

    public void setPeriodBaseData(String periodBaseData) {
        this.periodBaseData = periodBaseData;
    }

    public Set<Long> getPeriodIdSet() {
        return this.periodIdSet;
    }

    public void setPeriodIdSet(Set<Long> periodIdSet) {
        this.periodIdSet = periodIdSet;
    }

    public Long getAnalysisSystemId() {
        return this.analysisSystemId;
    }
}

