/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.pa.engine.task.IDataAbstractWorkTask;
import kd.fi.pa.engine.task.IDataFutureWrapper;
import kd.fi.pa.engine.task.IDataWorkTask;
import kd.fi.pa.engine.task.PAWorkTaskManager;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Deprecated
public class IDataWorkTaskManager {
    private static volatile IDataWorkTaskManager instance;
    private static final Log logger;
    protected int availableProcessors = Runtime.getRuntime().availableProcessors();
    protected int maxThreadCnt = this.availableProcessors * 4;
    protected int workThreadPoolMaxSize = this.maxThreadCnt * 16;
    protected ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"IDataTask_Worker_Pa");
    protected ThreadPool helperThreadPool = ThreadPools.newCachedThreadPool((String)"IDataTask_Helper_Pa");
    protected ThreadPool jobMasterPool = ThreadPools.newFixedThreadPool((String)"IDataTask_JobMaster_Pa", (int)1);
    protected AtomicInteger runningThreadCnt = new AtomicInteger(0);
    protected ConcurrentLinkedDeque<IDataFutureWrapper> waitingTaskQueue = new ConcurrentLinkedDeque();
    protected Object waitingTaskCnt = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDataWorkTaskManager getInstance() {
        IDataWorkTaskManager localInstance = instance;
        if (localInstance != null) return localInstance;
        Class<IDataWorkTaskManager> clazz = IDataWorkTaskManager.class;
        synchronized (IDataWorkTaskManager.class) {
            localInstance = instance;
            if (localInstance != null) return localInstance;
            try {
                instance = localInstance = new PAWorkTaskManager();
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u57fa\u4e8eBOS\u7ebf\u7a0b\u6c60\u7684\u5e76\u884c\u4efb\u52a1\u7ba1\u7406\u5668\u5931\u8d25:" + ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
            return localInstance;
        }
    }

    protected IDataWorkTaskManager() {
        this.jobMasterPool.execute(() -> {
            while (true) {
                try {
                    while (!this.waitingTaskQueue.isEmpty() && this.workThreadPoolMaxSize > this.runningThreadCnt.get()) {
                        IDataFutureWrapper taskWrapper = this.waitingTaskQueue.removeFirst();
                        if (taskWrapper.srcWorkTask == null) continue;
                        Future result = this.threadPool.submit((Callable)new RunnableWorkTaskWrapper(taskWrapper.srcWorkTask, curWorkTaskWrapper -> {
                            this.runningThreadCnt.decrementAndGet();
                            Object object = this.waitingTaskCnt;
                            synchronized (object) {
                                this.waitingTaskCnt.notifyAll();
                            }
                        }), taskWrapper.getTenantRequestContext());
                        taskWrapper.setSrcFuture(result);
                        this.runningThreadCnt.incrementAndGet();
                    }
                    Object object = this.waitingTaskCnt;
                    synchronized (object) {
                        this.waitingTaskCnt.wait(5000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
    }

    public void reset(int maxThreadCoefficient, int ThreadPoolMaxSizeCoefficient) {
        this.maxThreadCnt = this.availableProcessors * maxThreadCoefficient;
        this.workThreadPoolMaxSize = this.availableProcessors * ThreadPoolMaxSizeCoefficient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDataFutureWrapper addToWaitingTaskQueue(IDataWorkTask workTask, RequestContext requestContext) {
        if (workTask == null) {
            return null;
        }
        if (requestContext != null) {
            workTask.setRequestContext(requestContext);
        } else if (workTask.getTenantRequestContext() == null) {
            workTask.setRequestContext(RequestContextCreator.createForThreadPool());
        }
        IDataFutureWrapper resultWrapper = new IDataFutureWrapper(workTask);
        this.waitingTaskQueue.addLast(resultWrapper);
        Object object = this.waitingTaskCnt;
        synchronized (object) {
            this.waitingTaskCnt.notifyAll();
        }
        return resultWrapper;
    }

    public void execute(Runnable workTask) {
        this.execute(new RunnableWorkTaskWrapper(workTask, null));
    }

    public void execute(Runnable workTask, RequestContext requestContext) {
        this.execute(new RunnableWorkTaskWrapper(workTask, null), requestContext, false);
    }

    public void execute(IDataWorkTask<?> workTask) {
        this.execute(workTask, workTask.getTenantRequestContext(), false);
    }

    public void execute(IDataWorkTask<?> workTask, boolean asHelperThread) {
        this.execute(workTask, workTask.getTenantRequestContext(), asHelperThread);
    }

    public void execute(IDataWorkTask<?> workTask, RequestContext requestContext, boolean asHelperThread) {
        if (requestContext == null) {
            requestContext = RequestContextCreator.createForThreadPool();
        }
        if (asHelperThread) {
            this.helperThreadPool.execute(workTask, requestContext);
        } else {
            this.addToWaitingTaskQueue(workTask, requestContext);
        }
    }

    public <T> Future<T> submit(Callable<T> workTask, boolean asHelperThread) {
        return this.submit(new RunnableWorkTaskWrapper(workTask, null), RequestContextCreator.createForThreadPool(), asHelperThread);
    }

    public <T> Future<T> submit(Callable<T> workTask, RequestContext requestContext, boolean asHelperThread) {
        if (requestContext == null) {
            requestContext = RequestContextCreator.createForThreadPool();
        }
        if (asHelperThread) {
            return this.helperThreadPool.submit(workTask, requestContext);
        }
        return this.addToWaitingTaskQueue(new RunnableWorkTaskWrapper(workTask, null), requestContext);
    }

    public <T> Future<T> submit(IDataWorkTask<T> workTask) {
        return this.addToWaitingTaskQueue(workTask, null);
    }

    public <T> Future<T> submit(IDataWorkTask<T> workTask, boolean asHelperThread) {
        if (asHelperThread) {
            return this.helperThreadPool.submit(workTask, RequestContextCreator.createForThreadPool());
        }
        return this.addToWaitingTaskQueue(workTask, null);
    }

    public <T> Future<T> submit(IDataWorkTask<T> workTask, RequestContext requestContext) {
        return this.addToWaitingTaskQueue(workTask, requestContext);
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public int getRunningThreadCnt() {
        return this.runningThreadCnt.get();
    }

    public int getMaxThreadCnt() {
        return this.maxThreadCnt;
    }

    static {
        logger = LogFactory.getLog(IDataWorkTaskManager.class);
    }

    protected static class RunnableWorkTaskWrapper
    extends IDataAbstractWorkTask {
        private Callable workTask1;
        private Runnable workTask2;
        private final boolean needReturnValue;
        protected Consumer<RunnableWorkTaskWrapper> taskCompletedConsumer;

        protected RunnableWorkTaskWrapper(Runnable workTask, Consumer<RunnableWorkTaskWrapper> taskCompletedConsumer) {
            super(System.currentTimeMillis());
            this.workTask2 = workTask;
            this.needReturnValue = false;
            this.taskCompletedConsumer = taskCompletedConsumer;
        }

        protected RunnableWorkTaskWrapper(IDataWorkTask workTask, Consumer<RunnableWorkTaskWrapper> taskCompletedConsumer) {
            super(workTask.getTaskKey());
            this.workTask1 = workTask;
            this.needReturnValue = true;
            this.taskCompletedConsumer = taskCompletedConsumer;
            this.requestContext = workTask.getTenantRequestContext();
            if (this.requestContext == null) {
                this.requestContext = RequestContextCreator.createForThreadPool();
            }
        }

        protected RunnableWorkTaskWrapper(Callable workTask, Consumer<RunnableWorkTaskWrapper> taskCompletedConsumer) {
            super(System.currentTimeMillis());
            this.workTask1 = workTask;
            this.needReturnValue = true;
            this.taskCompletedConsumer = taskCompletedConsumer;
            this.requestContext = RequestContextCreator.createForThreadPool();
        }

        protected Object doTaskJob() {
            try {
                if (this.needReturnValue) {
                    Object v = this.workTask1.call();
                    return v;
                }
                this.workTask2.run();
                Object var1_2 = null;
                return var1_2;
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
            finally {
                if (this.taskCompletedConsumer != null) {
                    this.taskCompletedConsumer.accept(this);
                }
            }
        }
    }
}

