/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task.status;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import kd.fi.pa.common.event.IEventObject;
import kd.fi.pa.common.event.IWorkTaskStatusEvent;
import kd.fi.pa.model.impl.IDataBaseModel;

public class IDataSimpleWorkTaskStatisticStatus
extends IDataBaseModel<Serializable, Serializable, Boolean>
implements IWorkTaskStatusEvent,
IEventObject<Serializable> {
    private static final long serialVersionUID = 7521488715438500169L;
    protected int[] taskStatisticsPoints;
    protected long[] totalTaskTimeCost;
    protected long[] taskProcRecStatistics;
    protected String statusMessage;
    protected boolean withError;
    protected boolean taskEnd;
    protected boolean interrupt;
    protected boolean subTaskEnd;
    protected boolean taskStart;

    public IDataSimpleWorkTaskStatisticStatus(Serializable taskId, Serializable versionId, Boolean needMergeStatus, int totalTaskStatisticsPoints) {
        super(taskId, versionId, needMergeStatus);
        this.initTaskStatistics(totalTaskStatisticsPoints);
    }

    public IDataSimpleWorkTaskStatisticStatus(Serializable taskId, Serializable versionId, int totalTaskStatisticsPoints) {
        super(taskId, versionId, Boolean.TRUE);
        this.initTaskStatistics(totalTaskStatisticsPoints);
    }

    public IDataSimpleWorkTaskStatisticStatus(JSONArray jsonArray) {
        super(jsonArray);
    }

    public IDataSimpleWorkTaskStatisticStatus(Object[] v) {
        super(v);
    }

    @Override
    public String toString() {
        return "IDataSimpleWorkTaskStatisticStatus{taskStatisticsPoints=" + Arrays.toString(this.taskStatisticsPoints) + ", totalTaskTimeCost=" + Arrays.toString(this.totalTaskTimeCost) + ", taskProcRecStatistics=" + Arrays.toString(this.taskProcRecStatistics) + ", statusMessage='" + this.statusMessage + '\'' + ", withError=" + this.withError + ", taskEnd=" + this.taskEnd + ", interrupt=" + this.interrupt + ", subTaskEnd=" + this.subTaskEnd + ", taskStart=" + this.taskStart + '}';
    }

    protected final void initTaskStatistics(int totalTaskStatisticsPoints) {
        this.taskStatisticsPoints = new int[2];
        this.taskStatisticsPoints[0] = 0;
        this.taskStatisticsPoints[1] = totalTaskStatisticsPoints;
        this.totalTaskTimeCost = new long[2];
        this.totalTaskTimeCost[0] = System.currentTimeMillis();
        this.totalTaskTimeCost[1] = this.totalTaskTimeCost[0];
        this.taskProcRecStatistics = new long[5];
        this.taskProcRecStatistics[0] = 0L;
        this.taskProcRecStatistics[1] = 0L;
        this.taskProcRecStatistics[2] = 0L;
        this.taskProcRecStatistics[3] = 0L;
        this.taskProcRecStatistics[4] = 0L;
        this.withError = false;
        this.taskEnd = false;
        this.interrupt = false;
        this.subTaskEnd = false;
        this.taskStart = false;
    }

    public IDataSimpleWorkTaskStatisticStatus copy() {
        IDataSimpleWorkTaskStatisticStatus newCopy = new IDataSimpleWorkTaskStatisticStatus((Serializable)this.v1, (Serializable)this.v2, (Boolean)this.v3, this.taskStatisticsPoints[1]);
        newCopy.totalTaskTimeCost[0] = this.totalTaskTimeCost[0];
        return newCopy;
    }

    public int updateTaskStatistics(int fetchDataCnt, int processDataCnt, int skipErrorDataCnt, int errorDataCnt, int totalTaskPoint) {
        this.taskProcRecStatistics[0] = this.taskProcRecStatistics[0] + (long)fetchDataCnt;
        this.taskProcRecStatistics[1] = this.taskProcRecStatistics[1] + (long)processDataCnt;
        this.taskProcRecStatistics[2] = this.taskProcRecStatistics[2] + (long)skipErrorDataCnt;
        this.taskProcRecStatistics[3] = this.taskProcRecStatistics[3] + (long)errorDataCnt;
        this.totalTaskTimeCost[1] = System.currentTimeMillis();
        if (this.taskStatisticsPoints[1] == 0 && totalTaskPoint != 0) {
            this.taskStatisticsPoints[1] = totalTaskPoint;
        }
        this.taskStatisticsPoints[0] = this.taskStatisticsPoints[0] + fetchDataCnt;
        return this.taskStatisticsPoints[0];
    }

    public int updateTaskStatistics(int fetchDataCnt, int processDataCnt, int skipErrorDataCnt, int totalTaskPoint) {
        return this.updateTaskStatistics(fetchDataCnt, processDataCnt, skipErrorDataCnt, 0, totalTaskPoint);
    }

    public void updateTaskTotalTaskPoint(int totalTaskPoint) {
        this.taskStatisticsPoints[1] = totalTaskPoint;
    }

    @Override
    public void errorUpdateStatus(String statusMessage) {
        this.setStatusMessage(statusMessage);
        this.setWithError(true);
        this.taskEnd = true;
    }

    @Override
    public void interruptUpdateStatus(String statusMessage) {
        this.setStatusMessage(statusMessage);
        this.setInterrupt(true);
        this.taskEnd = true;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return super.getArraySize() + 10;
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        int idx = 0;
        targetArray[idx++] = this.getClass().getName();
        targetArray[idx++] = this.v1;
        targetArray[idx++] = this.v2;
        targetArray[idx++] = this.v3;
        targetArray[idx++] = this.taskStatisticsPoints;
        targetArray[idx++] = this.totalTaskTimeCost;
        targetArray[idx++] = this.taskProcRecStatistics;
        targetArray[idx++] = this.statusMessage;
        targetArray[idx++] = this.withError;
        targetArray[idx++] = this.taskEnd;
        targetArray[idx++] = this.interrupt;
        targetArray[idx++] = this.subTaskEnd;
        targetArray[idx] = this.taskStart;
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        int idx = 1;
        this.v1 = this.getString(v, idx++);
        this.v2 = this.getLong(v, idx++);
        this.v3 = this.getBoolean(v, idx++);
        this.taskStatisticsPoints = this.getIntArray(v, idx++);
        this.totalTaskTimeCost = this.getLongArray(v, idx++);
        this.taskProcRecStatistics = this.getLongArray(v, idx++);
        this.statusMessage = this.getString(v, idx++);
        this.withError = this.getBoolean(v, idx++);
        this.taskEnd = this.getBoolean(v, idx++);
        this.interrupt = this.getBoolean(v, idx++);
        this.subTaskEnd = this.getBoolean(v, idx++);
        this.taskStart = this.getBoolean(v, idx);
    }

    @Override
    public void mergeTaskStatus(IWorkTaskStatusEvent targetStatusEvent) {
        if (!(targetStatusEvent instanceof IDataSimpleWorkTaskStatisticStatus)) {
            return;
        }
        IDataSimpleWorkTaskStatisticStatus status = (IDataSimpleWorkTaskStatisticStatus)targetStatusEvent;
        this.taskStatisticsPoints[0] = this.taskStatisticsPoints[0] + status.taskStatisticsPoints[0];
        for (int i = 0; i < this.taskProcRecStatistics.length; ++i) {
            int n = i;
            this.taskProcRecStatistics[n] = this.taskProcRecStatistics[n] + status.taskProcRecStatistics[i];
        }
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public long getTaskExecutionTime() {
        return this.totalTaskTimeCost[1] - this.totalTaskTimeCost[0];
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isTaskEnd() {
        return this.taskEnd;
    }

    @Override
    public void updateTaskEndStatus(boolean endStatus) {
        this.taskEnd = endStatus;
    }

    @Override
    public void updateStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Override
    public Serializable getEventId() {
        return (Serializable)this.v1;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Serializable getTaskId() {
        return (Serializable)this.v1;
    }

    public void setTaskId(Serializable taskKey) {
        this.v1 = taskKey;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Serializable getVersion() {
        return (Serializable)this.v2;
    }

    public void setVersion(Serializable version) {
        this.v2 = version;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean needMergeStatus() {
        return (Boolean)this.v3;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void setNeedMergeStatus(boolean mergeStatus) {
        this.v3 = mergeStatus;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int[] getTaskStatisticsPoints() {
        return this.taskStatisticsPoints;
    }

    public void setTaskStatisticsPoints(int[] taskStatisticsPoints) {
        this.taskStatisticsPoints = taskStatisticsPoints;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public long[] getTotalTaskTimeCost() {
        return this.totalTaskTimeCost;
    }

    public void setTotalTaskTimeCost(long[] totalTaskTimeCost) {
        this.totalTaskTimeCost = totalTaskTimeCost;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public long[] getTaskProcRecStatistics() {
        return this.taskProcRecStatistics;
    }

    public void setTaskProcRecStatistics(long[] taskProcRecStatistics) {
        this.taskProcRecStatistics = taskProcRecStatistics;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isWithError() {
        return this.withError;
    }

    public void setWithError(boolean withError) {
        this.withError = withError;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isInterrupt() {
        return this.interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isSubTaskEnd() {
        return this.subTaskEnd;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isTaskStart() {
        return this.taskStart;
    }

    public void updateSubTaskEndStatus(boolean endStatus) {
        this.subTaskEnd = endStatus;
    }

    public void updateSubTaskStartStatus(boolean taskStart) {
        this.taskStart = taskStart;
    }
}

