/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task.status;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.pa.common.cache.IDataCacheModule;
import kd.fi.pa.common.event.IWorkTaskStatusEvent;
import kd.fi.pa.engine.task.status.AbstractIDataWorkTaskStatusConsumer;

public class PAWorkTaskStatusConsumer
extends AbstractIDataWorkTaskStatusConsumer {
    private static final Map<String, PAWorkTaskStatusConsumer> instanceMap = new ConcurrentHashMap<String, PAWorkTaskStatusConsumer>();
    private static PAWorkTaskStatusConsumer instance;
    private static String centerId;

    @Override
    protected IDataCacheModule getCacheModel() {
        return IDataCacheModule.PA;
    }

    public static PAWorkTaskStatusConsumer getInstance() {
        centerId = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()).getAccountId();
        PAWorkTaskStatusConsumer consumer = instanceMap.get(centerId);
        if (consumer == null) {
            consumer = new PAWorkTaskStatusConsumer();
            instanceMap.put(centerId, consumer);
            instance = consumer;
        }
        if (consumer.processPipe == null) {
            throw new KDBizException("PAWorkTaskStatusConsumer PipeStream is null");
        }
        return consumer;
    }

    public void updateCachedWorkTaskStatusEvent(Object taskId, String message) {
        IWorkTaskStatusEvent statusEvent = this.getCachedWorkTaskStatusEvent(taskId);
        if (statusEvent != null) {
            statusEvent.setNeedMergeStatus(false);
            statusEvent.updateStatusMessage(message);
            try {
                instance.updateTaskStatus(statusEvent);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    static {
        centerId = null;
    }
}

