/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enums;

import kd.bos.exception.KDBizException;
import kd.fi.pa.common.enums.IByteCodeEnum;

public enum DataStatusEnum implements IByteCodeEnum<DataStatusEnum>
{
    SOURCE(0),
    ALLOCATE(1),
    DERIVE(2),
    ADJUST(3),
    WRITE_OFF(4),
    OFF_ALLOCATE(-1),
    OFF_DERIVE(-2),
    OFF_ADJUST(-3);

    private final byte code;

    private DataStatusEnum(byte code) {
        this.code = code;
    }

    public long getLongCode() {
        return this.getCode();
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public DataStatusEnum parse(Byte code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case 0: {
                return SOURCE;
            }
            case 1: {
                return ALLOCATE;
            }
            case 2: {
                return DERIVE;
            }
            case 3: {
                return ADJUST;
            }
            case 4: {
                return WRITE_OFF;
            }
            case -1: {
                return OFF_ALLOCATE;
            }
            case -2: {
                return OFF_DERIVE;
            }
            case -3: {
                return OFF_ADJUST;
            }
        }
        return null;
    }

    public static DataStatusEnum getEnumByCode(byte code) {
        for (DataStatusEnum enums : DataStatusEnum.values()) {
            if (enums.getCode() != code) continue;
            return enums;
        }
        throw new KDBizException("not exit DataStatusEnum by " + code);
    }
}

