/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.handle.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.enums.PASituationTypeEnum;
import kd.fi.pa.helper.AccountHelper;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PATableDataHelper;
import kd.fi.pa.model.BdPeriod;
import kd.fi.pa.model.impl.PAAnalysisModelModel;
import kd.fi.pa.model.impl.PADimensionModel;
import kd.fi.pa.model.impl.PAMeasureModel;
import kd.fi.pa.utils.AnalysisModelHashUtil;
import kd.fi.pa.utils.NumberUtils;

public class ShareDataCalculateMeasureHandler {
    private static final Log logger = LogFactory.getLog(ShareDataCalculateMeasureHandler.class);

    public Long calculate(Collection<DynamicObject> summaryDatas, PAAnalysisModelModel analysisModelModel) {
        logger.info("[FI-PA]Business Calculate execute start!");
        if (summaryDatas == null || summaryDatas.isEmpty() || analysisModelModel == null) {
            return null;
        }
        if (!"bd_period".equals(analysisModelModel.getPeriodSourceNumber())) {
            return null;
        }
        DynamicObject currentPeriod = this.parseCurrentPeriod(summaryDatas, analysisModelModel.getPeriodDimNumber());
        List<PAMeasureModel> calMeasureList = analysisModelModel.getCalMeasure();
        if (calMeasureList == null || calMeasureList.isEmpty()) {
            return null;
        }
        Set<Long> accountPltype0Set = this.initAccountPltype0Set(analysisModelModel, calMeasureList);
        long count = 0L;
        for (PAMeasureModel calMeasure : calMeasureList) {
            count += this.doCalculate(summaryDatas, analysisModelModel, calMeasure, currentPeriod, accountPltype0Set).longValue();
        }
        logger.info("[FI-PA]Business Calculate execute end!");
        return count;
    }

    private Set<Long> initAccountPltype0Set(PAAnalysisModelModel analysisModelModel, List<PAMeasureModel> calMeasureList) {
        Long accountTableId = analysisModelModel.getAccountTableId();
        for (PAMeasureModel calMeasure : calMeasureList) {
            String periodAggAttr = BdPeriod.parsePeriodAggAttr(calMeasure.getDimensionattr());
            if (!"periodnone".equals(periodAggAttr)) continue;
            return AccountHelper.queryAccountPltype0Set(accountTableId);
        }
        return Collections.emptySet();
    }

    private Long doCalculate(Collection<DynamicObject> summaryDatas, PAAnalysisModelModel analysisModelModel, PAMeasureModel calMeasure, DynamicObject currentPeriod, Set<Long> accountPltype0Set) {
        List<PADimensionModel> dimList = analysisModelModel.getAllDim();
        QFilter[] filters = this.genQFilter(summaryDatas, dimList, calMeasure, currentPeriod);
        Map<String, List<DynamicObject>> classfyMap = this.completionSummary(summaryDatas, analysisModelModel, calMeasure, filters);
        return this.calculateMeasure(classfyMap, calMeasure, summaryDatas, currentPeriod, analysisModelModel, accountPltype0Set);
    }

    private Long calculateMeasure(Map<String, List<DynamicObject>> classfyMap, PAMeasureModel calMeasure, Collection<DynamicObject> summaryDatas, DynamicObject currentPeriod, PAAnalysisModelModel analysisModelModel, Set<Long> accountPltype0Set) {
        if (classfyMap == null || classfyMap.isEmpty()) {
            return 0L;
        }
        Long currentPeriodId = currentPeriod.getLong("id");
        PADimensionModel refDim = calMeasure.getDimension();
        String calMeasureField = calMeasure.getNumber();
        String refMeasureField = calMeasure.getMeasure().getNumber();
        String refDimField = refDim.getNumber();
        String periodAggAttr = BdPeriod.parsePeriodAggAttr(calMeasure.getDimensionattr());
        Comparator sortor = (o1, o2) -> {
            Long id1 = (Long)this.getFieldValue((DynamicObject)o1, refDimField);
            Long id2 = (Long)this.getFieldValue((DynamicObject)o2, refDimField);
            return id1.compareTo(id2);
        };
        HashSet<Long> idSet = new HashSet<Long>(summaryDatas.size());
        for (DynamicObject dynamicObject : summaryDatas) {
            idSet.add(dynamicObject.getLong("id"));
        }
        Set<Map.Entry<String, List<DynamicObject>>> classEntrySet = classfyMap.entrySet();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(classfyMap.size());
        for (Map.Entry<String, List<DynamicObject>> classEntry : classEntrySet) {
            List<DynamicObject> dataList = classEntry.getValue();
            dataList.sort(sortor);
            BigDecimal previousPeriodCalMeasureValue = null;
            for (DynamicObject seqObj : dataList) {
                Object refDimId = this.getFieldValue(seqObj, refDimField);
                if (currentPeriodId.equals(refDimId)) {
                    Long id;
                    if ("periodnone".equals(periodAggAttr) && !accountPltype0Set.contains(seqObj.getLong(analysisModelModel.getAccountDimNumber() + "_id"))) {
                        seqObj.set(calMeasureField, (Object)BigDecimal.ZERO);
                    } else {
                        BigDecimal refMeasure = seqObj.getBigDecimal(refMeasureField);
                        seqObj.set(calMeasureField, (Object)NumberUtils.sum(previousPeriodCalMeasureValue, refMeasure));
                    }
                    if (idSet.contains(id = Long.valueOf(seqObj.getLong("id")))) continue;
                    updateList.add(seqObj);
                    continue;
                }
                previousPeriodCalMeasureValue = seqObj.getBigDecimal(calMeasureField);
            }
        }
        PATableDataHelper.update(summaryDatas);
        PATableDataHelper.update(updateList);
        return summaryDatas.size() + updateList.size();
    }

    private Map<String, List<DynamicObject>> completionSummary(Collection<DynamicObject> summaryDatas, PAAnalysisModelModel analysisModelModel, PAMeasureModel calMeasure, QFilter[] filters) {
        List<PADimensionModel> allDimList = analysisModelModel.getAllDim();
        List<String> modelHashDimensionNumberList = AnalysisModelHashUtil.queryModelHashDimension(analysisModelModel.getSourceDynamicObject());
        boolean modelContainsDimHash = AnalysisModelHashUtil.isModelContainsDimHash(analysisModelModel.getModelEntity());
        List<PADimensionModel> classfyDimList = allDimList.stream().filter(dimModel -> !dimModel.equals(calMeasure.getDimension())).collect(Collectors.toList());
        classfyDimList.remove(calMeasure.getDimension());
        String selectFields = PATableDataHelper.selectField(analysisModelModel, true);
        HashSet<String> keySet = new HashSet<String>(summaryDatas.size());
        HashMap<String, List<DynamicObject>> classfyMap = new HashMap<String, List<DynamicObject>>(10);
        for (DynamicObject obj : summaryDatas) {
            String rowKey = this.buildRowKey(obj, allDimList);
            keySet.add(rowKey);
            String classfyKey = this.buildRowKey(obj, classfyDimList);
            classfyMap.computeIfAbsent(classfyKey, k -> new ArrayList(10)).add(obj);
        }
        List<PAMeasureModel> allMeasureList = analysisModelModel.getAllMeasure();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"completionSummary", (String)analysisModelModel.getModelEntity(), (String)selectFields, (QFilter[])filters, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String classfyKey;
                    List list;
                    String rowKey = this.buildRowKey(row, allDimList);
                    if (keySet.contains(rowKey) || (list = (List)classfyMap.get(classfyKey = this.buildRowKey(row, classfyDimList))) == null) continue;
                    DynamicObject summaryData = BusinessDataServiceHelper.newDynamicObject((String)analysisModelModel.getModelEntity());
                    for (PADimensionModel dimension : allDimList) {
                        summaryData.set(dimension.getNumber(), row.get(dimension.getNumber()));
                    }
                    summaryData.set("id", row.get("id"));
                    for (PAMeasureModel measure : allMeasureList) {
                        String measureField = measure.getNumber();
                        summaryData.set(measureField, (Object)row.getBigDecimal(measureField));
                    }
                    if (modelContainsDimHash) {
                        summaryData.set("dimhash", (Object)AnalysisModelHashUtil.calculateDimHash(summaryData, modelHashDimensionNumberList));
                    }
                    list.add(summaryData);
                }
            }
        }
        return classfyMap;
    }

    private QFilter[] genQFilter(Collection<DynamicObject> summaryDatas, List<PADimensionModel> dimList, PAMeasureModel calMeasure, DynamicObject currentPeriod) {
        HashMap<String, Set> filterValueMap = new HashMap<String, Set>(dimList.size());
        PADimensionModel refDim = calMeasure.getDimension();
        String refField = refDim.getNumber();
        for (DynamicObject summaryData : summaryDatas) {
            for (PADimensionModel pADimensionModel : dimList) {
                String field = pADimensionModel.getNumber();
                Object value = summaryData.get(field);
                if (refField.equals(field)) continue;
                if (value == null || "".equals(value)) {
                    switch (pADimensionModel.getDbType()) {
                        case String: {
                            value = " ";
                            break;
                        }
                        case Int: {
                            value = 0L;
                            break;
                        }
                        case Date: {
                            value = null;
                        }
                    }
                }
                value = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
                Set objsSet = filterValueMap.computeIfAbsent(field, key -> new HashSet(10));
                objsSet.add(value);
            }
        }
        QFilter[] filters = new QFilter[dimList.size() + 2];
        int count = 0;
        for (Map.Entry entry : filterValueMap.entrySet()) {
            Set valueSet = (Set)entry.getValue();
            if (valueSet.contains(null)) {
                QFilter nullFilter = new QFilter((String)entry.getKey(), "is null", null);
                valueSet.remove(null);
                if (!valueSet.isEmpty()) {
                    filters[count++] = nullFilter.or(new QFilter((String)entry.getKey(), "in", (Object)valueSet));
                    continue;
                }
                filters[count++] = nullFilter;
                continue;
            }
            filters[count++] = new QFilter((String)entry.getKey(), "in", (Object)valueSet);
        }
        ArrayList<Long> periodIdList = new ArrayList<Long>(2);
        periodIdList.add(currentPeriod.getLong("id"));
        String string = BdPeriod.parsePeriodAggAttr(calMeasure.getDimensionattr());
        DynamicObject previousPeriod = new BdPeriod(currentPeriod).queryPreviousPeriod(string);
        if (previousPeriod != null) {
            periodIdList.add(previousPeriod.getLong("id"));
        }
        filters[count++] = new QFilter(refField, "in", periodIdList);
        filters[count++] = new QFilter("collectstatus", "=", (Object)PACollectStatusEnum.COLLECT.getCode());
        filters[count++] = new QFilter("situationtype", "=", (Object)PASituationTypeEnum.ACTUAL.getCode());
        return filters;
    }

    private DynamicObject parseCurrentPeriod(Collection<DynamicObject> summaryDatas, String periodDimNumber) {
        if (summaryDatas == null || summaryDatas.isEmpty()) {
            throw new KDBizException("summaryDatas is null or empty");
        }
        Long currentPeriodId = null;
        for (DynamicObject summaryData : summaryDatas) {
            Long refId = null;
            try {
                refId = (Long)this.getFieldValue(summaryData, periodDimNumber);
            }
            catch (Exception e) {
                throw new KDBizException(new ErrorCode("", ""), new Object[]{"get summaryData field[" + periodDimNumber + "] value error", e});
            }
            if (refId == null) {
                throw new KDBizException("summaryData field[" + periodDimNumber + "] value is null");
            }
            if (currentPeriodId == null) {
                currentPeriodId = refId;
                continue;
            }
            if (Objects.equals(currentPeriodId, refId)) continue;
            throw new KDBizException("summaryData field[" + periodDimNumber + "] has more than one value[" + currentPeriodId + "," + refId + "]");
        }
        return BusinessDataServiceHelper.loadSingleFromCache(currentPeriodId, (String)"bd_period");
    }

    private String buildRowKey(DynamicObject data, List<PADimensionModel> keyFields) {
        StringBuilder sb = new StringBuilder();
        for (PADimensionModel dim : keyFields) {
            String valueStr;
            String field = dim.getNumber();
            Object value = this.getFieldValue(data, field);
            if (value == null || "0".equals(valueStr = String.valueOf(value)) || StringUtils.isEmpty((String)valueStr)) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    private String buildRowKey(Row row, List<PADimensionModel> keyFields) {
        StringBuilder sb = new StringBuilder();
        for (PADimensionModel dim : keyFields) {
            String valueStr;
            Object value = row.get(dim.getNumber());
            if (value == null || "0".equals(valueStr = String.valueOf(value)) || StringUtils.isEmpty((String)valueStr)) continue;
            sb.append(valueStr);
        }
        return sb.toString();
    }

    private Object getFieldValue(DynamicObject data, String field) {
        IDataEntityProperty property;
        Object value = data.get(field);
        Object object = value = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
        if (value instanceof Integer && (property = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)field)) instanceof BasedataProp) {
            value = Long.valueOf(String.valueOf(value));
        }
        return value;
    }

    private PAAnalysisModelModel getAnalysisModelConfig(Long analysisModelId) {
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModel(analysisModelId);
        PAAnalysisModelModel analysisModelModel = new PAAnalysisModelModel();
        analysisModelModel.loadFromDynamicObject(analysisModel, true);
        return analysisModelModel;
    }
}

