/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.handle.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.enums.PASituationTypeEnum;
import kd.fi.pa.handle.IDataSummaryHandler;
import kd.fi.pa.handle.impl.ShareDataCalculateMeasureHandler;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PATableDataHelper;
import kd.fi.pa.model.impl.PAAnalysisModelModel;
import kd.fi.pa.model.impl.PADimensionModel;
import kd.fi.pa.model.impl.PAMeasureModel;
import kd.fi.pa.utils.AnalysisModelHashUtil;

public class ShareDataSummaryHandler
implements IDataSummaryHandler {
    private static final Log logger = LogFactory.getLog(ShareDataSummaryHandler.class);

    @Override
    public Long summary(Collection<DynamicObject> detailList, Long analysisModelId) {
        logger.info("[FI-PA]Business Summary execute start!");
        if (detailList == null || detailList.isEmpty() || analysisModelId == null) {
            return 0L;
        }
        PAAnalysisModelModel analysisModelModel = this.getAnalysisModelConfig(analysisModelId);
        List<PADimensionModel> keyFields = analysisModelModel.getAllDim();
        HashMap<String, List<DynamicObject>> detailDataMap = new HashMap<String, List<DynamicObject>>(10);
        for (DynamicObject detailDy : detailList) {
            String key = this.buildRowKey(detailDy, keyFields);
            detailDataMap.computeIfAbsent(key, value -> new ArrayList(2)).add(detailDy);
        }
        Map<String, DynamicObject> summaryDataMap = this.querySummaryData(detailDataMap, keyFields, analysisModelModel);
        ArrayList<DynamicObject> insertSummaryList = new ArrayList<DynamicObject>(detailDataMap.size());
        ArrayList<DynamicObject> updateSummaryList = new ArrayList<DynamicObject>(detailDataMap.size());
        ArrayList<DynamicObject> updateDetailList = new ArrayList<DynamicObject>(detailDataMap.size());
        this.processSummaryData(insertSummaryList, updateSummaryList, updateDetailList, summaryDataMap, detailDataMap, analysisModelModel);
        PATableDataHelper.insert(insertSummaryList);
        PATableDataHelper.update(updateSummaryList);
        PATableDataHelper.update(updateDetailList);
        int summaryCount = insertSummaryList.size() + updateSummaryList.size();
        logger.info("[FI-PA]Business Summary execute end!");
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(insertSummaryList.size() + updateSummaryList.size());
        summaryList.addAll(insertSummaryList);
        summaryList.addAll(updateSummaryList);
        ShareDataCalculateMeasureHandler handle = new ShareDataCalculateMeasureHandler();
        handle.calculate(summaryList, analysisModelModel);
        return summaryCount;
    }

    private Map<String, DynamicObject> querySummaryData(Map<String, List<DynamicObject>> detailDataMap, List<PADimensionModel> keyFields, PAAnalysisModelModel analysisModelModel) {
        HashMap<String, Set> filterValueMap = new HashMap<String, Set>(keyFields.size());
        for (Map.Entry<String, List<DynamicObject>> entry : detailDataMap.entrySet()) {
            List<DynamicObject> list = entry.getValue();
            DynamicObject detailTemplateDy = list.get(0);
            for (PADimensionModel dimensionModel : keyFields) {
                String number = dimensionModel.getNumber();
                Object value = detailTemplateDy.get(number);
                if (value == null || "".equals(value)) {
                    switch (dimensionModel.getDbType()) {
                        case String: {
                            value = " ";
                            break;
                        }
                        case Int: {
                            value = 0L;
                            break;
                        }
                        case Date: {
                            value = null;
                            break;
                        }
                    }
                }
                value = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
                filterValueMap.computeIfAbsent(number, key -> new HashSet(10)).add(value);
            }
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(keyFields.size());
        for (Map.Entry entry : filterValueMap.entrySet()) {
            QFilter valueFilter;
            Set valueSet = (Set)entry.getValue();
            if (valueSet.contains(null)) {
                valueFilter = new QFilter((String)entry.getKey(), "is null", null);
                valueSet.remove(null);
                if (!valueSet.isEmpty()) {
                    valueFilter = valueFilter.or((String)entry.getKey(), "in", (Object)valueSet);
                }
            } else {
                valueFilter = new QFilter((String)entry.getKey(), "in", (Object)valueSet);
            }
            qFilterList.add(valueFilter);
        }
        qFilterList.add(new QFilter("collectstatus", "=", (Object)PACollectStatusEnum.COLLECT.getCode()));
        qFilterList.add(new QFilter("situationtype", "=", (Object)PASituationTypeEnum.ACTUAL.getCode()));
        HashMap<String, DynamicObject> hashMap = new HashMap<String, DynamicObject>(detailDataMap.size());
        String string = analysisModelModel.getModelEntity();
        String selectField = PATableDataHelper.selectField(analysisModelModel, false);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"querySummaryDatatwo", (String)string, (String)selectField, (QFilter[])qFilterList.toArray(new QFilter[0]), null);){
            List<PADimensionModel> dimList = analysisModelModel.getAllDim();
            List<PAMeasureModel> ordMeasureList = analysisModelModel.getOrdinaryMeasure();
            for (Row row : dataSet) {
                String key2 = this.buildRowKey(row, dimList);
                if (!detailDataMap.containsKey(key2)) continue;
                DynamicObject modelData = BusinessDataServiceHelper.newDynamicObject((String)analysisModelModel.getModelEntity());
                modelData.set("id", row.get("id"));
                for (PAMeasureModel measure : ordMeasureList) {
                    modelData.set(measure.getNumber(), row.get(measure.getNumber()));
                }
                for (PADimensionModel dimension : dimList) {
                    modelData.set(dimension.getNumber(), row.get(dimension.getNumber()));
                }
                hashMap.put(key2, modelData);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private void processSummaryData(List<DynamicObject> insertSummaryList, List<DynamicObject> updateSummaryList, List<DynamicObject> updateDetailList, Map<String, DynamicObject> summaryDataMap, Map<String, List<DynamicObject>> detailDataMap, PAAnalysisModelModel analysisModelModel) {
        String entityNumber = analysisModelModel.getModelEntity();
        List<PADimensionModel> dimList = analysisModelModel.getAllDim();
        List<String> modelHashDimensionNumberList = AnalysisModelHashUtil.queryModelHashDimension(analysisModelModel.getSourceDynamicObject());
        boolean modelContainsDimHash = AnalysisModelHashUtil.isModelContainsDimHash(entityNumber);
        List<PAMeasureModel> measureList = analysisModelModel.getOrdinaryMeasure();
        int index = 0;
        long[] ids = DB.genLongIds((String)entityNumber, (int)detailDataMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : detailDataMap.entrySet()) {
            void var24_27;
            String key = entry.getKey();
            List<DynamicObject> detailList = entry.getValue();
            boolean isNew = false;
            DynamicObject summaryDy = summaryDataMap.get(key);
            if (summaryDy == null) {
                isNew = true;
                summaryDy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
                summaryDy.set("id", (Object)ids[index++]);
            }
            BigDecimal[] sumAmount = new BigDecimal[measureList.size()];
            Long summaryId = summaryDy.getLong("id");
            String defaultValue = " ";
            for (DynamicObject dynamicObject : detailList) {
                int i = 0;
                for (PAMeasureModel measure : measureList) {
                    BigDecimal amount = dynamicObject.getBigDecimal(measure.getNumber());
                    sumAmount[i] = sumAmount[i] == null ? amount : sumAmount[i].add(amount);
                    ++i;
                }
                dynamicObject.set("operationstatus", (Object)OperationStatusEnum.USED.getIntCode());
                dynamicObject.set("summaryid", (Object)summaryId);
                dynamicObject.set("sourceformid", (Object)defaultValue);
                updateDetailList.add(dynamicObject);
            }
            DynamicObject templateDy = detailList.get(0);
            summaryDy.set("collectstatus", (Object)PACollectStatusEnum.COLLECT.getCode());
            summaryDy.set("situationtype", (Object)PASituationTypeEnum.ACTUAL.getCode());
            for (PADimensionModel dimension : dimList) {
                summaryDy.set(dimension.getNumber(), templateDy.get(dimension.getNumber()));
            }
            boolean bl = false;
            while (var24_27 < measureList.size()) {
                String measureField = measureList.get((int)var24_27).getNumber();
                BigDecimal oldData = isNew ? BigDecimal.ZERO : (summaryDy.getBigDecimal(measureField) == null ? BigDecimal.ZERO : summaryDy.getBigDecimal(measureField));
                BigDecimal newData = oldData.add(sumAmount[var24_27]);
                summaryDy.set(measureField, (Object)newData);
                ++var24_27;
            }
            if (isNew) {
                Date date = new Date();
                summaryDy.set("createtime", (Object)date);
                if (modelContainsDimHash) {
                    summaryDy.set("dimhash", (Object)AnalysisModelHashUtil.calculateDimHash(summaryDy, modelHashDimensionNumberList));
                }
                insertSummaryList.add(summaryDy);
                continue;
            }
            updateSummaryList.add(summaryDy);
        }
    }

    private String buildRowKey(DynamicObject data, List<PADimensionModel> keyFields) {
        StringBuilder sb = new StringBuilder();
        for (PADimensionModel dim : keyFields) {
            String field;
            Object value;
            String valueStr = dim.valueToString(value = data.get(field = dim.getNumber()));
            if (StringUtils.isEmpty((String)valueStr)) continue;
            sb.append(valueStr).append('|');
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String buildRowKey(Row row, List<PADimensionModel> keyFields) {
        StringBuilder sb = new StringBuilder();
        for (PADimensionModel dim : keyFields) {
            Object value;
            String valueStr = dim.valueToString(value = row.get(dim.getNumber()));
            if (StringUtils.isEmpty((String)valueStr)) continue;
            sb.append(valueStr).append('|');
        }
        return sb.substring(0, sb.length() - 1);
    }

    private PAAnalysisModelModel getAnalysisModelConfig(Long analysisModelId) {
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModel(analysisModelId);
        PAAnalysisModelModel analysisModelModel = new PAAnalysisModelModel();
        analysisModelModel.loadFromDynamicObject(analysisModel, true);
        return analysisModelModel;
    }
}

