/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountHelper {
    private static final Log logger = LogFactory.getLog(AccountHelper.class);

    private AccountHelper() {
    }

    public static Set<Long> getAllParentIds(Set<Long> accountIdSet) {
        QFilter idFilter = new QFilter("id", "in", accountIdSet);
        QFilter parentFilter = new QFilter("parent", "is not null", null).and("parent", "!=", (Object)0L);
        Map accountDyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"parent.id", (QFilter[])new QFilter[]{idFilter, parentFilter});
        Set<Long> parentIdSet = accountDyMap.values().stream().map(dy -> dy.getLong("parent.id")).collect(Collectors.toSet());
        if (!parentIdSet.isEmpty()) {
            parentIdSet.addAll(AccountHelper.getAllParentIds(parentIdSet));
        }
        return parentIdSet;
    }

    public static Set<Long> getAllChildIds(Set<Long> accountIdSet) {
        QFilter parentFilter = new QFilter("parent", "in", accountIdSet);
        Map accountDyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{parentFilter});
        Set<Long> childIdSet = accountDyMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        if (!childIdSet.isEmpty()) {
            childIdSet.addAll(AccountHelper.getAllChildIds(childIdSet));
        }
        return childIdSet;
    }

    public static Set<Long> queryAccountPltype0Set(Long accountTableId) {
        HashSet<Long> set = new HashSet<Long>(512);
        QFilter qFilter = new QFilter("pltype", "=", (Object)"0");
        if (accountTableId != null) {
            qFilter = qFilter.and("accounttable", "=", (Object)accountTableId);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"pa-queryAccountPltype0Set", (String)"bd_accountview", (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                set.add(row.getLong("id"));
            }
        }
        return set;
    }
}

