/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.Set;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;

public class DLockHelper {
    public static String getMLockKey(String entityNumber) {
        return String.format("fi/pa/%s", entityNumber);
    }

    public static String getMOPLockKey(Long modelId, Long orgId, Long periodId) {
        return String.format("fi/pa/%s_%s_%s", modelId, orgId, periodId);
    }

    public static String getMOPLockKeyPrefix(Long modelId) {
        return String.format("fi/pa/%s", modelId);
    }

    public static boolean existsMLock(String entityNumber) {
        Set allLockKeySet = DLock.getAllLockInfo().keySet();
        String modelLockKey = DLockHelper.getMLockKey(entityNumber);
        for (String lockKey : allLockKeySet) {
            if (!lockKey.equals(modelLockKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsMOPLock(Long modelId) {
        Set allLockKeySet = DLock.getAllLockInfo().keySet();
        String prefixKey = String.format("fi/pa/%s", modelId);
        for (String lockKey : allLockKeySet) {
            if (!lockKey.startsWith(prefixKey)) continue;
            return true;
        }
        return false;
    }

    public static String getDLockInfoMsg(String key) {
        DLockInfo lockInfo = DLock.getLockInfo((String)key);
        if (lockInfo != null) {
            return String.format("DLockInfo key:%s, desc:%s", lockInfo.getKey(), lockInfo.getDesc());
        }
        return null;
    }
}

