/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.enums.DataValueTypeEnum;
import kd.fi.pa.utils.IDataValueUtil;

public class EntityMetaHelper {
    private static final Log logger = LogFactory.getLog(EntityMetaHelper.class);
    private static final String ENDSWITH_LK = "_lk";
    private static final String ENDSWITH_ID = "_id";

    @Deprecated
    public static List<Map<String, String>> parseEntryeEtityFields(IDataEntityType sourceDataType, String fullEntryPrefixNum, String fullEntryPrefixName) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (sourceDataType == null) {
            return resultList;
        }
        if (StringUtils.isBlank((CharSequence)sourceDataType.getAlias())) {
            return resultList;
        }
        StringBuilder endsWithLogs = new StringBuilder();
        StringBuilder displayNameLogs = new StringBuilder();
        StringBuilder aliasNameLogs = new StringBuilder();
        for (IDataEntityProperty prop : sourceDataType.getProperties()) {
            IBasedataField refBaseProp;
            List<Map<String, String>> childObjectFields;
            String fieldNumber = prop.getName() == null ? "" : prop.getName();
            fieldNumber = EntityMetaHelper.addPre(fullEntryPrefixNum, fieldNumber);
            LocaleString displayName = prop.getDisplayName();
            String fieldName = displayName == null ? "" : displayName.toString();
            fieldName = EntityMetaHelper.addPre(fullEntryPrefixName, fieldName);
            if (ENDSWITH_LK.endsWith(fieldNumber) || ENDSWITH_ID.endsWith(fieldNumber)) {
                endsWithLogs.append(" ");
                endsWithLogs.append(fieldNumber);
                continue;
            }
            if (displayName == null) {
                displayNameLogs.append(" ");
                displayNameLogs.append(fieldNumber);
                continue;
            }
            if (prop instanceof EntryProp) {
                resultList.addAll(EntityMetaHelper.parseEntryeEtityFields(((EntryProp)prop).getItemType(), fieldNumber, fieldName));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)prop.getAlias())) {
                aliasNameLogs.append(" ");
                aliasNameLogs.append(fieldNumber);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>(16);
            DataValueTypeEnum propertyDataType = IDataValueUtil.getDataType(prop);
            map.put("showname", fieldName);
            map.put("shownumber", fieldNumber);
            map.put("showdatatype", String.valueOf(propertyDataType.getCode()));
            if (DataValueTypeEnum.BaseProp == propertyDataType && !(childObjectFields = EntityMetaHelper.parseEntryeEtityFields((refBaseProp = (IBasedataField)prop).getComplexType(), fieldNumber, fieldName)).isEmpty()) {
                resultList.addAll(childObjectFields);
                childObjectFields.clear();
            }
            resultList.add(map);
        }
        if (endsWithLogs.length() > 0) {
            logger.info(endsWithLogs.insert(0, "\u5ffd\u7565\u663e\u793a _lk\u6216_id\u7ed3\u5c3e\u7684\u5c5e\u6027\u5b57\u6bb5").toString());
        }
        if (displayNameLogs.length() > 0) {
            logger.info(displayNameLogs.insert(0, "\u5ffd\u7565\u663e\u793a\u540d\u79f0\u4e3a\u7a7a\u7684\u5b57\u6bb5").toString());
        }
        if (aliasNameLogs.length() > 0) {
            logger.info(aliasNameLogs.insert(0, "\u5ffd\u7565\u6570\u636e\u5e93\u6ca1\u6709\u7684\u5b57\u6bb5").toString());
        }
        return resultList;
    }

    private static String addPre(String pre, String field) {
        if (pre != null && pre.length() > 0) {
            field = pre + "." + field;
        }
        return field;
    }

    public static Optional<String> getBaseEntityId(String entityName, String fieldName) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return Optional.empty();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        return dataEntityType.getProperties().stream().filter(property -> property.getName().equals(fieldName) && property instanceof BasedataProp).findFirst().map(property -> ((BasedataProp)property).getBaseEntityId());
    }
}

