/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgHelper {
    private OrgHelper() {
    }

    public static PermOrgResult getPermOrgSet(String entityNumber) {
        String appId = AppMetadataCache.getAppInfo((String)"pa").getAppId();
        return OrgHelper.getPermOrgSet(entityNumber, appId);
    }

    public static PermOrgResult getPermOrgSet(String entityNumber, String appId) {
        String permItemId;
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return new PermOrgResult(true);
        }
        if (StringUtils.isEmpty((CharSequence)appId)) {
            appId = AppMetadataCache.getAppInfo((String)"pa").getAppId();
        }
        switch (entityNumber) {
            case "pa_businessexecute": {
                permItemId = "2CI3WE0KMBD3";
                break;
            }
            case "pa_dataextracting": {
                permItemId = "2CI3NUT68N64";
                break;
            }
            case "pa_reversalexecute": {
                permItemId = "2CI4F0+REUWU";
                break;
            }
            case "pa_businessrule": 
            case "pa_businessplan": {
                permItemId = "2CI4T/D4LCAW";
                break;
            }
            case "pa_dataadjust": {
                permItemId = "2CI46LC4VXM=";
                break;
            }
            default: {
                permItemId = "47150e89000000ac";
            }
        }
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)appId, (String)entityNumber, (String)permItemId);
        if (permOrgResult.hasAllOrgPerm()) {
            return new PermOrgResult(true);
        }
        return new PermOrgResult(false, permOrgResult.getHasPermOrgs());
    }

    public static class PermOrgResult {
        private boolean allOrgPerm;
        private Set<Long> permOrgs = new HashSet<Long>(1);

        public PermOrgResult(boolean allOrgPerm) {
            this.allOrgPerm = allOrgPerm;
        }

        public PermOrgResult(boolean allOrgPerm, List<Long> permOrgList) {
            this.allOrgPerm = allOrgPerm;
            if (permOrgList != null) {
                this.permOrgs.addAll(permOrgList);
            }
        }

        public boolean hasAllOrgPerm() {
            return this.allOrgPerm;
        }

        public Set<Long> getPermOrgs() {
            return this.permOrgs;
        }
    }
}

