/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.MeasureTypeEnum;
import kd.fi.pa.enums.ModelVersionEnum;

public class PAAnalysisModelHelper {
    private static final String ALGO_KEY = PAAnalysisModelHelper.class.getName();

    public static Map<String, DynamicObject[]> queryDimensionAndMeasureById(Object id) {
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_analysismodel"));
        DynamicObjectCollection dimensionCOls = analysisModel.getDynamicObjectCollection("dimension_entry");
        DynamicObject[] dimList = new DynamicObject[dimensionCOls.size()];
        int i = 0;
        for (DynamicObject entry : dimensionCOls) {
            dimList[i] = entry.getDynamicObject("dimension");
            ++i;
        }
        DynamicObjectCollection measureCols = analysisModel.getDynamicObjectCollection("measure_entry");
        DynamicObject[] measureList = new DynamicObject[measureCols.size()];
        i = 0;
        for (DynamicObject entry : measureCols) {
            measureList[i] = entry.getDynamicObject("measure");
            ++i;
        }
        HashMap<String, DynamicObject[]> map = new HashMap<String, DynamicObject[]>(2);
        map.put("dimensionmapentry", dimList);
        map.put("measuremapentry", measureList);
        return map;
    }

    public static DynamicObject loadAnalysisModel(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_analysismodel");
    }

    public static DynamicObject loadAnalysisModelFromCache(Object id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pa_analysismodel");
    }

    public static DynamicObjectCollection queryModelDimensions(Long modelId) {
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModelFromCache(modelId);
        return PAAnalysisModelHelper.queryModelDimensions(analysisModel);
    }

    public static DynamicObjectCollection queryModelDimensions(DynamicObject analysisModel) {
        if (analysisModel == null) {
            throw new KDBizException("analysisModel is null");
        }
        return analysisModel.getDynamicObjectCollection("dimension_entry");
    }

    public static Map<String, DynamicObject> queryModelNecessityDims(DynamicObject analysisModel, String ... necessities) {
        HashSet<String> necessitySet = new HashSet<String>(Arrays.asList(necessities));
        HashMap<String, DynamicObject> necessityDimMap = new HashMap<String, DynamicObject>(4);
        DynamicObjectCollection dimensionEntry = PAAnalysisModelHelper.queryModelDimensions(analysisModel);
        for (DynamicObject dynamicObject : dimensionEntry) {
            String dimNecessity = dynamicObject.getString("necessity_dim");
            if (!StringUtils.isNotEmpty((String)dimNecessity) || !necessitySet.contains(dimNecessity)) continue;
            necessityDimMap.put(dimNecessity, dynamicObject);
            if (necessities.length != necessityDimMap.size()) continue;
            break;
        }
        return necessityDimMap;
    }

    public static String getOrgDimNum(DynamicObject analysisModel) {
        String necessity = DimensionNecessityEnum.ORG.getCode();
        DynamicObject dim = PAAnalysisModelHelper.queryModelNecessityDims(analysisModel, necessity).get(necessity);
        if (dim == null) {
            return "";
        }
        return dim.getDynamicObject("dimension").getString("number");
    }

    public static String getPeriodDimNum(DynamicObject analysisModel) {
        String necessity = DimensionNecessityEnum.PERIOD.getCode();
        DynamicObject dim = PAAnalysisModelHelper.queryModelNecessityDims(analysisModel, necessity).get(necessity);
        if (dim == null) {
            return "";
        }
        return dim.getDynamicObject("dimension").getString("number");
    }

    public static String getAccountDimNum(DynamicObject analysisModel) {
        String necessity = DimensionNecessityEnum.ACCOUNT.getCode();
        DynamicObject dim = PAAnalysisModelHelper.queryModelNecessityDims(analysisModel, necessity).get(necessity);
        if (dim == null) {
            return "";
        }
        return dim.getDynamicObject("dimension").getString("number");
    }

    public static DynamicObjectCollection queryModelMeasures(Long modelId) {
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModelFromCache(modelId);
        return PAAnalysisModelHelper.queryModelMeasures(analysisModel);
    }

    public static DynamicObjectCollection queryModelMeasures(DynamicObject analysisModel) {
        if (analysisModel == null) {
            throw new KDBizException("analysisModel is null");
        }
        return analysisModel.getDynamicObjectCollection("measure_entry");
    }

    public static List<String> queryModelDimMeasureNums(DynamicObject analysisModel, boolean containDim, boolean containOrdMeasure, boolean containCalMeasure) {
        ArrayList<String> dimMeaNums = new ArrayList<String>(16);
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        if (containDim) {
            for (DynamicObject entry : dimensionEntry) {
                DynamicObject dim = entry.getDynamicObject("dimension");
                String dimNumber = dim.getString("number");
                dimMeaNums.add(dimNumber);
            }
        }
        DynamicObjectCollection measureEntry = analysisModel.getDynamicObjectCollection("measure_entry");
        for (DynamicObject entry : measureEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String measureType = measure.getString("measuretype");
            String measureNumber = measure.getString("number");
            if (String.valueOf(MeasureTypeEnum.ORDINARY.getCode()).equals(measureType)) {
                if (!containOrdMeasure) continue;
                dimMeaNums.add(measureNumber);
                continue;
            }
            if (!String.valueOf(MeasureTypeEnum.CALCULATION.getCode()).equals(measureType) || !containCalMeasure) continue;
            dimMeaNums.add(measureNumber);
        }
        return dimMeaNums;
    }

    public static String queryTableNumber(Object id) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"tablenumber", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        if (model != null) {
            return model.getString("tablenumber");
        }
        return null;
    }

    public static boolean isExist(Object id) {
        if (id == null) {
            return false;
        }
        String tableNumber = PAAnalysisModelHelper.queryTableNumber(id);
        return tableNumber != null && !StringUtils.isEmpty((String)tableNumber) && MetadataDao.checkNumber((String)PACommonConstans.buildEntityName(tableNumber.toLowerCase(Locale.ENGLISH)));
    }

    public static List<Object> queryNonDateNecDimAnalysisModelIdsBySysTemId(Object systemId) {
        ArrayList<Object> result = new ArrayList<Object>(10);
        QFilter systemFilter = new QFilter("analysis_system", "=", systemId);
        QFilter dimFilter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.PERIOD.getCode());
        QFilter dimTypeFilter = new QFilter("dimension_entry.dimension.dimensiontype", "!=", (Object)DimensionTypeEnum.DATE.getCodeString());
        QFilter tableNumberFilter = new QFilter("tablenumber", "!=", (Object)" ");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAnalysisModelIdsBySysTemId", (String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{systemFilter, dimFilter, dimTypeFilter, tableNumberFilter}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    result.add(row.get("id"));
                }
            }
        }
        return result;
    }

    public static DynamicObjectCollection queryModelByAnaSystem(Object ... anaSystemIds) {
        return QueryServiceHelper.query((String)"pa_analysismodel", (String)"id,name,analysis_system", (QFilter[])new QFilter("analysis_system", "in", (Object)anaSystemIds).toArray(), null);
    }

    public static DynamicObject queryModelNecessityOrgDimension(Long modelId) {
        QFilter idFilter = new QFilter("id", "=", (Object)modelId);
        QFilter dimFilter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.ORG.getCode());
        return QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"id,dimension_entry.dimension.id,dimension_entry.dimension.number,dimension_entry.dimension.dimensiontype,dimension_entry.dimension.dimensionsource,dimension_entry.dimension.group", (QFilter[])new QFilter[]{idFilter, dimFilter});
    }

    public static DynamicObject queryModelNecessityTimeDimension(Long modelId) {
        QFilter idFilter = new QFilter("id", "=", (Object)modelId);
        QFilter dimFilter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.PERIOD.getCode());
        return QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"id,dimension_entry.dimension.id,dimension_entry.dimension.number,dimension_entry.dimension.dimensiontype,dimension_entry.dimension.dimensionsource,dimension_entry.dimension.group", (QFilter[])new QFilter[]{idFilter, dimFilter});
    }

    public static DynamicObject queryModelNecessityAccountDimension(Long modelId) {
        QFilter idFilter = new QFilter("id", "=", (Object)modelId);
        QFilter dimFilter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.ACCOUNT.getCode());
        return QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"id,dimension_entry.dimension.id,dimension_entry.dimension.number,dimension_entry.dimension.dimensiontype,dimension_entry.dimension.dimensionsource,dimension_entry.dimension.group", (QFilter[])new QFilter[]{idFilter, dimFilter});
    }

    public static boolean isModelNewVersionIgnoreTableNumber(Long analysisModelId) {
        QFilter filter = new QFilter("id", "=", (Object)analysisModelId);
        DynamicObject analysisModel = QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"version,tablenumber", (QFilter[])filter.toArray());
        if (analysisModel == null) {
            return false;
        }
        String tableNumber = analysisModel.getString("tablenumber");
        if (StringUtils.isEmpty((String)tableNumber)) {
            return true;
        }
        return analysisModel.getDynamicObjectType().getProperties().get((Object)"version") != null && ModelVersionEnum.new_version.getCodeStr().equals(String.valueOf(analysisModel.get("version"))) && MetadataDao.checkNumber((String)PACommonConstans.buildDetailEntityName(tableNumber));
    }

    public static Object[][] queryModelSumPage(String[][] columnsCopy, String entityNumber, String fields, QFilter[] qFilters, int pageIndex, int pageLength) {
        DynamicObject[] resultDys;
        DynamicObject[] dynamicObjectArray = resultDys = pageLength == -1 ? BusinessDataServiceHelper.load((String)entityNumber, (String)fields, (QFilter[])qFilters, (String)"id desc") : BusinessDataServiceHelper.load((String)entityNumber, (String)fields, (QFilter[])qFilters, (String)"id desc", (int)pageIndex, (int)pageLength);
        if (resultDys != null && resultDys.length > 0) {
            Object[][] data = new Object[resultDys.length][columnsCopy.length];
            int i = 0;
            for (DynamicObject dyo : resultDys) {
                for (int j = 0; j < columnsCopy.length; ++j) {
                    data[i][j] = dyo.get(columnsCopy[j][1]);
                }
                ++i;
            }
            return data;
        }
        return new Object[0][];
    }

    public static int countModelSum(String entityNumber, QFilter[] qFilters) {
        return ORM.create().count(ALGO_KEY, entityNumber, qFilters);
    }

    public static List<Long> getSummaryQueryModelIdList() {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter versionFilter = new QFilter("version", "=", (Object)"1");
        QFilter tableNumberFilter = new QFilter("tablenumber", "!=", (Object)" ");
        Map dyMap = BusinessDataServiceHelper.loadFromCache((String)"pa_analysismodel", (QFilter[])new QFilter[]{statusFilter, enableFilter, versionFilter, tableNumberFilter});
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject dy : dyMap.values()) {
            int count = 0;
            DynamicObjectCollection dimensionDyCol = dy.getDynamicObjectCollection("dimension_entry");
            for (DynamicObject entryDy : dimensionDyCol) {
                String accountNumber;
                String periodNumber;
                DynamicObject dimensionDy;
                DynamicObject dimensionSource;
                String necessityDim = entryDy.getString("necessity_dim");
                if (necessityDim == null || necessityDim.isEmpty() || (dimensionSource = (DynamicObject)(dimensionDy = entryDy.getDynamicObject("dimension")).get("dimensionsource")) == null) continue;
                if (DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim) && "bd_period".equals(periodNumber = dimensionSource.getString("number"))) {
                    ++count;
                }
                if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim) || !"bd_accountview".equals(accountNumber = dimensionSource.getString("number"))) continue;
                ++count;
            }
            if (count != 2) continue;
            Long id = dy.getLong("id");
            idList.add(id);
        }
        return idList;
    }

    public static Set<String> getModelFieldSet(Long analysisModelId) {
        Set<String> dimFieldSet = PAAnalysisModelHelper.getDimFieldSet(analysisModelId);
        Set<String> meaFieldSet = PAAnalysisModelHelper.getMeaFieldSet(analysisModelId);
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>(dimFieldSet.size() + meaFieldSet.size());
        fieldSet.addAll(dimFieldSet);
        fieldSet.addAll(meaFieldSet);
        return fieldSet;
    }

    public static Set<String> getDimFieldSet(Long analysisModelId) {
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            return new HashSet<String>();
        }
        LinkedHashSet<String> dimFieldList = new LinkedHashSet<String>();
        DynamicObjectCollection dimDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        List dimDyList = dimDyCol.stream().sorted(Comparator.comparingInt(dy -> dy.getInt("seq"))).collect(Collectors.toList());
        for (DynamicObject entryDy : dimDyList) {
            DynamicObject dimDy = entryDy.getDynamicObject("dimension");
            String fieldNumberStr = entryDy.getString("field_number_tag");
            String number = dimDy.getString("number");
            String type = dimDy.getString("dimensiontype");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(type);
            if (DimensionTypeEnum.DATABASE == dimensionTypeEnum || DimensionTypeEnum.ASSISTANTDATA == dimensionTypeEnum) {
                String[] fieldNumbers;
                if (!StringUtils.isNotEmpty((String)fieldNumberStr)) continue;
                for (String fieldNumber : fieldNumbers = fieldNumberStr.split(",")) {
                    dimFieldList.add(number + "." + fieldNumber);
                }
                continue;
            }
            dimFieldList.add(number);
        }
        return dimFieldList;
    }

    public static Set<String> getDimNameFieldSet(Long analysisModelId, List<Long> dimIdList) {
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            return new HashSet<String>();
        }
        if (dimIdList == null || dimIdList.isEmpty()) {
            return new HashSet<String>();
        }
        LinkedHashSet<String> dimFieldList = new LinkedHashSet<String>();
        DynamicObjectCollection dimDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        List dimDyList = dimDyCol.stream().filter(dy -> dimIdList.contains(dy.getLong("dimension_id"))).sorted(Comparator.comparingInt(dy -> dy.getInt("seq"))).collect(Collectors.toList());
        for (DynamicObject entryDy : dimDyList) {
            DynamicObject dimDy = entryDy.getDynamicObject("dimension");
            String fieldNumberStr = entryDy.getString("field_number_tag");
            String number = dimDy.getString("number");
            String type = dimDy.getString("dimensiontype");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(type);
            if (DimensionTypeEnum.DATABASE == dimensionTypeEnum || DimensionTypeEnum.ASSISTANTDATA == dimensionTypeEnum) {
                String[] fieldNumbers;
                if (!StringUtils.isNotEmpty((String)fieldNumberStr)) continue;
                for (String fieldNumber : fieldNumbers = fieldNumberStr.split(",")) {
                    if (!"name".equals(fieldNumber)) continue;
                    dimFieldList.add(number + "." + fieldNumber);
                }
                continue;
            }
            dimFieldList.add(number);
        }
        return dimFieldList;
    }

    public static Set<String> getDimPkFieldSet(Set<String> dimFieldSet) {
        HashSet<String> dimIdSet = new HashSet<String>();
        for (String field : dimFieldSet) {
            String[] strings;
            if (!field.contains(".") || (strings = field.split("\\.")).length <= 0) continue;
            dimIdSet.add(strings[0] + ".id");
        }
        return dimIdSet;
    }

    public static Map<String, String> getDimFieldMap(Long analysisModelId) {
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            return new HashMap<String, String>();
        }
        LinkedHashMap<String, String> dimFieldMap = new LinkedHashMap<String, String>();
        DynamicObjectCollection dimDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        List dimDyList = dimDyCol.stream().sorted(Comparator.comparingInt(dy -> dy.getInt("seq"))).collect(Collectors.toList());
        for (DynamicObject entryDy : dimDyList) {
            DynamicObject dimDy = entryDy.getDynamicObject("dimension");
            String fieldNumberStr = entryDy.getString("field_number_tag");
            String fieldNameStr = entryDy.getString("field_name");
            String number = dimDy.getString("number");
            String name = dimDy.getString("name");
            String type = dimDy.getString("dimensiontype");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(type);
            if (DimensionTypeEnum.DATABASE == dimensionTypeEnum || DimensionTypeEnum.ASSISTANTDATA == dimensionTypeEnum) {
                if (!StringUtils.isNotEmpty((String)fieldNumberStr) || !StringUtils.isNotEmpty((String)fieldNameStr)) continue;
                String[] fieldNumbers = fieldNumberStr.split(",");
                String[] fieldNames = fieldNameStr.split(",");
                int length = Math.min(fieldNumbers.length, fieldNames.length);
                for (int i = 0; i < length; ++i) {
                    String fieldNumber = fieldNumbers[i];
                    String fieldName = fieldNames[i];
                    dimFieldMap.put(number + "." + fieldNumber, name + "." + fieldName);
                }
                continue;
            }
            dimFieldMap.put(number, name);
        }
        return dimFieldMap;
    }

    public static Map<String, DynamicObject> getDimFieldDyMap(Long analysisModelId) {
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            return new HashMap<String, DynamicObject>();
        }
        LinkedHashMap<String, DynamicObject> dimFieldDyMap = new LinkedHashMap<String, DynamicObject>();
        DynamicObjectCollection dimDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        List dimDyList = dimDyCol.stream().sorted(Comparator.comparingInt(dy -> dy.getInt("seq"))).collect(Collectors.toList());
        for (DynamicObject entryDy : dimDyList) {
            DynamicObject dimDy = entryDy.getDynamicObject("dimension");
            String fieldNumberStr = entryDy.getString("field_number_tag");
            String number = dimDy.getString("number");
            String type = dimDy.getString("dimensiontype");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(type);
            if (DimensionTypeEnum.DATABASE == dimensionTypeEnum || DimensionTypeEnum.ASSISTANTDATA == dimensionTypeEnum) {
                String[] fieldNumbers;
                if (!StringUtils.isNotEmpty((String)fieldNumberStr)) continue;
                for (String fieldNumber : fieldNumbers = fieldNumberStr.split(",")) {
                    dimFieldDyMap.put(number + "." + fieldNumber, dimDy);
                }
                continue;
            }
            dimFieldDyMap.put(number, dimDy);
        }
        return dimFieldDyMap;
    }

    public static Set<String> getMeaFieldSet(Long analysisModelId) {
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            return new HashSet<String>();
        }
        DynamicObjectCollection meaDyCol = analysisModelDy.getDynamicObjectCollection("measure_entry");
        List meaDyList = meaDyCol.stream().sorted(Comparator.comparingInt(dy -> dy.getInt("seq"))).collect(Collectors.toList());
        LinkedHashSet<String> meaFieldSet = new LinkedHashSet<String>(meaDyList.size());
        for (DynamicObject entryDy : meaDyList) {
            DynamicObject meaDy = entryDy.getDynamicObject("measure");
            String number = meaDy.getString("number");
            meaFieldSet.add(number);
        }
        return meaFieldSet;
    }

    public static Set<String> getNoNecDimNumberList(Long analysisModelId) {
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            return new HashSet<String>();
        }
        DynamicObjectCollection dimDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        List noNecDimList = dimDyCol.stream().filter(dy -> {
            String necessityDim = dy.getString("necessity_dim");
            return StringUtils.isEmpty((String)necessityDim);
        }).map(dy -> dy.getLong("dimension_id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", noNecDimList);
        Map dimDyMap = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (QFilter[])new QFilter[]{idFilter});
        return dimDyMap.values().stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
    }

    public static Set<String> getSpecialDimNumberSet(Long analysisModelId, DimensionTypeEnum dimensionTypeEnum) {
        if (dimensionTypeEnum == null) {
            return new HashSet<String>();
        }
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            return new HashSet<String>();
        }
        DynamicObjectCollection dimDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        List dateDimList = dimDyCol.stream().filter(dy -> {
            DynamicObject dimDy = dy.getDynamicObject("dimension");
            String dimensionType = dimDy.getString("dimensiontype");
            return dimensionTypeEnum.getCodeString().equals(dimensionType);
        }).map(dy -> dy.getLong("dimension_id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", dateDimList);
        Map dimDyMap = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (QFilter[])new QFilter[]{idFilter});
        return dimDyMap.values().stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
    }
}

