/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.Collections;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public final class PACustomParamHelper {
    private static final Log logger = LogFactory.getLog(PACustomParamHelper.class);
    private static final String APP_ID = "pa";
    public static final String KEY_RULEEXECORGCOUNTLIMIT = "ruleexecorgcountlimit";
    public static final String KEY_TAGSUMMARYDETAILCOUNTLIMIT = "tagsummarydetailcountlimit";
    public static final String KEY_MAXORGINPUTCOUNT = "maxorginputcount";

    private PACustomParamHelper() {
    }

    private static String getAppId() {
        return AppMetadataCache.getAppInfo((String)APP_ID).getId();
    }

    public static String getCustomParam(String key) {
        return PACustomParamHelper.getCustomParam(key, "");
    }

    public static String getCustomParam(String key, String defaultValue) {
        AppCustomParam appCustomParam = new AppCustomParam(PACustomParamHelper.getAppId(), Collections.singleton(key));
        String value = (String)SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)appCustomParam).get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    public static int getCustomParam(String key, int defaultValue, int minValue, int maxValue) {
        String value = PACustomParamHelper.getCustomParam(key, String.valueOf(defaultValue));
        try {
            int intValue = Integer.parseInt(value);
            if (intValue >= minValue && intValue <= maxValue) {
                return intValue;
            }
        }
        catch (Exception e) {
            logger.error("[FI-PA] parse " + key + " error", (Throwable)e);
        }
        return defaultValue;
    }

    public static int getRuleExecOrgCountLimit() {
        return PACustomParamHelper.getCustomParam(KEY_RULEEXECORGCOUNTLIMIT, 40, 1, 100);
    }

    public static int getTagSummaryDetailCountLimit() {
        return PACustomParamHelper.getCustomParam(KEY_TAGSUMMARYDETAILCOUNTLIMIT, 100000, 1, 500000);
    }

    public static int getMaxOrgInputCount() {
        return PACustomParamHelper.getCustomParam(KEY_MAXORGINPUTCOUNT, 4, 1, 20);
    }
}

