/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.helper.EntityMetaHelper;

public class PADimensionHelper {
    public static DynamicObject loadDimension(Object dimensionId) {
        return BusinessDataServiceHelper.loadSingle((Object)dimensionId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_dimension"));
    }

    public static Optional<String> getTypeFieldBaseEntityId(DynamicObject dimension) {
        DynamicObject value = dimension.getDynamicObject("dimensionsource");
        String typefield = dimension.getString("typefield");
        if (value != null && typefield != null) {
            return EntityMetaHelper.getBaseEntityId((String)value.getPkValue(), typefield);
        }
        return Optional.empty();
    }

    public static DynamicObject loadGroupDynamicObject(DynamicObject dimension) {
        Object group_id = dimension.get("group_id");
        Optional<String> optional = PADimensionHelper.getTypeFieldBaseEntityId(dimension);
        if (optional.isPresent() && group_id != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)group_id, (String)optional.get());
        }
        return null;
    }

    public static QFilter getDimensionTypeQFilter(DynamicObject dimension) {
        String grouptype = dimension.getString("typefield");
        Object group_id = dimension.get("group_id");
        if (StringUtils.isNotEmpty((CharSequence)grouptype) && group_id != null) {
            return new QFilter(grouptype, "=", group_id);
        }
        return null;
    }

    public static QFilter getDimGroupFilter(DynamicObject dimension) {
        String dimType = dimension.getString("dimensiontype");
        DimensionTypeEnum dimTypeEnum = DimensionTypeEnum.getEnum(dimType);
        if (dimTypeEnum == null) {
            return null;
        }
        switch (dimTypeEnum) {
            case DATABASE: {
                String groupType = dimension.getString("typefield");
                Object groupId = dimension.get("group_id");
                if (StringUtils.isNotEmpty((CharSequence)groupType) && groupId != null) {
                    return new QFilter(groupType, "=", groupId);
                }
                return null;
            }
            case ASSISTANTDATA: {
                DynamicObject assistantDy = dimension.getDynamicObject("assistantsource");
                if (assistantDy != null) {
                    return new QFilter("group", "=", assistantDy.getPkValue());
                }
                return null;
            }
        }
        return null;
    }

    public static DynamicObject[] loadDimension(Object[] dimensionIds) {
        Map dimensions = BusinessDataServiceHelper.loadFromCache((Object[])dimensionIds, (String)"pa_dimension");
        return dimensions.values().toArray(new DynamicObject[0]);
    }

    public static Map<Object, DynamicObject> loadDimensionFromCache(Object[] dimensionIds) {
        return BusinessDataServiceHelper.loadFromCache((Object[])dimensionIds, (String)"pa_dimension");
    }

    public static boolean isDefaultPresetDimension(Object dimensionId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_dimension", (String)"isdefault", (QFilter[])new QFilter("id", "=", dimensionId).toArray());
        if (dynamicObject == null) {
            return false;
        }
        return "true".equals(dynamicObject.getString("isdefault"));
    }

    public static DynamicObjectCollection queryDimensionByAnaSystem(Object ... anaSystemIds) {
        QFilter systemIdFilter = new QFilter("system", "in", (Object)anaSystemIds);
        QFilter isDefaultFilter = new QFilter("isdefault", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.query((String)"pa_dimension", (String)"id,system", (QFilter[])new QFilter[]{systemIdFilter, isDefaultFilter}, null);
    }

    public static void deleteDimensionByAnaSystemIds(Object ... anaSystemIds) {
        DeleteServiceHelper.delete((String)"pa_dimension", (QFilter[])new QFilter("system", "in", (Object)anaSystemIds).toArray());
    }

    public static String getDimensionSource(DynamicObject dimension) {
        String baseEntityId = "";
        if (dimension == null) {
            return baseEntityId;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(dimension.getString("dimensiontype"));
        switch (dimType) {
            case DATABASE: {
                DynamicObject dimensionSource = dimension.getDynamicObject("dimensionsource");
                baseEntityId = dimensionSource.getString("number");
                break;
            }
            case ASSISTANTDATA: {
                baseEntityId = "bos_assistantdata_detail";
                break;
            }
        }
        return baseEntityId;
    }

    public static Map<Object, DynamicObject> queryDimensionType(Object[] pks) {
        if (pks == null || pks.length <= 0) {
            return new HashMap<Object, DynamicObject>(1);
        }
        HashMap<Object, DynamicObject> data = new HashMap<Object, DynamicObject>(pks.length);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"pa_dimension", (String)"id,dimensionsource,group,typefield", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        for (DynamicObject object : cols) {
            data.put(object.get("id"), object);
        }
        return data;
    }

    public static Object[] queryDimensionValueByType(DynamicObject dimension) {
        Object[] temp = new Object[]{};
        if (dimension == null) {
            return temp;
        }
        ArrayList<Object> idList = new ArrayList<Object>(10);
        String entityNumber = dimension.getString("dimensionsource");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDimensionValueByType", (String)entityNumber, (String)"id", (QFilter[])new QFilter[]{new QFilter(dimension.getString("typefield"), "=", dimension.get("group"))}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    idList.add(row.get("id"));
                }
            }
        }
        return idList.isEmpty() ? temp : idList.toArray(temp);
    }

    public static Map<String, DynamicObject> getDimensionsFromModelMap(Long analysisModelId) {
        DynamicObject dyModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        DynamicObjectCollection dEntry = dyModel.getDynamicObjectCollection("dimension_entry");
        return dEntry.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("dimension.number"), dynamicObject -> dynamicObject.getDynamicObject("dimension")));
    }

    public static QFilter getNoDateTimeDimFilter() {
        return new QFilter("dimensiontype", "!=", (Object)DimensionTypeEnum.DATE.getCodeString());
    }

    public static QFilter getNoEnumDimFilter() {
        return new QFilter("dimensiontype", "!=", (Object)DimensionTypeEnum.DENUMS.getCodeString());
    }

    public static QFilter getDefaultDimFilter() {
        String[] types = new String[]{DimensionTypeEnum.DATABASE.getCodeString(), DimensionTypeEnum.ASSISTANTDATA.getCodeString(), DimensionTypeEnum.DENUMS.getCodeString(), DimensionTypeEnum.OTHER.getCodeString()};
        return new QFilter("dimensiontype", "in", (Object)types);
    }

    public static QFilter getSpecialDimFilter(Long dimId) {
        DynamicObject dimDy = BusinessDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"pa_dimension");
        if (dimDy == null) {
            return null;
        }
        QFilter baseFilter = new QFilter("id", "!=", (Object)dimId);
        String dimType = dimDy.getString("dimensiontype");
        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(dimType);
        switch (dimensionTypeEnum) {
            case DATABASE: {
                baseFilter.and(new QFilter("dimensiontype", "=", (Object)DimensionTypeEnum.DATABASE.getCodeString()));
                String bdDimSrcId = dimDy.getString("dimensionsource_id");
                baseFilter.and(new QFilter("dimensionsource", "=", (Object)bdDimSrcId));
                long groupId = dimDy.getLong("group_id");
                if (groupId == 0L) break;
                baseFilter.and(new QFilter("group", "=", (Object)groupId));
                break;
            }
            case ASSISTANTDATA: {
                baseFilter.and(new QFilter("dimensiontype", "=", (Object)DimensionTypeEnum.ASSISTANTDATA.getCodeString()));
                long assDimSrcId = dimDy.getLong("assistantsource_id");
                baseFilter.and(new QFilter("assistantsource", "=", (Object)assDimSrcId));
                break;
            }
            case DENUMS: {
                baseFilter.and(new QFilter("dimensiontype", "=", (Object)DimensionTypeEnum.DENUMS.getCodeString()));
                break;
            }
            case OTHER: {
                baseFilter.and(new QFilter("dimensiontype", "=", (Object)DimensionTypeEnum.OTHER.getCodeString()));
                break;
            }
        }
        return baseFilter;
    }
}

