/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.pa.common.enums.EnableStatusEnum;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.dto.ExecutionLogEntryDTO;
import kd.fi.pa.dto.OffExecDetailLogDTO;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.enums.MultiOrgShareEnum;
import kd.fi.pa.handle.IDataSummaryHandler;
import kd.fi.pa.handle.impl.ShareDataSummaryHandler;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PALogHelper;
import kd.fi.pa.helper.PARuleHelper;
import kd.fi.pa.model.impl.PADimensionModel;

public class PAExecutorHelper {
    private static final String ALGO_KEY = PAExecutorHelper.class.getName();
    private static final Log logger = LogFactory.getLog(PAExecutorHelper.class);

    public static QFilter[] processQFilterBySenderEntry(DynamicObjectCollection entry) {
        DynamicObject dy;
        QFilter[] result = new QFilter[entry.size()];
        int i = 0;
        Iterator iterator = entry.iterator();
        block5: while (iterator.hasNext() && !ObjectUtils.isEmpty((Object)(dy = (DynamicObject)iterator.next()).get("senddimension"))) {
            QFilter filter;
            String number = dy.getString("senddimension.number");
            DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(dy.getString("senddimension.dimensiontype"));
            String sendCondition = dy.getString("combofield");
            String baseEntityId = dy.getString("dimensiontype_basedata");
            String idStr = "";
            String valueStr = "";
            String text = dy.getString("dimensiontext_tag");
            if (DimensionTypeEnum.OTHER == dimType) {
                valueStr = text;
            } else if (StringUtils.isNotBlank((CharSequence)text)) {
                Map map = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                valueStr = String.join((CharSequence)",", map.values());
                idStr = String.join((CharSequence)",", map.keySet());
            }
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum(sendCondition);
            switch (conditionEnum) {
                case IS_NULL: {
                    QFilter isNullFilter = DimensionTypeEnum.OTHER == dimType || DimensionTypeEnum.DENUMS == dimType || PADimensionModel.isStringPrimaryKeyType(baseEntityId) ? new QFilter(number, "=", (Object)" ").or(number, "=", (Object)"").or(number, "is null", null) : new QFilter(number, "=", (Object)0);
                    result[i++] = isNullFilter;
                    continue block5;
                }
                case IS_NOTNULL: {
                    QFilter isNotNullFilter = DimensionTypeEnum.OTHER == dimType || DimensionTypeEnum.DENUMS == dimType || PADimensionModel.isStringPrimaryKeyType(baseEntityId) ? new QFilter(number, "!=", (Object)" ").and(number, "!=", (Object)"").and(number, "is not null", null) : new QFilter(number, "!=", (Object)0);
                    result[i++] = isNotNullFilter;
                    continue block5;
                }
                case ALL: {
                    continue block5;
                }
            }
            String condition = conditionEnum.getValue();
            if (DimensionTypeEnum.OTHER == dimType) {
                filter = new QFilter(number, condition, (Object)valueStr.split("\n"));
            } else if (DimensionTypeEnum.DENUMS == dimType) {
                filter = new QFilter(number, condition, (Object)idStr.split(","));
            } else {
                boolean isString = PADimensionModel.isStringPrimaryKeyType(baseEntityId);
                List idList = Stream.of(idStr.split(",")).map(idKeyStr -> isString ? idKeyStr : Long.valueOf(idKeyStr)).collect(Collectors.toList());
                filter = new QFilter(number, condition, idList);
            }
            result[i++] = filter;
        }
        return result;
    }

    public static QFilter processCommonFilters(Map<String, Object> param, DynamicObjectCollection dimensionEntry) {
        Object periodId = param.get("periodId");
        Object orgId = param.get("orgId");
        Object accounts = param.get("accounts");
        boolean isAccount = (Boolean)param.get("isAccount");
        Date startDate = (Date)param.get("startDate");
        Date endDate = (Date)param.get("endDate");
        QFilter commonFilter = null;
        for (DynamicObject dimension : dimensionEntry) {
            String val = dimension.getString("necessity_dim");
            String number = dimension.getDynamicObject("dimension").getString("number");
            DimensionNecessityEnum dimEnum = DimensionNecessityEnum.getEnum(val);
            if (dimEnum == null) continue;
            switch (dimEnum) {
                case ORG: {
                    commonFilter = PAExecutorHelper.processCommonFilter(commonFilter, number, orgId);
                    break;
                }
                case PERIOD: {
                    if (ObjectUtils.isEmpty((Object)periodId)) {
                        commonFilter = PAExecutorHelper.processTimeDimFilter(commonFilter, number, startDate, endDate);
                        break;
                    }
                    commonFilter = PAExecutorHelper.processCommonFilter(commonFilter, number, periodId);
                    break;
                }
                case ACCOUNT: {
                    if (isAccount) break;
                    commonFilter = PAExecutorHelper.processCommonFilter(commonFilter, number, accounts);
                    break;
                }
            }
        }
        return commonFilter;
    }

    public static QFilter buildOrgPeriodAccountQFilter(DynamicObject analysisModel, List<Long> orgIds, Long periodId, Date startDate, Date endDate, Set<Object> accountIdSet) {
        Optional<QFilter> accountQFilter;
        Optional<QFilter> periodQFilter;
        Optional<QFilter> orgQFilter;
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        Map<String, DynamicObject> necessityDimMap = PAAnalysisModelHelper.queryModelNecessityDims(analysisModel, DimensionNecessityEnum.ORG.getCode(), DimensionNecessityEnum.PERIOD.getCode(), DimensionNecessityEnum.ACCOUNT.getCode());
        if (!CollectionUtils.isEmpty(orgIds) && (orgQFilter = Optional.ofNullable(necessityDimMap.get(DimensionNecessityEnum.ORG.getCode())).map(dy -> dy.getDynamicObject("dimension").getString("number")).map(number -> PAExecutorHelper.processCommonFilter(null, number, orgIds))).isPresent()) {
            qFilter = qFilter.and(orgQFilter.get());
        }
        if ((periodId != null || startDate != null && endDate != null) && (periodQFilter = Optional.ofNullable(necessityDimMap.get(DimensionNecessityEnum.PERIOD.getCode())).map(dy -> dy.getDynamicObject("dimension").getString("number")).map(number -> {
            if (Objects.isNull(periodId)) {
                return PAExecutorHelper.processTimeDimFilter(null, number, startDate, endDate);
            }
            return PAExecutorHelper.processCommonFilter(null, number, periodId);
        })).isPresent()) {
            qFilter = qFilter.and(periodQFilter.get());
        }
        if (!CollectionUtils.isEmpty(accountIdSet) && (accountQFilter = Optional.ofNullable(necessityDimMap.get(DimensionNecessityEnum.ACCOUNT.getCode())).map(dy -> dy.getDynamicObject("dimension").getString("number")).map(number -> PAExecutorHelper.processCommonFilter(null, number, accountIdSet))).isPresent()) {
            qFilter = qFilter.and(accountQFilter.get());
        }
        return qFilter;
    }

    public static Object processTypeConvert(String number, DynamicObject dy, Object obj) {
        DynamicProperty property;
        if (number.contains(".")) {
            dy = dy.getDynamicObject(number.substring(0, number.lastIndexOf(".")));
            number = number.substring(number.lastIndexOf(".") + 1);
        }
        if (DynamicObject.class.isAssignableFrom((property = dy.getDynamicObjectType().getProperty(number)).getPropertyType())) {
            obj = dy.get(number + "_id");
        } else if (ILocaleString.class.isAssignableFrom(property.getPropertyType())) {
            obj = dy.get(number).toString();
        }
        return obj;
    }

    public static QFilter processTimeDimFilter(QFilter commonFilter, String number, Date start, Date end) {
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (start != null) {
            filter = filter.and(number, ">=", (Object)start);
        }
        if (end != null) {
            filter = filter.and(number, "<", (Object)end);
        }
        commonFilter = commonFilter.and(filter);
        return commonFilter;
    }

    public static QFilter processCommonFilter(QFilter commonFilter, String number, Object value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return commonFilter;
        }
        QFilter filter = value instanceof Collection ? new QFilter(number, "in", value) : new QFilter(number, "=", value);
        commonFilter = commonFilter == null ? filter : commonFilter.and(filter);
        return commonFilter;
    }

    public static QFilter getCommonOffFilter() {
        return new QFilter("offstatus", "=", (Object)0).and("datastatus", "!=", (Object)4).and("datastatus", "!=", (Object)0).and("collectstatus", "=", (Object)0);
    }

    public static QFilter getCommonDerivationFilter() {
        return new QFilter("situationtype", "=", (Object)0).and("collectstatus", "=", (Object)1);
    }

    public static QFilter getEnableFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public static boolean isContainEnableField(String entity) {
        String fields = PAExecutorHelper.getPropByEntity(entity);
        return StringUtils.isNotBlank((CharSequence)fields) && fields.contains("enable");
    }

    public static String getPropByEntity(String entity) {
        StringBuilder fields = new StringBuilder();
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)entity);
        DataEntityPropertyCollection properties = result.getDynamicObjectType().getProperties();
        for (IDataEntityProperty prop : properties) {
            String name = prop.getName();
            fields.append(name).append(',');
        }
        return fields.substring(0, fields.length() - 1);
    }

    public static List<String> getMeasureListByModel(DynamicObject analysisModel) {
        DynamicObjectCollection cols = analysisModel.getDynamicObjectCollection("measure_entry");
        Object[] ids = cols.stream().map(dy -> dy.getDynamicObject("measure").getPkValue()).toArray();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter typeFilter = new QFilter("measuretype", "=", (Object)"1");
        ArrayList<String> result = new ArrayList<String>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_measure", (String)"number", (QFilter[])new QFilter[]{filter, typeFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.add(row.getString("number"));
            }
        }
        return result;
    }

    public static DynamicObject[] processAdjustStatus(String detailModelEntity, Set<Long> ids) {
        Object row;
        HashSet<Long> execLogIds = new HashSet<Long>(ids.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)detailModelEntity, (String)"subexeclogid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                execLogIds.add(row.getLong("subexeclogid"));
            }
        }
        HashSet<Long> billIds = new HashSet<Long>(ids.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_adexeclog", (String)"ad_pk", (QFilter[])new QFilter[]{new QFilter("id", "in", execLogIds)}, null);
        row = null;
        try {
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                billIds.add(row2.getLong("ad_pk"));
            }
        }
        catch (Throwable row2) {
            row = row2;
            throw row2;
        }
        finally {
            if (dataSet != null) {
                if (row != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row2) {
                        ((Throwable)row).addSuppressed(row2);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pa_dataadjust");
        DynamicObject[] adjustDys = BusinessDataServiceHelper.load((Object[])billIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType);
        List<DynamicObject> cols = Arrays.stream(adjustDys).filter(dy -> !StringUtils.equals((CharSequence)"4", (CharSequence)dy.getString("adjuststatus"))).collect(Collectors.toList());
        cols.forEach(dy -> dy.set("adjuststatus", (Object)"4"));
        return cols.toArray(new DynamicObject[0]);
    }

    public static void processCommonMeasures(String entity, String fields, DynamicObject[] dys, List<String> measureList, List<DynamicObject> writeOffs, Set<Long> ids, Long logId) {
        long[] resultIds = DB.genLongIds((String)entity, (int)dys.length);
        Date now = new Date();
        int i = 0;
        for (DynamicObject dy : dys) {
            String dataStatus = dy.get("datastatus").toString();
            long id = Long.parseLong(dy.get("id").toString());
            if (StringUtils.equals((CharSequence)"3", (CharSequence)dataStatus)) {
                ids.add(id);
            }
            dy.set("offstatus", (Object)"1");
            DynamicObject writeOffDy = BusinessDataServiceHelper.newDynamicObject((String)entity);
            writeOffDy.set("datastatus", (Object)"4");
            for (String name : fields.split(",")) {
                if (StringUtils.equals((CharSequence)"id", (CharSequence)name) || StringUtils.equals((CharSequence)"datastatus", (CharSequence)name) || StringUtils.equals((CharSequence)"offstatus", (CharSequence)name)) continue;
                if (measureList.contains(name)) {
                    writeOffDy.set(name, (Object)dy.getBigDecimal(name).negate());
                    continue;
                }
                writeOffDy.set(name, dy.get(name));
            }
            long resultId = resultIds[i++];
            writeOffDy.set("execlogid", (Object)logId);
            writeOffDy.set("execparentbillid", (Object)id);
            writeOffDy.set("id", (Object)resultId);
            writeOffDy.set("createtime", (Object)now);
            writeOffDy.set("createstamp", (Object)now.getTime());
            writeOffs.add(writeOffDy);
        }
    }

    public static void processOffExecutionLog(Map<Long, Long> executeDetailMap, Long logId) {
        ArrayList<OffExecDetailLogDTO> offExecDetailLogList = new ArrayList<OffExecDetailLogDTO>(executeDetailMap.size());
        for (Map.Entry<Long, Long> entry : executeDetailMap.entrySet()) {
            OffExecDetailLogDTO offExecDetailLog = new OffExecDetailLogDTO();
            offExecDetailLog.setExecutionLogPk(logId);
            offExecDetailLog.setSourcePk(entry.getKey());
            offExecDetailLog.setTargetPk(entry.getValue());
            offExecDetailLogList.add(offExecDetailLog);
        }
        PALogHelper.createOffExecDetailLogs(offExecDetailLogList);
    }

    public static void processSummary(Long analysisModelId, List<DynamicObject> results, List<DynamicObject> writeOffs) {
        ShareDataSummaryHandler handle = new ShareDataSummaryHandler();
        if (!CollectionUtils.isEmpty(writeOffs)) {
            results.addAll(writeOffs);
        }
        handle.summary(results, analysisModelId);
    }

    public static DynamicObject[] processModelDataSet(String entity, QFilter commonFilter) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)entity, (String)"id", (QFilter[])new QFilter[]{commonFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("id"));
            }
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        return BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)entityType);
    }

    public static long getDetailIdByModelIdAndSummaryId(long modelId, long id) {
        QFilter filter = new QFilter("summaryid", "=", (Object)id);
        QFilter modelFilter = new QFilter("analysismodel", "=", (Object)modelId);
        long detailId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_detailsummarymapping", (String)"detailid", (QFilter[])new QFilter[]{modelFilter, filter}, (String)"createtime desc", (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                detailId = row.getLong("detailid");
            }
        }
        return detailId;
    }

    public static Map<Long, Long> getDetailIdByModelIdAndSummaryId(long modelId, List<Long> ids) {
        QFilter filter = new QFilter("summaryid", "in", ids);
        QFilter modelFilter = new QFilter("analysismodel", "=", (Object)modelId);
        HashMap<Long, Long> detailIds = new HashMap<Long, Long>(ids.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_detailsummarymapping", (String)"detailid,summaryid", (QFilter[])new QFilter[]{modelFilter, filter}, (String)"createtime desc");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long summaryId = row.getLong("summaryid");
                Long detailId = row.getLong("detailid");
                if (detailIds.containsValue(summaryId)) continue;
                detailIds.put(detailId, summaryId);
            }
        }
        return detailIds;
    }

    public static long getExecRuleIdByDetailId(long detailId) {
        QFilter filter = new QFilter("target_pk", "=", (Object)detailId);
        long logPKId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_ruleexecdetail", (String)"rule_execution_logpk", (QFilter[])new QFilter[]{filter}, null, (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                logPKId = row.getLong("rule_execution_logpk");
            }
        }
        return logPKId;
    }

    public static Map<Long, Set<Long>> getExecRuleIdByDetailId(Map<Long, Long> detailId) {
        QFilter filter = new QFilter("target_pk", "in", detailId.keySet());
        HashMap<Long, Set<Long>> logPKIds = new HashMap<Long, Set<Long>>(detailId.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_ruleexecdetail", (String)"rule_execution_logpk,target_pk", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long targetPk = row.getLong("target_pk");
                Long ruleExecutionLogpk = row.getLong("rule_execution_logpk");
                Set currentSet = (Set)logPKIds.get(ruleExecutionLogpk);
                Long currentId = detailId.get(targetPk);
                if (currentSet == null || currentSet.isEmpty()) {
                    HashSet<Long> set = new HashSet<Long>(22);
                    set.add(currentId);
                    logPKIds.put(ruleExecutionLogpk, set);
                    continue;
                }
                currentSet.add(currentId);
                logPKIds.put(ruleExecutionLogpk, currentSet);
            }
        }
        return logPKIds;
    }

    public static long getStepIdByExecRuleId(long execRuleId) {
        QFilter filter = new QFilter("id", "=", (Object)execRuleId);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"pa_ruleexeclog", (String)"rule_pk", (QFilter[])new QFilter[]{filter});
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("rule_pk");
    }

    public static Map<Long, Set<Long>> getStepIdByExecRuleId(Map<Long, Set<Long>> execRuleId) {
        QFilter filter = new QFilter("id", "in", execRuleId.keySet());
        HashMap<Long, Set<Long>> ids = new HashMap<Long, Set<Long>>(execRuleId.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_ruleexeclog", (String)"id,rule_pk", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                Long rulePk = row.getLong("rule_pk");
                ids.put(rulePk, execRuleId.get(id));
            }
        }
        return ids;
    }

    public static Set<Long> processRepeatedExecOp(long modelId, long ruleId, List<Long> ids) {
        Map<Long, Long> detailIds = PAExecutorHelper.getDetailIdByModelIdAndSummaryId(modelId, ids);
        if (detailIds.isEmpty()) {
            return Collections.emptySet();
        }
        Map<Long, Set<Long>> execRuleIds = PAExecutorHelper.getExecRuleIdByDetailId(detailIds);
        if (execRuleIds.isEmpty()) {
            return Collections.emptySet();
        }
        Map<Long, Set<Long>> stepIds = PAExecutorHelper.getStepIdByExecRuleId(execRuleIds);
        if (stepIds.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Long> result = stepIds.entrySet().stream().filter(entry -> ((Long)entry.getKey()).equals(ruleId)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
        if (result.isEmpty()) {
            result.add(ruleId);
        }
        return result;
    }

    public static void processResultData(long logId, DynamicObject analysisModel, String entity, DynamicObject[] dys, Set<Long> newIds) {
        List<String> measureList = PAExecutorHelper.getMeasureListByModel(analysisModel);
        ArrayList<DynamicObject> writeOffs = new ArrayList<DynamicObject>(dys.length);
        HashSet<Long> ids = new HashSet<Long>(10);
        String fields = PAExecutorHelper.getPropByEntity(entity);
        PAExecutorHelper.processCommonMeasures(entity, fields, dys, measureList, writeOffs, ids, logId);
        if (newIds != null) {
            ids.addAll(newIds);
        }
        DynamicObject[] adjustDys = PAExecutorHelper.processAdjustStatus(entity, ids);
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.update((DynamicObject[])dys);
                SaveServiceHelper.save((DynamicObject[])adjustDys);
                SaveServiceHelper.save((DynamicObject[])writeOffs.toArray(new DynamicObject[0]));
                IDataSummaryHandler.getInstance().summary(writeOffs, analysisModel.getLong("id"));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static List<ExecutionLogDTO> processRuleExecute(Map<String, Object> param) {
        logger.info(String.format("the input parameter is {%s}", param));
        Set orgIds = (Set)param.get("orgIds");
        Object modelId = param.get("modelId");
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return Collections.emptyList();
        }
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (analysisModel == null || CollectionUtils.isEmpty((Collection)analysisModel.getDynamicObjectCollection("dimension_entry"))) {
            return Collections.emptyList();
        }
        String orgDimNum = PAAnalysisModelHelper.getOrgDimNum(analysisModel);
        if (StringUtils.isEmpty((CharSequence)orgDimNum)) {
            throw new KDBizException("orgDim is null");
        }
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        String accountEntity = PAExecutorHelper.getBaseEntityId(analysisModel, DimensionNecessityEnum.ACCOUNT.getCode());
        QFilter baseAccountFilter = PAExecutorHelper.getBaseQFilter(analysisModel, DimensionNecessityEnum.ACCOUNT.getCode());
        String accountNumber = null;
        String accountFields = null;
        for (DynamicObject dynamicObject : dimensionEntry) {
            if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(dynamicObject.getString("necessity_dim"))) continue;
            accountNumber = dynamicObject.getDynamicObject("dimension").getString("number");
            CharSequence[] columnsArr = dynamicObject.getString("field_number_tag").split(",");
            accountFields = "id," + String.join((CharSequence)",", columnsArr);
            break;
        }
        String periodEntity = PAExecutorHelper.getBaseEntityId(analysisModel, DimensionNecessityEnum.PERIOD.getCode());
        param.put("model", analysisModel);
        param.put("periodEntity", periodEntity);
        StringBuilder notInPeriodRangeRuleNameBuilder = new StringBuilder();
        ExecutionLogDTO logDto = PAExecutorHelper.buildDtoByBusinessRuleType(accountEntity, accountNumber, accountFields, baseAccountFilter, notInPeriodRangeRuleNameBuilder, param);
        if (logDto.getEntry().isEmpty() || notInPeriodRangeRuleNameBuilder.length() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u89c4\u5219\u5728\u6240\u9009\u671f\u95f4\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff1a{%s}", (String)"PAExecutorHelper_0", (String)"fi-pa-common", (Object[])new Object[0]), notInPeriodRangeRuleNameBuilder.substring(1)));
        }
        logDto.setOrgIds(orgIds.toArray(new Long[0]));
        if (logDto.getBusinessRule() != 0L) {
            logDto.setIncludeMultiOrgShare(MultiOrgShareEnum.YES == PARuleHelper.computeRuleMultiOrgShare(new Long[]{logDto.getBusinessRule()}, orgDimNum));
        } else {
            logDto.setIncludeMultiOrgShare(MultiOrgShareEnum.YES == PARuleHelper.computeRulePlanMultiOrgShare(logDto.getBusinessPlan(), orgDimNum));
        }
        ArrayList<ExecutionLogDTO> executionLogDTOList = new ArrayList<ExecutionLogDTO>(1);
        executionLogDTOList.add(logDto);
        return executionLogDTOList;
    }

    private static ExecutionLogDTO buildDtoByBusinessRuleType(String accountEntity, String accountNumber, String accountField, QFilter baseAccountFilter, StringBuilder notInPeriodRangeRuleNameBuilder, Map<String, Object> param) {
        boolean flag;
        ExecutionLogDTO dto = new ExecutionLogDTO();
        Long analysisModelId = (Long)param.get("modelId");
        Long analysisSystemId = (Long)param.get("systemId");
        Date startDate = (Date)param.get("rangeStartDate");
        Date endDate = (Date)param.get("rangeEndDate");
        Long periodId = (Long)param.get("startPeriodId");
        dto.setAnalysisSystem(analysisSystemId);
        dto.setAnalysisModel(analysisModelId);
        dto.setExecutionMode(ExecutionModeEnum.execute);
        String periodTypeIdStr = "";
        DynamicObject analysisModel = (DynamicObject)param.get("model");
        String baseEntity = (String)param.get("periodEntity");
        if ("bd_period".equals(baseEntity)) {
            QFilter periodTypeQFilter = PAExecutorHelper.getBaseQFilter(analysisModel, DimensionNecessityEnum.PERIOD.getCode());
            DynamicObject periodTypeObj = QueryServiceHelper.queryOne((String)baseEntity, (String)"id,periodtype", (QFilter[])periodTypeQFilter.toArray());
            periodTypeIdStr = periodTypeObj.getString("periodtype");
        }
        dto.setItemClassTypeField(baseEntity);
        Long periodTypeId = StringUtils.isNotBlank((CharSequence)periodTypeIdStr) ? Long.valueOf(Long.parseLong(periodTypeIdStr)) : null;
        boolean bl = flag = null == periodId || periodId == 0L;
        if (flag) {
            dto.setStartDate(startDate);
            dto.setEndDate(endDate);
        } else {
            dto.setStartPeriod(periodId);
        }
        Long businessPlanId = (Long)param.get("businessPlanId");
        dto.setBusinessPlan(businessPlanId);
        Long businessRuleId = (Long)param.get("businessRuleId");
        dto.setBusinessRule(businessRuleId);
        dto.setExecutionTime(new Date());
        dto.setDetailTime(System.currentTimeMillis());
        dto.setExecutionStatus(PASyncLogStatusEnum.NEW);
        String executionType = (String)param.get("executionType");
        dto.setExecutionType(StringUtils.isBlank((CharSequence)executionType) ? "1" : executionType);
        HashSet<Long> businessRuleIdSet = new HashSet<Long>(2);
        ArrayList<ExecutionLogEntryDTO> entryList = new ArrayList<ExecutionLogEntryDTO>(2);
        if (businessRuleId != 0L) {
            DynamicObject ruleObj = BusinessDataServiceHelper.loadSingleFromCache((Object)businessRuleId, (String)"pa_businessrule");
            PAExecutorHelper.buildEntryDtoList(entryList, periodTypeId, periodId, businessRuleId, ruleObj, notInPeriodRangeRuleNameBuilder, flag, null);
            businessRuleIdSet.add(businessRuleId);
        } else if (businessPlanId != 0L) {
            Map<Long, Boolean> stepRuleSummaryMap = PARuleHelper.getRuleSummarySwitchItemsByRuleGroupId(businessPlanId);
            DynamicObject planObj = BusinessDataServiceHelper.loadSingleFromCache((Object)businessPlanId, (String)"pa_businessplan");
            DynamicObjectCollection businessRuleEntry = planObj.getDynamicObjectCollection("pa_businessplan_rule");
            for (DynamicObject entryBusinessRule : businessRuleEntry) {
                Long entryBusinessRuleId = (Long)entryBusinessRule.get("rulenumber_id");
                DynamicObject ruleObj = BusinessDataServiceHelper.loadSingleFromCache((Object)entryBusinessRuleId, (String)"pa_businessrule");
                PAExecutorHelper.buildEntryDtoList(entryList, periodTypeId, periodId, entryBusinessRuleId, ruleObj, notInPeriodRangeRuleNameBuilder, flag, stepRuleSummaryMap);
                businessRuleIdSet.add(entryBusinessRuleId);
            }
        }
        dto.setEntry(entryList);
        dto.setAccountMap(PAExecutorHelper.explainAccountExpr(businessRuleIdSet, accountEntity, accountNumber, accountField, baseAccountFilter));
        return dto;
    }

    private static Map<Long, Set<Long>> explainAccountExpr(Set<Long> businessRuleIds, String accountEntity, String accountNumber, String accountFields, QFilter baseAccountFilter) {
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(businessRuleIds.size());
        QFilter idFilter = new QFilter("id", "in", businessRuleIds);
        DynamicObjectCollection objCol = QueryServiceHelper.query((String)"pa_businessrule", (String)"id,accountfilter_tag", (QFilter[])idFilter.toArray());
        HashMap<Long, QFilter> businessRuleAccountFilterMap = new HashMap<Long, QFilter>(businessRuleIds.size());
        if (objCol != null && !objCol.isEmpty()) {
            for (DynamicObject obj : objCol) {
                Long id = obj.getLong("id");
                String accountFilterStr = obj.getString("accountfilter_tag");
                if (accountFilterStr == null || accountFilterStr.isEmpty()) continue;
                QFilter accountFilter = PAExecutorHelper.getQFilterFromFilterCondition(accountFilterStr, accountEntity, accountNumber);
                if (accountFilter == null) {
                    businessRuleAccountFilterMap.put(id, baseAccountFilter);
                    continue;
                }
                if (baseAccountFilter == null) continue;
                accountFilter.and(baseAccountFilter);
                businessRuleAccountFilterMap.put(id, accountFilter);
            }
        }
        for (Long ruleId : businessRuleIds) {
            QFilter currentFilter = (QFilter)businessRuleAccountFilterMap.get(ruleId);
            if (currentFilter == null) {
                resultMap.put(ruleId, Collections.emptySet());
                continue;
            }
            try {
                DataSet currentAccountDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)accountEntity, (String)accountFields, (QFilter[])currentFilter.toArray(), (String)"id");
                Throwable throwable = null;
                try {
                    if (currentAccountDataSet == null || !currentAccountDataSet.hasNext()) {
                        resultMap.put(ruleId, Collections.singleton(-1L));
                        continue;
                    }
                    HashSet<Long> accountIdSet = new HashSet<Long>(4);
                    while (currentAccountDataSet.hasNext()) {
                        accountIdSet.add(currentAccountDataSet.next().getLong("id"));
                    }
                    resultMap.put(ruleId, accountIdSet);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (currentAccountDataSet == null) continue;
                    if (throwable != null) {
                        try {
                            currentAccountDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    currentAccountDataSet.close();
                }
            }
            catch (Exception exception) {
                logger.error("[FI-PA]ruleExecuteFormPlugin explainAccountExpr error", (Throwable)exception);
            }
        }
        return resultMap;
    }

    public static QFilter getQFilterFromFilterCondition(String filterJson, String accountEntity, String accountNumber) {
        if (StringUtils.isEmpty((CharSequence)filterJson) || StringUtils.isEmpty((CharSequence)accountEntity)) {
            return null;
        }
        String prefix = accountNumber + ".";
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        List filterRow = filterCondition.getFilterRow();
        for (SimpleFilterRow simpleFilterRow : filterRow) {
            String fieldName = simpleFilterRow.getFieldName();
            if (!fieldName.startsWith(prefix)) continue;
            fieldName = fieldName.replaceFirst(prefix, "");
            simpleFilterRow.setFieldName(fieldName);
        }
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)accountEntity), filterCondition);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    private static void buildEntryDtoList(List<ExecutionLogEntryDTO> entryList, Long periodTypeId, Long currentPeriodId, Long businessRuleId, DynamicObject ruleObj, StringBuilder notInPeriodRangeRuleNameBuilder, boolean flag, Map<Long, Boolean> stepRuleSummaryMap) {
        if (ruleObj != null) {
            String ruleName = ((OrmLocaleValue)ruleObj.get("name")).get((Object)Lang.get().toString());
            if ("C".equals(ruleObj.getString("status")) && EnableStatusEnum.enable.getCodeString().equals(ruleObj.getString("enable"))) {
                List<Long> periodRangeList;
                Long startPeriodId = (Long)ruleObj.get("startperiod_id");
                Long endPeriodId = (Long)ruleObj.get("endperiod_id");
                List<Long> list = periodRangeList = periodTypeId != null ? PALogHelper.getPeriodRangeListByDate(periodTypeId, BusinessDataServiceHelper.loadSingleFromCache((Object)startPeriodId, (String)"bd_period", (String)"begindate").getDate("begindate"), BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodId, (String)"bd_period", (String)"enddate").getDate("enddate")) : null;
                if (periodRangeList != null && periodRangeList.contains(currentPeriodId) || startPeriodId.equals(currentPeriodId) || endPeriodId.equals(currentPeriodId) || flag) {
                    DynamicObjectCollection dyCol = ruleObj.getDynamicObjectCollection("stepentry");
                    Object[] ruleIdList = dyCol.stream().filter(dy -> "B".equals(dy.getString("cardhandletype"))).map(dy -> dy.get("cardsharemodel_id")).toArray(Object[]::new);
                    Map ruleDyMap = BusinessDataServiceHelper.loadFromCache((Object[])ruleIdList, (String)"pa_sharerulenew");
                    Map<Long, BigDecimal> sendRateMap = ruleDyMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getBigDecimal("sendrate")));
                    for (DynamicObject entryObj : dyCol) {
                        Boolean summaryValue;
                        String handleType = (String)entryObj.get("cardhandletype");
                        Long ruleId = "A".equals(handleType) ? (Long)entryObj.get("cardderivationmodel_id") : (Long)entryObj.get("cardsharemodel_id");
                        String stepName = (String)entryObj.get("cardstepname");
                        BigDecimal sendRate = sendRateMap.get(ruleId);
                        boolean isSummary = true;
                        if (stepRuleSummaryMap != null && (summaryValue = stepRuleSummaryMap.get(ruleId)) != null) {
                            isSummary = summaryValue;
                        }
                        entryList.add(new ExecutionLogEntryDTO(handleType, ruleId, stepName, businessRuleId, isSummary, sendRate));
                    }
                } else {
                    notInPeriodRangeRuleNameBuilder.append(',').append(ruleName);
                }
            } else {
                notInPeriodRangeRuleNameBuilder.append(',').append(ruleName);
            }
        }
    }

    public static String getBaseEntityId(DynamicObject anaModel, String necessityDim) {
        if (anaModel == null || necessityDim == null) {
            return null;
        }
        DynamicObject dimension = PAExecutorHelper.getDimension(anaModel, necessityDim);
        if (dimension == null) {
            return null;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(dimension.getString("dimensiontype"));
        switch (dimType) {
            case PERIOD: 
            case DATABASE: {
                return dimension.getDynamicObject("dimensionsource").getString("number");
            }
            case ASSISTANTDATA: {
                return "bos_assistantdata_detail";
            }
        }
        return "";
    }

    public static DynamicObject getDimension(DynamicObject anaModel, String necessityDim) {
        if (anaModel == null || necessityDim == null) {
            return null;
        }
        DynamicObjectCollection dimEntryCol = anaModel.getDynamicObjectCollection("dimension_entry");
        long dimId = 0L;
        for (DynamicObject dyo : dimEntryCol) {
            if (!necessityDim.equals(dyo.getString("necessity_dim"))) continue;
            dimId = dyo.getLong("dimension_id");
            break;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"pa_dimension");
    }

    public static QFilter getBaseQFilter(DynamicObject anaModel, String necessityDim) {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (anaModel == null || necessityDim == null) {
            return qFilter;
        }
        DynamicObject dimension = PAExecutorHelper.getDimension(anaModel, necessityDim);
        if (dimension == null) {
            return qFilter;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(dimension.getString("dimensiontype"));
        if (DimensionTypeEnum.DATABASE == dimType) {
            String typeField = dimension.getString("typefield");
            Object groupId = dimension.get("group_id");
            if (kd.bos.util.StringUtils.isNotEmpty((String)typeField)) {
                qFilter = new QFilter(typeField, "=", groupId);
            }
        } else {
            Object groupId = dimension.get("assistantsource_id");
            qFilter = new QFilter("group", "=", groupId);
        }
        return qFilter;
    }
}

