/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.utils.CollectionUtils;

public class PAFilterHelper {
    private PAFilterHelper() {
    }

    public static QFilter dimensionTypeNotEqualsDateFilter() {
        return new QFilter("dimensiontype", "!=", (Object)DimensionTypeEnum.DATE.getCodeString());
    }

    public static QFilter[] splitQFilters(QFilter qFilter, String dimName, Object[] dimValues, int listMaxSize) {
        if (qFilter == null) {
            qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)dimName) || dimValues == null || dimValues.length == 0) {
            throw new KDBizException("dimName or dimValues is empty");
        }
        if (listMaxSize <= 1) {
            QFilter splitQFilter = new QFilter(dimName, "in", (Object)dimValues).and(qFilter);
            return new QFilter[]{splitQFilter};
        }
        List<Object[]> splitDimValues = CollectionUtils.splitArrayLimitSize(dimValues, listMaxSize);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(splitDimValues.size());
        for (Object[] splitDimValue : splitDimValues) {
            QFilter splitQFilter = new QFilter(dimName, "in", (Object)splitDimValue).and(qFilter);
            qFilters.add(splitQFilter);
        }
        return qFilters.toArray(new QFilter[0]);
    }
}

