/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.pa.dto.DataExecuteParameterDTO;
import kd.fi.pa.helper.PADimensionHelper;

public class PAIndexHelper {
    private static final Log logger = LogFactory.getLog(PAIndexHelper.class);

    public static DataExecuteParameterDTO getDataExecuteParameterByCurUser() {
        DataExecuteParameterDTO dataExecuteParameterDTO = new DataExecuteParameterDTO();
        Long systemId = (Long)QueryServiceHelper.queryPrimaryKeys((String)"pa_anasystemsetting", null, (String)"id", (int)1).stream().findFirst().orElseGet(() -> -1L);
        if (systemId <= 0L) {
            return dataExecuteParameterDTO;
        }
        dataExecuteParameterDTO.setSystemId(systemId);
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysismodel", (String)"id,dimension_entry,dimension_entry.dimension,dimension_entry.necessity_dim", (QFilter[])new QFilter("analysis_system", "=", (Object)systemId).toArray());
        if (model == null) {
            return dataExecuteParameterDTO;
        }
        dataExecuteParameterDTO.setModelId(model.getLong("id"));
        List permissionOrgIds = new ArrayList(8);
        long currentUserId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isSuperUser((long)currentUserId)) {
            permissionOrgIds = OrgUnitServiceHelper.getAllOrg((String)"15");
        } else {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)currentUserId, (String)"15", (String)"pa", (String)"pa_apphome_grid", (String)"47150e89000000ac");
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            if (!CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
                permissionOrgIds = hasPermOrgs;
            }
        }
        ArrayList<Long> orgList = new ArrayList<Long>(1);
        QFilter viewFilter = new QFilter("structure.view", "=", (Object)Long.valueOf("15")).and("id", "in", permissionOrgIds);
        String orderby = "structure.level asc,number asc";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.pa.helper.PAIndexHelper", (String)"bos_org", (String)"id", (QFilter[])viewFilter.toArray(), (String)orderby, (int)1);){
            for (Row row : ds) {
                orgList.add(row.getLong("id"));
            }
        }
        dataExecuteParameterDTO.setOrgIds(orgList);
        Tuple<String, Long> currentDatePeriodOfModel = PAIndexHelper.getCurrentDatePeriodOfModel(model);
        if (currentDatePeriodOfModel != null) {
            dataExecuteParameterDTO.setPeriodNumber((String)currentDatePeriodOfModel.item1);
            dataExecuteParameterDTO.setPeriod((Long)currentDatePeriodOfModel.item2);
        }
        return dataExecuteParameterDTO;
    }

    public static Tuple<String, Long> getCurrentDatePeriodOfModel(DynamicObject model) {
        if (model == null) {
            return null;
        }
        try {
            Long periodDimensionId = model.getDynamicObjectCollection("dimension_entry").stream().filter(dy -> "1".equals(dy.getString("necessity_dim"))).map(dy -> dy.getLong("dimension_id")).findFirst().orElseGet(() -> -1L);
            DynamicObject periodDimension = PADimensionHelper.loadDimension(periodDimensionId);
            if (periodDimension == null) {
                logger.error("\u5f53\u524d\u5206\u6790\u6a21\u578b\u4e0a\u7684\u4f1a\u8ba1\u671f\u95f4\u7ef4\u5ea6\u4e3a\u7a7a,\u5206\u6790\u6a21\u578bid\u4e3a:" + periodDimensionId);
                return null;
            }
            String periodNumber = periodDimension.getDynamicObject("dimensionsource").getString("number");
            Date now = new Date();
            QFilter periodFilter = null;
            switch (periodNumber) {
                case "bd_period": {
                    QFilter periodTypeFilter = PADimensionHelper.getDimensionTypeQFilter(periodDimension);
                    if (periodTypeFilter == null) {
                        logger.error("\u5f53\u524d\u4f1a\u8ba1\u671f\u95f4\u7ef4\u5ea6\u4e0a\u7684\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u4fe1\u606f\u4e0d\u5408\u6cd5,\u7ef4\u5ea6id\u4e3a:" + periodDimension.getLong("id"));
                        return null;
                    }
                    QFilter dateFilter = new QFilter("begindate", "<=", (Object)now).and("enddate", ">=", (Object)now);
                    periodFilter = periodTypeFilter.and(dateFilter);
                    break;
                }
                case "pa_analysisperiod": {
                    QFilter hierarchicalFilter = new QFilter("hierarchical", "=", (Object)"4");
                    QFilter dateFilter = new QFilter("startdate", "<=", (Object)now).and("enddate", ">=", (Object)now);
                    periodFilter = hierarchicalFilter.and(dateFilter);
                    break;
                }
            }
            if (periodFilter == null) {
                logger.error("\u5f53\u524d\u4f1a\u8ba1\u671f\u95f4\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
                return null;
            }
            DynamicObject period = QueryServiceHelper.queryOne((String)periodNumber, (String)"id", (QFilter[])periodFilter.toArray());
            if (period == null) {
                logger.error("\u5f53\u524d\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728,\u671f\u95f4\u6807\u8bc6\u4e3a:" + periodNumber + ",\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + periodFilter.toString());
                return null;
            }
            return new Tuple((Object)periodNumber, (Object)period.getLong("id"));
        }
        catch (Exception e) {
            logger.error("\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u83b7\u53d6\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
            return null;
        }
    }

    public static Map<String, List<DynamicObject>> getDataSyncSuccessAndFailedIdsByFilter(Long modelId) {
        QFilter modelFilter = new QFilter("analysismodel", "=", (Object)modelId);
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"2", "9"});
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pa_tasklog", (String)"id,status", (QFilter[])new QFilter[]{modelFilter, statusFilter});
        return dynamicObjectMap.values().stream().collect(Collectors.groupingBy(dy -> {
            String status = dy.getString("status");
            if ("2".equals(status)) {
                return "success";
            }
            return "failed";
        }));
    }

    public static Map<String, List<DynamicObject>> getRuleExecuteSuccessAndFailedIdsByFilter(Long anaSystemId, Long anaModelId, List<Long> orgIds, Long periodId) {
        QFilter systemFilter = new QFilter("analysis_system", "=", (Object)anaSystemId);
        QFilter modelFilter = new QFilter("analysis_model", "=", (Object)anaModelId);
        QFilter orgFilter = new QFilter("org_field", "in", orgIds);
        QFilter periodFilter = new QFilter("startperiod", "=", (Object)periodId);
        QFilter statusFilter = new QFilter("execution_status", "in", (Object)new String[]{"2", "9"});
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pa_executionlog", (String)"id,execution_status", (QFilter[])new QFilter[]{systemFilter, modelFilter, orgFilter, periodFilter, statusFilter});
        if (!CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
            return dynamicObjectMap.values().stream().collect(Collectors.groupingBy(dy -> {
                String status = dy.getString("execution_status");
                if ("2".equals(status)) {
                    return "success";
                }
                return "failed";
            }));
        }
        return new HashMap<String, List<DynamicObject>>();
    }
}

