/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.AdExecDetailLogDTO;
import kd.fi.pa.dto.AdExecutionLogDTO;
import kd.fi.pa.dto.BusinessExecutionParamDTO;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.dto.ExecutionLogEntryDTO;
import kd.fi.pa.dto.ExecutionResultAdjustEntryDTO;
import kd.fi.pa.dto.ExecutionResultEntryDTO;
import kd.fi.pa.dto.OffExecDetailLogDTO;
import kd.fi.pa.dto.RuleExecutionDetailLogDTO;
import kd.fi.pa.dto.RuleExecutionLogDTO;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.utils.DateUtil;
import org.apache.commons.lang.StringUtils;

public class PALogHelper {
    private static final String ALGO = PALogHelper.class.getName();
    private static final Log logger = LogFactory.getLog(PALogHelper.class);

    public static void genExecutionLogId(Collection<ExecutionLogDTO> executionLogList) {
        if (executionLogList == null || executionLogList.isEmpty()) {
            return;
        }
        long[] ids = DB.genLongIds((String)"pa_executionlog", (int)executionLogList.size());
        int i = 0;
        for (ExecutionLogDTO paExecutionLogDTO : executionLogList) {
            paExecutionLogDTO.setId(ids[i++]);
        }
    }

    public static void createResultEntry(ExecutionLogDTO executionLogDTO, boolean executeSuccess) {
        Long id = executionLogDTO.getId();
        ExecutionModeEnum executionMode = executionLogDTO.getExecutionMode();
        DynamicObject executionLog = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pa_executionlog");
        boolean result = PALogHelper.getResult(executionLog.getString("execution_status"));
        if (executionMode != null) {
            QFilter idFilter = new QFilter("execution_logpk", "=", (Object)id);
            block0 : switch (executionMode) {
                case execute: {
                    List<ExecutionLogEntryDTO> entryList = executionLogDTO.getEntry();
                    Object[] ruleLogFields = new String[]{"rule_pk", "execution_status"};
                    Map ruleCol = BusinessDataServiceHelper.loadFromCache((String)"pa_ruleexeclog", (String)StringUtils.join((Object[])ruleLogFields, (String)","), (QFilter[])new QFilter[]{idFilter}, (String)"id");
                    Map<Long, String> ruleMap = ruleCol.entrySet().stream().collect(Collectors.toMap(entry -> ((DynamicObject)entry.getValue()).getLong("rule_pk"), entry -> ((DynamicObject)entry.getValue()).getString("execution_status")));
                    ArrayList<ExecutionResultEntryDTO> resultEntryList = new ArrayList<ExecutionResultEntryDTO>(entryList.size());
                    for (ExecutionLogEntryDTO entryDto : entryList) {
                        Date executeTime = new Date();
                        Long ruleId = entryDto.getRuleId();
                        String ruleName = entryDto.getStepName();
                        Long businessRuleId = entryDto.getBelongBusinessRuleId();
                        PASyncLogStatusEnum paSyncLogStatusEnum = PASyncLogStatusEnum.getEnum(ruleMap.get(ruleId));
                        ExecutionResultEntryDTO resultEntry = new ExecutionResultEntryDTO(businessRuleId, ruleId, ruleName, executeTime, paSyncLogStatusEnum);
                        resultEntryList.add(resultEntry);
                        if (PASyncLogStatusEnum.FAILURE != paSyncLogStatusEnum) continue;
                        break;
                    }
                    PALogHelper.createResultRuleEntry(id, resultEntryList, executionLog.getLong("business_plan_id"), result);
                    break;
                }
                case adjust: {
                    List<Long> businessIdList = executionLogDTO.getBusinessIdList();
                    ArrayList<ExecutionResultAdjustEntryDTO> adjustEntryDTOList = new ArrayList<ExecutionResultAdjustEntryDTO>(businessIdList.size());
                    for (Long businessId : businessIdList) {
                        ExecutionResultAdjustEntryDTO adjustEntryDTO = new ExecutionResultAdjustEntryDTO(businessId);
                        adjustEntryDTOList.add(adjustEntryDTO);
                    }
                    PALogHelper.createResultAdjustEntry(id, adjustEntryDTOList);
                    break;
                }
                case writeOff: {
                    QFilter filter;
                    DynamicObject log;
                    Long logRuleEntryId = executionLogDTO.getLogRuleEntryId();
                    if (!executeSuccess || logRuleEntryId == null || (log = BusinessDataServiceHelper.loadSingle((String)"pa_executionlog", (String)"entryentity,entryentity.entry_writeoffstatus", (QFilter[])(filter = new QFilter("entryentity.id", "=", (Object)logRuleEntryId)).toArray())) == null) break;
                    DynamicObjectCollection dyCol = log.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : dyCol) {
                        Long currentEntryId = dynamicObject.getLong("id");
                        if (logRuleEntryId.compareTo(currentEntryId) != 0) continue;
                        dynamicObject.set("entry_writeoffstatus", (Object)"4");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    public static Object[] createExecutionLog(Collection<ExecutionLogDTO> executionLogList) {
        if (executionLogList == null || executionLogList.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(executionLogList.size());
        for (ExecutionLogDTO executionLog : executionLogList) {
            DynamicObject dynamicObj = BusinessDataServiceHelper.newDynamicObject((String)"pa_executionlog");
            if (executionLog.getId() != null) {
                dynamicObj.set("id", (Object)executionLog.getId());
            }
            dynamicObj.set("number", (Object)PALogHelper.getNumber(dynamicObj));
            dynamicObj.set("analysis_system", (Object)executionLog.getAnalysisSystem());
            dynamicObj.set("analysis_model", (Object)executionLog.getAnalysisModel());
            if (executionLog.getOrgIds() != null && executionLog.getOrgIds().length == 1) {
                dynamicObj.set("org_field", (Object)executionLog.getOrgIds()[0]);
            }
            DynamicObjectCollection execOrgCol = dynamicObj.getDynamicObjectCollection("execorg");
            for (Long execOrgId : executionLog.getOrgIds()) {
                DynamicObject tempExecOrgObj = new DynamicObject(execOrgCol.getDynamicObjectType());
                tempExecOrgObj.set("fbasedataid_id", (Object)execOrgId);
                execOrgCol.add((Object)tempExecOrgObj);
            }
            dynamicObj.set("execution_mode", (Object)executionLog.getExecutionMode().getCodeString());
            dynamicObj.set("itemclasstypefield", (Object)executionLog.getItemClassTypeField());
            dynamicObj.set("startperiod", (Object)executionLog.getStartPeriod());
            dynamicObj.set("range_startdate", (Object)executionLog.getStartDate());
            dynamicObj.set("range_enddate", executionLog.getEndDate() == null ? null : DateUtil.getLastDay(executionLog.getEndDate(), 1));
            dynamicObj.set("business_plan", (Object)executionLog.getBusinessPlan());
            dynamicObj.set("business_rule", (Object)executionLog.getBusinessRule());
            dynamicObj.set("execution_time", (Object)executionLog.getExecutionTime());
            dynamicObj.set("detailtime", (Object)executionLog.getDetailTime());
            dynamicObj.set("execution_status", (Object)executionLog.getExecutionStatus().getCodeString());
            dynamicObj.set("execution_type", (Object)executionLog.getExecutionType());
            dynamicObj.set("remark", (Object)executionLog.getRemark());
            result.add(dynamicObj);
        }
        if (!result.isEmpty()) {
            return SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        }
        return null;
    }

    public static void createResultRuleEntry(Object id, List<ExecutionResultEntryDTO> resultEntryList, Long businessPlanId, boolean result) {
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_executionlog");
        if (log != null) {
            DynamicObjectCollection dyCol = log.getDynamicObjectCollection("entryentity");
            int startSeq = dyCol.size();
            for (ExecutionResultEntryDTO resultEntryDTO : resultEntryList) {
                DynamicObject ruleEntryObj = new DynamicObject(dyCol.getDynamicObjectType());
                ruleEntryObj.set("seq", (Object)startSeq);
                ruleEntryObj.set("entry_businessplan", (Object)businessPlanId);
                ruleEntryObj.set("entry_businessrule", (Object)resultEntryDTO.getBusinessRuleId());
                ruleEntryObj.set("rule_pk", (Object)resultEntryDTO.getRuleId());
                ruleEntryObj.set("stepname", (Object)resultEntryDTO.getStepName());
                ruleEntryObj.set("entry_executiontime", (Object)resultEntryDTO.getExecuteTime());
                if (PASyncLogStatusEnum.SUCCESS == resultEntryDTO.getExecutionStatus() && !result) {
                    ruleEntryObj.set("entry_executionstatus", (Object)PASyncLogStatusEnum.NO_EFFECTIVE.getCodeString());
                } else {
                    ruleEntryObj.set("entry_executionstatus", (Object)resultEntryDTO.getExecutionStatus().getCodeString());
                }
                dyCol.add((Object)ruleEntryObj);
                ++startSeq;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
    }

    public static void createResultAdjustEntry(Object id, List<ExecutionResultAdjustEntryDTO> resultAdjustEntryList) {
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_executionlog");
        if (log != null) {
            DynamicObjectCollection dyCol = log.getDynamicObjectCollection("adjustentry");
            int startSeq = dyCol.size();
            for (ExecutionResultAdjustEntryDTO adjustEntryDTO : resultAdjustEntryList) {
                DynamicObject adjustEntryObj = new DynamicObject(dyCol.getDynamicObjectType());
                adjustEntryObj.set("seq", (Object)startSeq);
                adjustEntryObj.set("adjustid", (Object)adjustEntryDTO.getAdjustId());
                dyCol.add((Object)adjustEntryObj);
                ++startSeq;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
    }

    public static void updateExecuteLogStatus(Object id, String status) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_executionlog");
        if (dynamicObject != null) {
            dynamicObject.set("execution_status", (Object)status);
            if (PASyncLogStatusEnum.SUCCESS.getCodeString().equalsIgnoreCase(status)) {
                dynamicObject.set("end_exectasktime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void updateExecuteLogStatus(Object id, String status, Long detailTime) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_executionlog");
        if (dynamicObject != null) {
            dynamicObject.set("execution_status", (Object)status);
            dynamicObject.set("detailtime", (Object)detailTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void updateExecuteLogRemark(Object id, String remark, String remarkDetail) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_executionlog");
        if (dynamicObject != null) {
            dynamicObject.set("remark", (Object)(remark != null && remark.length() > 255 ? remark.substring(0, 255) : remark));
            dynamicObject.set("remark_tag", (Object)remarkDetail);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void updateExecuteLogStatus(Object id, String status, String remark, String remarkDetail) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_executionlog");
        if (dynamicObject != null) {
            dynamicObject.set("execution_status", (Object)status);
            dynamicObject.set("remark", (Object)(remark != null && remark.length() > 255 ? remark.substring(0, 255) : remark));
            dynamicObject.set("remark_tag", (Object)remarkDetail);
            if (PASyncLogStatusEnum.SUCCESS.getCodeString().equalsIgnoreCase(status)) {
                dynamicObject.set("end_exectasktime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static BusinessExecutionParamDTO getExecutionLogCondition(Long logId) {
        BusinessExecutionParamDTO resultDTO = new BusinessExecutionParamDTO();
        DynamicObject executionLog = BusinessDataServiceHelper.loadSingleFromCache((Object)logId, (String)"pa_executionlog");
        if (executionLog != null) {
            resultDTO.setOrg(PALogHelper.getFilterId(executionLog, "org_field"));
            resultDTO.setOrgIds(((DynamicObjectCollection)executionLog.get("execorg")).stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toCollection(ArrayList::new)));
            resultDTO.setPeriod(PALogHelper.getFilterId(executionLog, "startperiod"));
            resultDTO.setStartDate(executionLog.getDate("range_startdate"));
            Date endData = executionLog.getDate("range_enddate");
            if (endData != null) {
                resultDTO.setEndDate(DateUtil.getNextDay(endData, 1));
            }
        }
        return resultDTO;
    }

    public static List<Object> getExecLogIdList(Long modelId, Long businessRuleId) {
        QFilter planModelFilter = new QFilter("analysismodel", "=", (Object)modelId);
        QFilter planStatusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter planRuleFilter = new QFilter("pa_businessplan_rule.rulenumber", "=", (Object)businessRuleId);
        DynamicObject planDy = BusinessDataServiceHelper.loadSingle((String)"pa_businessplan", (String)"id", (QFilter[])new QFilter[]{planModelFilter, planStatusFilter, planRuleFilter});
        QFilter logModelFilter = new QFilter("analysis_model", "=", (Object)modelId);
        QFilter logStatusFilter = new QFilter("execution_status", "=", (Object)PASyncLogStatusEnum.SUCCESS.getCodeString());
        QFilter logRuleFilter = new QFilter("business_rule", "=", (Object)businessRuleId);
        QFilter logPlanFilter = null;
        if (planDy != null) {
            Long businessPlanId = planDy.getLong("id");
            logPlanFilter = new QFilter("business_plan", "=", (Object)businessPlanId);
        }
        QFilter logFilter = logPlanFilter == null ? logModelFilter.and(logStatusFilter).and(logRuleFilter) : logModelFilter.and(logStatusFilter).and(logPlanFilter.or(logRuleFilter));
        return QueryServiceHelper.queryPrimaryKeys((String)"pa_executionlog", (QFilter[])new QFilter[]{logFilter}, null, (int)-1);
    }

    public static void genExecutionRuleLogId(Collection<RuleExecutionLogDTO> ruleExecutionLogList) {
        if (ruleExecutionLogList == null || ruleExecutionLogList.isEmpty()) {
            return;
        }
        long[] ids = DB.genLongIds((String)"pa_ruleexeclog", (int)ruleExecutionLogList.size());
        int i = 0;
        for (RuleExecutionLogDTO paRuleExecutionLogDTO : ruleExecutionLogList) {
            paRuleExecutionLogDTO.setId(ids[i++]);
        }
    }

    public static void genExecutionAdjustLogId(Collection<AdExecutionLogDTO> adjustExecutionLogList) {
        if (adjustExecutionLogList == null || adjustExecutionLogList.isEmpty()) {
            return;
        }
        long[] ids = DB.genLongIds((String)"pa_adexeclog", (int)adjustExecutionLogList.size());
        int i = 0;
        for (AdExecutionLogDTO paAdjustExecutionLogDTO : adjustExecutionLogList) {
            paAdjustExecutionLogDTO.setId(ids[i++]);
        }
    }

    public static Object[] createRuleExecutionLog(Collection<RuleExecutionLogDTO> ruleExecutionLogList) {
        if (ruleExecutionLogList == null || ruleExecutionLogList.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(ruleExecutionLogList.size());
        for (RuleExecutionLogDTO ruleExecutionLog : ruleExecutionLogList) {
            DynamicObject dynamicObj = BusinessDataServiceHelper.newDynamicObject((String)"pa_ruleexeclog");
            dynamicObj.set("execution_logpk", (Object)ruleExecutionLog.getExecutionLogId());
            dynamicObj.set("rule_type", (Object)ruleExecutionLog.getRuleType());
            dynamicObj.set("rule_pk", (Object)ruleExecutionLog.getRuleId());
            dynamicObj.set("execution_status", (Object)ruleExecutionLog.getExecutionStatus().getCodeString());
            dynamicObj.set("execution_time", (Object)ruleExecutionLog.getExecutionTime());
            dynamicObj.set("detailtime", (Object)ruleExecutionLog.getDetailTime());
            dynamicObj.set("remark", (Object)ruleExecutionLog.getRemark());
            dynamicObj.set("sendrate", (Object)ruleExecutionLog.getSendRate());
            if (ruleExecutionLog.getId() != null) {
                dynamicObj.set("id", (Object)ruleExecutionLog.getId());
            }
            result.add(dynamicObj);
        }
        if (!result.isEmpty()) {
            return SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        }
        return null;
    }

    public static void createAdExecutionSingleLog(AdExecutionLogDTO dto) {
        String remarkDetail;
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"pa_adexeclog");
        if (dto.getId() != null) {
            obj.set("id", (Object)dto.getId());
        }
        obj.set("execution_logpk", (Object)dto.getExecutionLogPk());
        obj.set("ad_pk", (Object)dto.getAdjustPk());
        obj.set("execution_status", (Object)dto.getStatus().getCodeString());
        obj.set("execution_time", (Object)dto.getExecutionTime());
        obj.set("detailtime", (Object)dto.getDetailTime());
        String remark = dto.getRemark();
        if (remark != null) {
            obj.set("remark", (Object)(remark.length() > 255 ? remark.substring(0, 255) : remark));
        }
        if ((remarkDetail = dto.getRemarkDetail()) != null) {
            obj.set("remark_tag", (Object)dto.getRemarkDetail());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public static Object[] createAdjustExecutionLog(Collection<AdExecutionLogDTO> adjustExecutionLogList) {
        if (adjustExecutionLogList == null || adjustExecutionLogList.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(adjustExecutionLogList.size());
        for (AdExecutionLogDTO adExecutionLogDTO : adjustExecutionLogList) {
            DynamicObject dynamicObj = BusinessDataServiceHelper.newDynamicObject((String)"pa_adexeclog");
            dynamicObj.set("execution_logpk", (Object)adExecutionLogDTO.getExecutionLogPk());
            dynamicObj.set("ad_pk", (Object)adExecutionLogDTO.getAdjustPk());
            dynamicObj.set("execution_status", (Object)adExecutionLogDTO.getStatus().getCodeString());
            dynamicObj.set("execution_time", (Object)adExecutionLogDTO.getExecutionTime());
            dynamicObj.set("detailtime", (Object)adExecutionLogDTO.getDetailTime());
            dynamicObj.set("remark", (Object)adExecutionLogDTO.getRemark());
            if (adExecutionLogDTO.getId() != null) {
                dynamicObj.set("id", (Object)adExecutionLogDTO.getId());
            }
            result.add(dynamicObj);
        }
        if (!result.isEmpty()) {
            return SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        }
        return null;
    }

    public static void updateExecuteRuleLogStatus(Object id, String status) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_ruleexeclog");
        if (dynamicObject != null) {
            dynamicObject.set("execution_status", (Object)status);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void updateExecuteRuleLogStatus(Object id, String status, Long detailTime) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_ruleexeclog");
        if (dynamicObject != null) {
            dynamicObject.set("execution_status", (Object)status);
            dynamicObject.set("detailtime", (Object)detailTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void updateExecuteAdjustLogStatus(Object id, String status) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_adexeclog");
        if (dynamicObject != null) {
            dynamicObject.set("execution_status", (Object)status);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void updateExecuteAdjustLogStatus(Object id, String status, Long detailTime) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_adexeclog");
        if (dynamicObject != null) {
            dynamicObject.set("execution_status", (Object)status);
            dynamicObject.set("detailtime", (Object)detailTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void batchUpdateExecuteRuleLogStatus(Object[] logIds, String status) {
        DynamicObject[] dynamicObjects;
        int pageSize = 10000;
        int pageIndex = 0;
        QFilter idFilter = new QFilter("id", "in", (Object)logIds);
        String selectFields = StringUtils.join((Object[])new String[]{"id", "execution_status"}, (String)",");
        String orderBy = "id";
        while ((dynamicObjects = BusinessDataServiceHelper.load((String)"pa_ruleexeclog", (String)selectFields, (QFilter[])new QFilter[]{idFilter}, (String)orderBy, (int)pageIndex, (int)pageSize)) != null && dynamicObjects.length != 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("execution_status", (Object)status);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            ++pageIndex;
        }
    }

    /*
     * Exception decompiling
     */
    public static Map<Long, Long> getRuleDetailMappingMap(Set<Long> detailIdSet, Long ruleId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void createRuleExecutionDetailLog(RuleExecutionDetailLogDTO ruleExecutionDetailLogDTO) {
        Long executionLogId = ruleExecutionDetailLogDTO.getExecutionLogId();
        Long ruleExecutionLogId = ruleExecutionDetailLogDTO.getRuleExecutionLogId();
        Map<Long, List<Long>> sourceAndTargetMapping = ruleExecutionDetailLogDTO.getSourceAndTargetMapping();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(sourceAndTargetMapping.size());
        for (Map.Entry<Long, List<Long>> entry : sourceAndTargetMapping.entrySet()) {
            Long sourceId = entry.getKey();
            List<Long> targetIdList = entry.getValue();
            if (targetIdList == null || targetIdList.isEmpty()) continue;
            for (Long targetId : targetIdList) {
                DynamicObject dynamicObj = BusinessDataServiceHelper.newDynamicObject((String)"pa_ruleexecdetail");
                dynamicObj.set("execution_logpk", (Object)executionLogId);
                dynamicObj.set("rule_execution_logpk", (Object)ruleExecutionLogId);
                dynamicObj.set("source_pk", (Object)sourceId);
                dynamicObj.set("target_pk", (Object)targetId);
                result.add(dynamicObj);
            }
        }
        if (!result.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        }
    }

    public static void createAdExecDetailLogs(Collection<AdExecDetailLogDTO> dataCol) {
        if (dataCol == null || dataCol.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(dataCol.size());
        for (AdExecDetailLogDTO dto : dataCol) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"pa_adexecdetail");
            if (dto.getId() != null) {
                obj.set("id", (Object)dto.getId());
            }
            obj.set("execution_logpk", (Object)dto.getExecutionLogPk());
            obj.set("ad_execution_logpk", (Object)dto.getAdExecutionLogPk());
            obj.set("source_pk", (Object)dto.getSourcePk());
            obj.set("target_pk", (Object)dto.getTargetPk());
            result.add(obj);
        }
        if (!result.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        }
    }

    public static void createOffExecDetailLogs(Collection<OffExecDetailLogDTO> dataCol) {
        if (dataCol == null || dataCol.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(dataCol.size());
        for (OffExecDetailLogDTO dto : dataCol) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"pa_offexecdetail");
            if (dto.getId() != null) {
                obj.set("id", (Object)dto.getId());
            }
            obj.set("execution_logpk", (Object)dto.getExecutionLogPk());
            obj.set("source_pk", (Object)dto.getSourcePk());
            obj.set("target_pk", (Object)dto.getTargetPk());
            result.add(obj);
        }
        if (!result.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        }
    }

    private static Long getFilterId(DynamicObject executionLog, String entityName) {
        DynamicObject obj = (DynamicObject)executionLog.get(entityName);
        if (obj != null) {
            return (Long)obj.get("id");
        }
        return null;
    }

    public static String getNumber(DynamicObject dynamicObj) {
        return CodeRuleServiceHelper.getNumber((String)dynamicObj.getDataEntityType().getName(), (DynamicObject)dynamicObj, null);
    }

    public static boolean getResult(String status) {
        PASyncLogStatusEnum paSyncLogStatusEnum = PASyncLogStatusEnum.getEnum(status);
        if (paSyncLogStatusEnum != null) {
            return paSyncLogStatusEnum == PASyncLogStatusEnum.SUCCESS;
        }
        return false;
    }

    public static List<Long> getPeriodRangeListByDate(Long periodType, Date startPeriodDate, Date endPeriodDate) {
        QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType).and(new QFilter("begindate", ">=", (Object)startPeriodDate)).and(new QFilter("enddate", "<=", (Object)endPeriodDate));
        List periodIdObjList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])periodFilter.toArray(), (String)"begindate", (int)-1);
        if (!periodIdObjList.isEmpty()) {
            ArrayList<Long> periodIdList = new ArrayList<Long>(periodIdObjList.size());
            periodIdObjList.forEach(obj -> periodIdList.add(Long.valueOf(String.valueOf(obj))));
            return periodIdList;
        }
        return null;
    }
}

