/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.dto.PAMappingDimensionDTO;
import kd.fi.pa.dto.PAMappingDimensionQResultDTO;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.RelationShipMappingDimensionEnum;
import kd.fi.pa.utils.CRC32CodeUtils;

public class PAMappingRelationShipDataHelper {
    private static final Log logger = LogFactory.getLog(PAMappingRelationShipDataHelper.class);
    public static final String ASST_DATA_KEY = "bos_assistantdata_detail";

    public static List<PAMappingDimensionDTO> getDimensionList(IDataModel model, RelationShipMappingDimensionEnum dimensionEnum) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)model.getDataEntityType().getProperty(dimensionEnum.getCode());
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObject entity = model.getDataEntity();
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)entity);
        return rows.stream().map(row -> PAMappingRelationShipDataHelper.buildDimMappingDTO(dimensionEnum.getCode(), (DynamicObject)basedataProp.getValue(row))).collect(Collectors.toList());
    }

    public static DynamicObjectCollection queryMappingByAnaSystem(Object ... anaSystemIds) {
        return QueryServiceHelper.query((String)"pa_mappingrelationship", (String)"id,anasystem", (QFilter[])new QFilter("anasystem", "in", (Object)anaSystemIds).toArray(), null);
    }

    private static PAMappingDimensionDTO buildDimMappingDTO(String dimNumber, DynamicObject dimDynamicObject) {
        PAMappingDimensionDTO dimensionDTO = new PAMappingDimensionDTO();
        dimensionDTO.setPkId(dimDynamicObject.getLong("id"));
        dimensionDTO.setNumber(dimDynamicObject.getString("number"));
        dimensionDTO.setName(dimDynamicObject.getString("name"));
        dimensionDTO.setDimensionType(RelationShipMappingDimensionEnum.getEnumByCode(dimNumber));
        String dimensionType = dimDynamicObject.getString("dimensiontype");
        switch (DimensionTypeEnum.getEnum(dimensionType)) {
            case DATABASE: {
                dimensionDTO.setType(dimensionType);
                dimensionDTO.setBaseDataSourceNumber(dimDynamicObject.getDynamicObject("dimensionsource").getString("number"));
                break;
            }
            case ASSISTANTDATA: {
                dimensionDTO.setType(dimensionType);
                dimensionDTO.setBaseDataSourceNumber(ASST_DATA_KEY);
                dimensionDTO.setAssistantDataTypeId(dimDynamicObject.getDynamicObject("assistantsource").getLong("id"));
                break;
            }
            case OTHER: {
                dimensionDTO.setType(dimensionType);
            }
        }
        return dimensionDTO;
    }

    public static PAMappingDimensionQResultDTO queryOneDimMappingBySourceDims(Long mappingRelationshipId, Map<String, Object> sourceDimMappingMap) {
        HashMap<Long, Map<String, Object>> sourceDimMappingMapMap = new HashMap<Long, Map<String, Object>>();
        sourceDimMappingMapMap.put(0L, sourceDimMappingMap);
        return PAMappingRelationShipDataHelper.queryDimMappingBySourceDims(mappingRelationshipId, sourceDimMappingMapMap).get(0);
    }

    public static List<PAMappingDimensionQResultDTO> queryDimMappingBySourceDims(Long mappingRelationshipId, Map<Long, Map<String, Object>> sourceDimMappingMapMap) {
        DynamicObject dimMappingScheme = PAMappingRelationShipDataHelper.validateMappingSchema(mappingRelationshipId, sourceDimMappingMapMap);
        List<PAMappingDimensionDTO> sourceDimMappingDTOs = PAMappingRelationShipDataHelper.getMappingDimensionDTOsBySchema(dimMappingScheme, RelationShipMappingDimensionEnum.SOURCE.getCode());
        List<PAMappingDimensionDTO> targetDimMappingDTOs = PAMappingRelationShipDataHelper.getMappingDimensionDTOsBySchema(dimMappingScheme, RelationShipMappingDimensionEnum.TARGET.getCode());
        Map<Long, String> sourceDimJsonMap = PAMappingRelationShipDataHelper.transferSourceDimToJsonMap(sourceDimMappingMapMap, sourceDimMappingDTOs);
        List sourceDimJsonCrc32List = sourceDimJsonMap.values().stream().map(sourceDimJson -> CRC32CodeUtils.encode(sourceDimJson.getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
        QFilter schemaIdFilter = new QFilter("id", "=", (Object)mappingRelationshipId);
        QFilter CRC32Filter = new QFilter("entryentity.sourcedimcrc", "in", sourceDimJsonCrc32List);
        QFilter sourceDimFilter = new QFilter("entryentity.sourcedimtext", "in", sourceDimJsonMap.values());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"pa_mappingrelationship", (String)"entryentity.sourcedimtext,entryentity.targetdimtext", (QFilter[])new QFilter[]{schemaIdFilter, CRC32Filter, sourceDimFilter});
        return PAMappingRelationShipDataHelper.buildMappingDimensionQResultDTOs(dynamicObjects, sourceDimJsonMap, sourceDimMappingDTOs, targetDimMappingDTOs, dimMappingScheme.getString("number"));
    }

    private static DynamicObject validateMappingSchema(Long mappingRelationshipId, Map<Long, Map<String, Object>> sourceDimMappingMapList) {
        if (mappingRelationshipId == null || mappingRelationshipId <= 0L) {
            logger.error("\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e3b\u952eid\u4e0d\u5408\u6cd5,mappingRelationshipId : " + mappingRelationshipId);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e3b\u952eid\u4e0d\u5408\u6cd5.", (String)"PAMappingRelationShipDataHelper_0", (String)"fi-pa-common", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(sourceDimMappingMapList)) {
            logger.error("\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u6e90\u7ef4\u5ea6\u53c2\u6570\u4e0d\u5408\u6cd5,sourceDimMappingMap : " + sourceDimMappingMapList);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u6e90\u7ef4\u5ea6\u53c2\u6570\u4e0d\u5408\u6cd5.", (String)"PAMappingRelationShipDataHelper_1", (String)"fi-pa-common", (Object[])new Object[0]));
        }
        DynamicObject dimMappingScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_mappingrelationship", (String)"id,number,sourcedim,targetdim", (QFilter[])new QFilter("id", "=", (Object)mappingRelationshipId).toArray());
        if (dimMappingScheme == null) {
            logger.error("\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u65b9\u6848\u4e0d\u5b58\u5728,mappingRelationshipId : " + mappingRelationshipId);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u65b9\u6848\u4e0d\u5b58\u5728.", (String)"PAMappingRelationShipDataHelper_2", (String)"fi-pa-common", (Object[])new Object[0]));
        }
        return dimMappingScheme;
    }

    private static List<PAMappingDimensionDTO> getMappingDimensionDTOsBySchema(DynamicObject dimMappingScheme, String dimensionCode) {
        return dimMappingScheme.getDynamicObjectCollection(dimensionCode).stream().map(sourceDim -> PAMappingRelationShipDataHelper.buildDimMappingDTO(dimensionCode, sourceDim.getDynamicObject("fbasedataid"))).collect(Collectors.toList());
    }

    private static Map<Long, String> transferSourceDimToJsonMap(Map<Long, Map<String, Object>> sourceDimMappingMapMap, List<PAMappingDimensionDTO> sourceDimMappingDTOs) {
        LinkedHashMap<Long, String> sourceDimJsonToModelIdMap = new LinkedHashMap<Long, String>(sourceDimMappingMapMap.size());
        for (Map.Entry<Long, Map<String, Object>> longMapEntry : sourceDimMappingMapMap.entrySet()) {
            Long modelId = longMapEntry.getKey();
            Map<String, Object> sourceDimMappingMap = longMapEntry.getValue();
            LinkedHashMap<String, Object> sourceDimJsonMapWithDefaultValue = new LinkedHashMap<String, Object>(sourceDimMappingDTOs.size());
            for (PAMappingDimensionDTO sourceDimMappingDTO : sourceDimMappingDTOs) {
                String number = sourceDimMappingDTO.getNumber();
                String type = sourceDimMappingDTO.getType();
                DimensionTypeEnum anEnum = DimensionTypeEnum.getEnum(type);
                Object value = sourceDimMappingMap.get(number);
                if (DimensionTypeEnum.DATABASE == anEnum || DimensionTypeEnum.ASSISTANTDATA == anEnum) {
                    sourceDimJsonMapWithDefaultValue.put(number, value == null ? Long.valueOf(0L) : value);
                    continue;
                }
                sourceDimJsonMapWithDefaultValue.put(number, value == null ? "" : value);
            }
            sourceDimJsonToModelIdMap.put(modelId, JSON.toJSONString(sourceDimJsonMapWithDefaultValue));
        }
        return sourceDimJsonToModelIdMap;
    }

    private static List<PAMappingDimensionQResultDTO> buildMappingDimensionQResultDTOs(DynamicObjectCollection dynamicObjects, Map<Long, String> sourceDimJsonMap, List<PAMappingDimensionDTO> sourceDimMappingDTOs, List<PAMappingDimensionDTO> targetDimMappingDTOs, String schemaNumber) {
        ArrayList<PAMappingDimensionQResultDTO> paMappingDimensionQResultDTOS = new ArrayList<PAMappingDimensionQResultDTO>(sourceDimJsonMap.size());
        Map<String, String> sourceToTargetJsonMap = dynamicObjects.stream().collect(Collectors.toMap(entry -> entry.getString("entryentity.sourcedimtext"), entry -> entry.getString("entryentity.targetdimtext")));
        LinkedHashSet<Long> existMappingModelIds = new LinkedHashSet<Long>(sourceDimJsonMap.size());
        LinkedHashSet<Long> notExistMappingModelIds = new LinkedHashSet<Long>(sourceDimJsonMap.size());
        for (Map.Entry<Long, String> longStringEntry : sourceDimJsonMap.entrySet()) {
            PAMappingDimensionQResultDTO dimensionQResultDTO;
            Long modelId = longStringEntry.getKey();
            String sourceDimJson = longStringEntry.getValue();
            String targetDimJson = sourceToTargetJsonMap.get(sourceDimJson);
            if (StringUtils.isNotBlank((CharSequence)targetDimJson)) {
                existMappingModelIds.add(modelId);
                dimensionQResultDTO = new PAMappingDimensionQResultDTO(modelId, true, ResManager.loadKDString((String)"\u6210\u529f", (String)"PAMappingRelationShipDataHelper_3", (String)"fi-pa-common", (Object[])new Object[0]));
                dimensionQResultDTO.setTargetDimensionDataMap((Map)JSON.parseObject((String)targetDimJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]));
            } else {
                notExistMappingModelIds.add(modelId);
                dimensionQResultDTO = new PAMappingDimensionQResultDTO(modelId, false, ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728", (String)"PAMappingRelationShipDataHelper_4", (String)"fi-pa-common", (Object[])new Object[0]));
            }
            dimensionQResultDTO.setSourceDimensionDTOs(sourceDimMappingDTOs);
            dimensionQResultDTO.setTargetDimensionDTOs(targetDimMappingDTOs);
            dimensionQResultDTO.setSourceDimensionDataMap((Map)JSON.parseObject((String)sourceDimJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]));
            paMappingDimensionQResultDTOS.add(dimensionQResultDTO);
        }
        logger.error(String.format("\u6620\u5c04\u65b9\u6848\u6807\u8bc6\u4e3a : %s\u4e2d\u76ee\u6807\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u5b58\u5728\u5bf9\u5e94\u7684\u6a21\u578bId\u4e3a: %s", schemaNumber, existMappingModelIds));
        logger.error(String.format("\u6620\u5c04\u65b9\u6848\u6807\u8bc6\u4e3a : %s\u4e2d\u76ee\u6807\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6a21\u578bId\u4e3a: %s", schemaNumber, notExistMappingModelIds));
        return paMappingDimensionQResultDTOS;
    }
}

