/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.pa.enums.MeasureTypeEnum;

public class PAMeasureHelper {
    public static DynamicObject[] loadMeasure(Object[] measureIds) {
        Map measureObj = BusinessDataServiceHelper.loadFromCache((Object[])measureIds, (String)"pa_measure");
        DynamicObject[] results = measureObj.values().toArray(new DynamicObject[measureObj.size()]);
        return results;
    }

    public static boolean isDefaultPresetMeasure(Object measureId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_measure", (String)"isdefault", (QFilter[])new QFilter("id", "=", measureId).toArray());
        if (dynamicObject == null) {
            return false;
        }
        return "true".equals(dynamicObject.getString("isdefault"));
    }

    public static DynamicObjectCollection queryMeasureByAnaSystem(Object ... anaSystemIds) {
        QFilter systemIdFilter = new QFilter("system", "in", (Object)anaSystemIds);
        QFilter isDefaultFilter = new QFilter("isdefault", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.query((String)"pa_measure", (String)"id,system", (QFilter[])new QFilter[]{systemIdFilter, isDefaultFilter}, null);
    }

    public static void deleteMeasureByAnaSystemIds(Object ... anaSystemIds) {
        DeleteServiceHelper.delete((String)"pa_measure", (QFilter[])new QFilter("system", "in", (Object)anaSystemIds).toArray());
    }

    public static int getMeasureScale(Long systemId, String measureNumber) {
        int scale = 2;
        Map<String, Integer> measureScaleMap = PAMeasureHelper.getMeasureScaleMap(systemId, Collections.singletonList(measureNumber));
        if (measureScaleMap.containsKey(measureNumber)) {
            scale = measureScaleMap.get(measureNumber);
        }
        return scale;
    }

    public static Map<String, Integer> getMeasureScaleMap(Long systemId, List<String> measureNumberList) {
        QFilter systemFilter = new QFilter("system", "=", (Object)systemId);
        QFilter numberFilter = new QFilter("number", "in", measureNumberList);
        Object[] measures = BusinessDataServiceHelper.load((String)"pa_measure", (String)"number,precision,measuretype,measure", (QFilter[])new QFilter[]{systemFilter, numberFilter});
        HashMap<String, Integer> measureScaleMap = new HashMap<String, Integer>(measures.length);
        if (ArrayUtils.isNotEmpty((Object[])measures)) {
            for (Object measure : measures) {
                int scale = 2;
                switch (MeasureTypeEnum.getEnum(measure.getString("measuretype"))) {
                    case ORDINARY: {
                        scale = measure.getInt("precision");
                        break;
                    }
                    case CALCULATION: {
                        scale = measure.getDynamicObject("measure").getInt("precision");
                    }
                }
                measureScaleMap.put(measure.getString("number"), scale);
            }
        }
        return measureScaleMap;
    }
}

