/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.pa.dto.BusinessStepSummaryItemDTO;
import kd.fi.pa.enums.DataReviewRuleTypeEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.enums.MultiOrgShareEnum;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.model.impl.PAAnalysisModelModel;
import kd.fi.pa.model.impl.PADimensionModel;
import kd.fi.pa.utils.ModelUtil;

public class PARuleHelper {
    private static final Log logger = LogFactory.getLog(PARuleHelper.class);
    private static final String ALGO_KEY = PARuleHelper.class.getName();
    private static final String VIEW_LISTF7_BASEDATA = "bos_listf7";
    private static final String VIEW_LISTF7_ASSISTANT = "bos_assistantdata_detail";

    public static void processInteractiveDisplay(AbstractFormPlugin plugIn, Object baseDataObj, Object assistantObj, Object dimObject, String number, String fieldNumber, String callBackId, String enumCallBackId, QFilter filter, boolean isMultiSelect, Object[] selectRows) {
        IDataModel model = plugIn.getView().getModel();
        DynamicObject dy = (DynamicObject)dimObject;
        if (dy == null) {
            return;
        }
        DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum(dy.getString("dimensiontype"));
        if (DimensionTypeEnum.OTHER == dimensionType) {
            return;
        }
        if (DimensionTypeEnum.DENUMS == dimensionType) {
            DynamicObject entry = model.getEntryRowEntity(number, model.getEntryCurrentRowIndex(number));
            String defaultValue = entry.getString(fieldNumber);
            PARuleHelper.openDimensionInfoView(plugIn, defaultValue, dy.getLong("id"), dy.getString("name"), enumCallBackId, false);
            return;
        }
        if (!ObjectUtils.isEmpty((Object)assistantObj)) {
            String assType = assistantObj.toString();
            QFilter assGroup = new QFilter("group.number", "=", (Object)assType);
            filter = filter == null ? assGroup : filter.and(assGroup);
            PARuleHelper.showF7ListView(plugIn, VIEW_LISTF7_ASSISTANT, assType, number, fieldNumber, callBackId, null, filter, isMultiSelect, selectRows);
            return;
        }
        if (!ObjectUtils.isEmpty((Object)baseDataObj) && !ObjectUtils.isEmpty((Object)dimObject)) {
            String bdType = baseDataObj.toString();
            Long dimId = ((DynamicObject)dimObject).getLong("id");
            DynamicObject dimensionDy = PADimensionHelper.loadDimension(dimId);
            if (!ObjectUtils.isEmpty((Object)dimensionDy)) {
                QFilter baseGroup = PADimensionHelper.getDimensionTypeQFilter(dimensionDy);
                if (filter == null) {
                    filter = baseGroup;
                } else if (baseGroup != null) {
                    filter = filter.and(baseGroup);
                }
                PARuleHelper.showF7ListView(plugIn, VIEW_LISTF7_BASEDATA, bdType, number, fieldNumber, callBackId, null, filter, isMultiSelect, selectRows);
            }
        }
    }

    public static void showF7ListView(AbstractFormPlugin plugIn, String formId, String billFormId, String number, String fieldNumber, String callBackId, String caption, QFilter filter, boolean isMultiSelect, Object[] selectRows) {
        IFormView view = plugIn.getView();
        IDataModel model = view.getModel();
        ListShowParameter fsp = null;
        fsp = StringUtils.equals((CharSequence)VIEW_LISTF7_ASSISTANT, (CharSequence)formId) ? CoreShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect) : CoreShowFormHelper.createShowListForm((String)billFormId, (boolean)isMultiSelect);
        if (filter != null) {
            fsp.setListFilterParameter(new ListFilterParameter(Collections.singletonList(filter), null));
        }
        if (!ObjectUtils.isEmpty((Object[])selectRows)) {
            fsp.setSelectedRows(selectRows);
        } else if (StringUtils.isNotBlank((CharSequence)number)) {
            if (StringUtils.equals((CharSequence)fieldNumber, (CharSequence)number)) {
                fsp.setSelectedRows(new Object[]{model.getValue("mappingmaptype")});
            } else {
                DynamicObject entry = model.getEntryRowEntity(number, model.getEntryCurrentRowIndex(number));
                String id = entry.getString(fieldNumber);
                if (StringUtils.isNotBlank((CharSequence)id)) {
                    fsp.setSelectedRows((Object[])id.split(","));
                }
            }
        }
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss value = new StyleCss();
        value.setHeight("580px");
        value.setWidth("960px");
        fsp.getOpenStyle().setInlineStyleCss(value);
        fsp.setF7ClickByFilter(true);
        if (StringUtils.isNotBlank((CharSequence)callBackId)) {
            fsp.setCaption(caption);
        }
        fsp.setHasRight(true);
        fsp.setLookUp(true);
        fsp.setMultiSelect(isMultiSelect);
        fsp.setShowUsed(true);
        fsp.setShowTitle(false);
        fsp.setShowQuickFilter(true);
        fsp.setIsolationOrg(true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugIn, callBackId));
        view.showForm((FormShowParameter)fsp);
    }

    public static void openView(AbstractFormPlugin plugIn, String dimensionName, String dimensionValue) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pa_multitext");
        param.setCaption(dimensionName);
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotBlank((CharSequence)dimensionValue)) {
            param.setCustomParam("params", (Object)dimensionValue.split("\n"));
        }
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)plugIn, "otherCallBack"));
        plugIn.getView().showForm(param);
    }

    public static void openDimensionInfoView(AbstractFormPlugin plugIn, String dimensionValue, long dimensionId, String dimensionName, String callBackId, boolean isMultiSelect) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> paramter = new HashMap<String, Object>(4);
        paramter.put("dimensionId", dimensionId);
        paramter.put("ismultiselect", isMultiSelect);
        if (StringUtils.isNotBlank((CharSequence)dimensionValue)) {
            paramter.put("choseEnum", dimensionValue);
        }
        param.setFormId("pa_dimensioninfo");
        param.setCaption(dimensionName);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParams(paramter);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)plugIn, callBackId));
        plugIn.getView().showForm(param);
    }

    public static void processDimensionInfoCloseBack(AbstractFormPlugin plugIn, Object result, String entry, String text, String textE, String dimensionText) {
        if (ObjectUtils.isEmpty((Object)result)) {
            return;
        }
        IDataModel model = plugIn.getView().getModel();
        HashMap map = (HashMap)SerializationUtils.fromJsonString((String)result.toString(), Map.class);
        String id = (String)map.get("id");
        String title = (String)map.get("title");
        String value = (String)map.get("value");
        String textTag = (String)map.get("text");
        int i = model.getEntryCurrentRowIndex(entry);
        model.setValue(textE, (Object)(title.length() > 1024 ? title.substring(0, 1024) : title), i);
        model.setValue(text, (Object)(value.length() > 1024 ? value.substring(0, 1024) : value), i);
        if (StringUtils.isNotBlank((CharSequence)dimensionText)) {
            model.setValue(dimensionText, (Object)(textTag.length() > 255 ? textTag.substring(0, 255) : textTag));
            model.setValue(dimensionText + "_tag", (Object)textTag, i);
        }
    }

    public static void processCache(AbstractFormPlugin plugIn, boolean flag) {
        IFormView view = plugIn.getView();
        IDataModel model = view.getModel();
        String name = ((OrmLocaleValue)model.getValue("name")).get((Object)Lang.get().toString());
        String number = model.getValue("number").toString();
        IPageCache parentCache = view.getParentView().getPageCache();
        Map<String, Object> map = new HashMap<String, Tuple>();
        String content = parentCache.get("tips_sender");
        if (StringUtils.isNotBlank((CharSequence)content)) {
            map = (Map)JSON.parseObject((String)content, map.getClass());
        }
        if (flag) {
            map.put(number, new Tuple((Object)name, (Object)0));
        } else {
            map.put(number, new Tuple((Object)name, (Object)1));
        }
        parentCache.put("tips_sender", SerializationUtils.toJsonString(map));
    }

    public static QFilter getAnalysisPeriodFilter() {
        QFilter filter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.PERIOD.getCode());
        filter.and("dimension_entry.dimension.dimensiontype", "in", (Object)new String[]{DimensionTypeEnum.DATABASE.getCodeString(), DimensionTypeEnum.DATE.getCodeString()});
        filter.and(QFilter.of((String)" dimension_entry.dimension.dimensionsource != 'pa_analysisperiod'", (Object[])new Object[0]));
        return filter;
    }

    public static QFilter getOnlyPeriodFilter() {
        QFilter filter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.PERIOD.getCode());
        filter.and("dimension_entry.dimension.dimensiontype", "=", (Object)DimensionTypeEnum.DATABASE.getCodeString());
        filter.and(QFilter.of((String)"dimension_entry.dimension.dimensionsource = 'bd_period'", (Object[])new Object[0]));
        return filter;
    }

    public static QFilter getDateTimeFilterInModel() {
        QFilter filter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.PERIOD.getCode());
        filter.and("dimension_entry.dimension.dimensiontype", "!=", (Object)DimensionTypeEnum.DATE.getCodeString());
        return filter;
    }

    public static QFilter getDateTimeNotMustFilterInModel(long systemId) {
        QFilter filter = new QFilter("dimension_entry.dimension.dimensiontype", "=", (Object)DimensionTypeEnum.DATE.getCodeString());
        if (systemId != 0L) {
            filter = filter.and("analysis_system", "=", (Object)systemId);
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{filter});
        Set modelIds = dys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        return new QFilter("id", "not in", modelIds);
    }

    public static void processFilterItemSelectedByDefault(FilterContainerSearchClickArgs args, IPageCache pageCache, String field, String systemIdField, String modelIdField) {
        if (!StringUtils.equals((CharSequence)systemIdField, (CharSequence)field)) {
            return;
        }
        List customfilter = (List)args.getFilterValues().get("customfilter");
        if (!CollectionUtils.isEmpty((Collection)customfilter)) {
            customfilter.removeIf(t -> ((List)t.get("FieldName")).get(0).equals(modelIdField));
        }
    }

    public static List<ComboItem> getEmptyComboItems() {
        return new ArrayList<ComboItem>(1);
    }

    public static List<ComboItem> getComboItems(String entityName, QFilter filter) {
        return PARuleHelper.getComboItems(entityName, filter, "id,name,number,enable", "number");
    }

    public static List<ComboItem> getComboItems(String entityName, QFilter filter, String queryFields, String orderBy) {
        DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityName, (String)queryFields, (QFilter[])filter.toArray(), (String)orderBy);
        if (dataCol == null || dataCol.isEmpty()) {
            return PARuleHelper.getEmptyComboItems();
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dataCol.size());
        for (DynamicObject obj : dataCol) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(obj.getString("name")));
            item.setValue(String.valueOf(obj.getLong("id")));
            item.setItemVisible(true);
            comboItems.add(item);
        }
        return comboItems;
    }

    public static void setComboItems(FilterColumn filterColumn, List<ComboItem> comboItemList) {
        if (filterColumn instanceof SchemeFilterColumn) {
            ((SchemeFilterColumn)filterColumn).setComboItems(comboItemList);
        } else if (filterColumn instanceof CommonFilterColumn) {
            ((CommonFilterColumn)filterColumn).setComboItems(comboItemList);
        }
    }

    public static Map<Long, Boolean> getRuleSummarySwitchItemsByRuleGroupId(Long ruleGroupId) {
        List<BusinessStepSummaryItemDTO> ruleStepSummaryItemsByRuleGroupId = PARuleHelper.getRuleStepSummaryDTOByRuleGroupId(ruleGroupId);
        LinkedHashMap<Long, Boolean> ruleStepSummarySwitchItemsMap = new LinkedHashMap<Long, Boolean>(ruleStepSummaryItemsByRuleGroupId.size());
        if (CollectionUtils.isEmpty(ruleStepSummaryItemsByRuleGroupId)) {
            return ruleStepSummarySwitchItemsMap;
        }
        for (BusinessStepSummaryItemDTO businessStepSummaryItemDTO : ruleStepSummaryItemsByRuleGroupId) {
            ruleStepSummarySwitchItemsMap.put(businessStepSummaryItemDTO.getStepId(), businessStepSummaryItemDTO.getSummary());
        }
        return ruleStepSummarySwitchItemsMap;
    }

    public static List<BusinessStepSummaryItemDTO> getRuleStepSummaryDTOByRuleGroupId(Long ruleGroupId) {
        DynamicObject ruleGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleGroupId, (String)"pa_businessplan");
        if (ruleGroup == null) {
            throw new KDBizException("current ruleGroup is unExist");
        }
        return PARuleHelper.getRuleStepSummaryItems(ruleGroup.getString("rulesummaryswitchdata_tag"), ruleGroup.getDynamicObjectCollection("pa_businessplan_rule"));
    }

    public static List<BusinessStepSummaryItemDTO> getRuleStepSummaryItems(String ruleSummarySettingTag, DynamicObjectCollection businessRules) {
        LinkedHashMap stepSummaryHistorySettingMap = new LinkedHashMap(8);
        if (StringUtils.isNotBlank((CharSequence)ruleSummarySettingTag)) {
            stepSummaryHistorySettingMap = (LinkedHashMap)JSON.parseObject((String)ruleSummarySettingTag, (TypeReference)new TypeReference<LinkedHashMap<Long, Boolean>>(){}, (Feature[])new Feature[0]);
        }
        List businessRulesInGroup = businessRules.stream().map(entry -> entry.getDynamicObject("rulenumber")).filter(Objects::nonNull).collect(Collectors.toList());
        int ruleIndex = 0;
        ArrayList<BusinessStepSummaryItemDTO> businessStepSummaryItemDTOS = new ArrayList<BusinessStepSummaryItemDTO>(8);
        for (DynamicObject businessRule : businessRulesInGroup) {
            DynamicObjectCollection stepEntry = businessRule.getDynamicObjectCollection("stepentry");
            int stepIndex = 0;
            for (DynamicObject step : stepEntry) {
                BusinessStepSummaryItemDTO businessStepSummaryItemDTO = new BusinessStepSummaryItemDTO();
                businessStepSummaryItemDTO.setBusinessRuleId(businessRule.getLong("id"));
                DataReviewRuleTypeEnum cardHandleType = DataReviewRuleTypeEnum.getEnumByCode(step.getString("cardhandletype"));
                switch (cardHandleType) {
                    case DERIVATION: {
                        businessStepSummaryItemDTO.setStepId(step.getDynamicObject("cardderivationmodel").getLong("id"));
                        break;
                    }
                    case SHARE: {
                        businessStepSummaryItemDTO.setStepId(step.getDynamicObject("cardsharemodel").getLong("id"));
                    }
                }
                businessStepSummaryItemDTO.setStepName(step.getString("cardstepname"));
                businessStepSummaryItemDTO.setRuleTypeEnum(cardHandleType);
                if (ruleIndex == businessRulesInGroup.size() - 1 && stepIndex == stepEntry.size() - 1) {
                    businessStepSummaryItemDTO.setSummary(Boolean.TRUE);
                } else {
                    businessStepSummaryItemDTO.setSummary(stepSummaryHistorySettingMap.getOrDefault(businessStepSummaryItemDTO.getStepId(), Boolean.TRUE));
                }
                businessStepSummaryItemDTOS.add(businessStepSummaryItemDTO);
                ++stepIndex;
            }
            ++ruleIndex;
        }
        PARuleHelper.updateRowEnableOfStepItems(businessStepSummaryItemDTOS);
        return businessStepSummaryItemDTOS;
    }

    private static void updateRowEnableOfStepItems(List<BusinessStepSummaryItemDTO> businessStepSummaryItemDTOS) {
        Object[] shareStepIds = businessStepSummaryItemDTOS.stream().filter(dto -> DataReviewRuleTypeEnum.SHARE == dto.getRuleTypeEnum()).map(BusinessStepSummaryItemDTO::getStepId).toArray();
        Map shareStepDYs = BusinessDataServiceHelper.loadFromCache((Object[])shareStepIds, (String)"pa_sharerulenew");
        ArrayList<Long> unEnableRowStepIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Map)shareStepDYs)) {
            for (DynamicObject shareStep : shareStepDYs.values()) {
                Long orgDimensionId = shareStep.getDynamicObject("analysismodel").getDynamicObjectCollection("dimension_entry").stream().filter(entry -> DimensionNecessityEnum.ORG == DimensionNecessityEnum.getEnum(entry.getString("necessity_dim"))).map(entry -> entry.getDynamicObject("dimension").getLong("id")).findFirst().orElseThrow(() -> new KDBizException("org necessary dimension is unExist"));
                boolean existOrgDimension = shareStep.getDynamicObjectCollection("receiveentryentity").stream().anyMatch(entry -> orgDimensionId.longValue() == entry.getDynamicObject("receivedimension").getLong("id"));
                if (!existOrgDimension) continue;
                unEnableRowStepIds.add(shareStep.getLong("id"));
            }
        }
        for (int i = 0; i < businessStepSummaryItemDTOS.size(); ++i) {
            BusinessStepSummaryItemDTO businessStepSummaryItemDTO = businessStepSummaryItemDTOS.get(i);
            if (i == businessStepSummaryItemDTOS.size() - 1) {
                businessStepSummaryItemDTO.setRowEnable(false);
                continue;
            }
            businessStepSummaryItemDTO.setRowEnable(!unEnableRowStepIds.contains(businessStepSummaryItemDTO.getStepId()));
        }
    }

    public static MultiOrgShareEnum computeRuleMultiOrgShare(Long[] businessRuleIds, String orgDimNum) {
        if (businessRuleIds == null || businessRuleIds.length == 0) {
            throw new KDBizException("businessRuleIds is empty");
        }
        Map ruleMap = BusinessDataServiceHelper.loadFromCache((Object[])businessRuleIds, (String)"pa_businessrule");
        ArrayList<Long> allocationRuleIds = new ArrayList<Long>(16);
        for (DynamicObject ruleObj : ruleMap.values()) {
            DynamicObjectCollection stepEntry = ruleObj.getDynamicObjectCollection("stepentry");
            for (DynamicObject stepDy : stepEntry) {
                if (!DataReviewRuleTypeEnum.SHARE.getCode().equals(stepDy.getString("cardhandletype"))) continue;
                Long allocationRuleId = stepDy.getLong("cardsharemodel_id");
                allocationRuleIds.add(allocationRuleId);
            }
        }
        Map allocationRuleDyMap = BusinessDataServiceHelper.loadFromCache((Object[])allocationRuleIds.toArray(), (String)"pa_sharerulenew");
        for (Map.Entry entrySet : allocationRuleDyMap.entrySet()) {
            Long allocationRuleId = (Long)entrySet.getKey();
            DynamicObject allocationRuleDy = (DynamicObject)entrySet.getValue();
            MultiOrgShareEnum multiOrgShareEnum = MultiOrgShareEnum.getEnum(allocationRuleDy.getString("multiorgshare"));
            if (multiOrgShareEnum == null) {
                multiOrgShareEnum = PARuleHelper.computeAllocationMultiOrgShare(allocationRuleId, orgDimNum);
            }
            if (MultiOrgShareEnum.YES != multiOrgShareEnum) continue;
            return MultiOrgShareEnum.YES;
        }
        return MultiOrgShareEnum.NO;
    }

    public static MultiOrgShareEnum computeRulePlanMultiOrgShare(Long businessRulePlanId, String orgDimNum) {
        if (businessRulePlanId == null) {
            throw new KDBizException("businessRulePlanId is null");
        }
        DynamicObject planObj = BusinessDataServiceHelper.loadSingleFromCache((Object)businessRulePlanId, (String)"pa_businessplan");
        DynamicObjectCollection ruleEntry = planObj.getDynamicObjectCollection("pa_businessplan_rule");
        Long[] ruleIds = (Long[])ruleEntry.stream().map(ruleDy -> ruleDy.getLong("rulenumber_id")).toArray(Long[]::new);
        return PARuleHelper.computeRuleMultiOrgShare(ruleIds, orgDimNum);
    }

    public static MultiOrgShareEnum computeAllocationMultiOrgShare(Long allocationRuleId, String orgDimNum) {
        if (StringUtils.isEmpty((CharSequence)orgDimNum)) {
            throw new KDBizException("orgDim is null");
        }
        DynamicObject allocationRuleDy = BusinessDataServiceHelper.loadSingle((Object)allocationRuleId, (String)"pa_sharerulenew");
        MultiOrgShareEnum multiOrgShareEnum = MultiOrgShareEnum.getEnum(allocationRuleDy.getString("multiorgshare"));
        if (multiOrgShareEnum != null) {
            return multiOrgShareEnum;
        }
        DynamicObjectCollection entryEntity = allocationRuleDy.getDynamicObjectCollection("receiveentryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObject recvDim = dynamicObject.getDynamicObject("receivedimension");
            if (!orgDimNum.equals(recvDim.getString("number"))) continue;
            multiOrgShareEnum = MultiOrgShareEnum.YES;
            break;
        }
        if (multiOrgShareEnum == null) {
            multiOrgShareEnum = MultiOrgShareEnum.NO;
        }
        allocationRuleDy.set("multiorgshare", (Object)multiOrgShareEnum.getCode());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocationRuleDy});
        return multiOrgShareEnum;
    }

    public static List<Long> getAllocationRuleIdList(Long businessRuleId) {
        DynamicObject businessRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)businessRuleId, (String)"pa_businessrule");
        if (businessRuleDy == null) {
            return new ArrayList<Long>();
        }
        DynamicObjectCollection stepDyCol = businessRuleDy.getDynamicObjectCollection("stepentry");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject stepDy : stepDyCol) {
            String type = stepDy.getString("cardhandletype");
            if (!"B".equals(type)) continue;
            idList.add(stepDy.getLong("cardsharemodel_id"));
        }
        return idList;
    }

    public static QFilter getAllocationRuleOrgFilter(Long allocationRuleId, Long analysisModelId) {
        DynamicObject allocationRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)allocationRuleId, (String)"pa_sharerulenew");
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (allocationRuleDy == null || analysisModelDy == null) {
            return null;
        }
        String orgDimNumber = null;
        DynamicObjectCollection dimensionDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dimensionEntryDy : dimensionDyCol) {
            DynamicObject dimensionDy;
            String necessityDim = dimensionEntryDy.getString("necessity_dim");
            if (necessityDim == null || necessityDim.isEmpty() || !DimensionNecessityEnum.ORG.getCode().equals(necessityDim) || (dimensionDy = dimensionEntryDy.getDynamicObject("dimension")) == null) continue;
            orgDimNumber = dimensionDy.getString("number");
        }
        if (orgDimNumber == null) {
            return null;
        }
        ArrayList<DynamicObject> orgDyList = new ArrayList<DynamicObject>();
        DynamicObjectCollection sendEntryDyCol = allocationRuleDy.getDynamicObjectCollection("sendentryentity");
        for (DynamicObject sendDy : sendEntryDyCol) {
            String number = sendDy.getDynamicObject("senddimension").getString("number");
            if (!StringUtils.equals((CharSequence)orgDimNumber, (CharSequence)number)) continue;
            orgDyList.add(sendDy);
        }
        if (orgDyList.isEmpty()) {
            return null;
        }
        QFilter orgFilter = null;
        String orgNumber = "id";
        PAAnalysisModelModel paAnalysisModelModel = new PAAnalysisModelModel();
        paAnalysisModelModel.loadFromDynamicObject(analysisModelDy);
        for (DynamicObject orgDy : orgDyList) {
            String type = orgDy.getString("senddimtype");
            String sendCondition = orgDy.getString("combofield");
            String idStr = orgDy.getString("dimensionid");
            String valueStr = orgDy.getString("dimensionvalue");
            String text = orgDy.getString("dimensiontext_tag");
            String baseEntityId = orgDy.getString("sendmatename");
            PADimensionModel dimensionModel = paAnalysisModelModel.getDim(orgDy.getDynamicObject("senddimension").getPkValue());
            if (dimensionModel != null && dimensionModel.getDataType() == DimensionTypeEnum.DATABASE && dimensionModel.getSource() != null) {
                baseEntityId = dimensionModel.getSource().getNumber();
            }
            String value = "";
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum(sendCondition);
            if (conditionEnum == FilterConditionEnum.IN || conditionEnum == FilterConditionEnum.NOT_IN) {
                value = ModelUtil.getDimValue(type, text, idStr, valueStr);
            }
            QFilter dimQFilter = ModelUtil.getDimQFilter(type, orgNumber, baseEntityId, sendCondition, value);
            if (orgFilter == null) {
                orgFilter = dimQFilter;
                continue;
            }
            orgFilter.and(dimQFilter);
        }
        return orgFilter;
    }

    public static QFilter getAllocationRuleAccountFilter(Long allocationRuleId, Long analysisModelId) {
        DynamicObject allocationRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)allocationRuleId, (String)"pa_sharerulenew");
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (allocationRuleDy == null || analysisModelDy == null) {
            return null;
        }
        String accountDimNumber = null;
        DynamicObjectCollection dimensionDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dimensionEntryDy : dimensionDyCol) {
            DynamicObject dimensionDy;
            String necessityDim = dimensionEntryDy.getString("necessity_dim");
            if (necessityDim == null || necessityDim.isEmpty() || !DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim) || (dimensionDy = dimensionEntryDy.getDynamicObject("dimension")) == null) continue;
            accountDimNumber = dimensionDy.getString("number");
        }
        if (accountDimNumber == null) {
            return null;
        }
        ArrayList<DynamicObject> accountDyList = new ArrayList<DynamicObject>();
        DynamicObjectCollection sendEntryDyCol = allocationRuleDy.getDynamicObjectCollection("sendentryentity");
        for (DynamicObject sendDy : sendEntryDyCol) {
            String number = sendDy.getDynamicObject("senddimension").getString("number");
            if (!StringUtils.equals((CharSequence)accountDimNumber, (CharSequence)number)) continue;
            accountDyList.add(sendDy);
        }
        if (accountDyList.isEmpty()) {
            return null;
        }
        QFilter accountFilter = null;
        String accountNumber = "id";
        PAAnalysisModelModel paAnalysisModelModel = new PAAnalysisModelModel();
        paAnalysisModelModel.loadFromDynamicObject(analysisModelDy);
        for (DynamicObject accountDy : accountDyList) {
            String type = accountDy.getString("senddimtype");
            String sendCondition = accountDy.getString("combofield");
            String idStr = accountDy.getString("dimensionid");
            String valueStr = accountDy.getString("dimensionvalue");
            String text = accountDy.getString("dimensiontext_tag");
            String baseEntityId = accountDy.getString("sendmatename");
            PADimensionModel dimensionModel = paAnalysisModelModel.getDim(accountDy.getDynamicObject("senddimension").getPkValue());
            if (dimensionModel != null && dimensionModel.getDataType() == DimensionTypeEnum.DATABASE && dimensionModel.getSource() != null) {
                baseEntityId = dimensionModel.getSource().getNumber();
            }
            String value = "";
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum(sendCondition);
            if (conditionEnum == FilterConditionEnum.IN || conditionEnum == FilterConditionEnum.NOT_IN) {
                value = ModelUtil.getDimValue(type, text, idStr, valueStr);
            }
            QFilter dimQFilter = ModelUtil.getDimQFilter(type, accountNumber, baseEntityId, sendCondition, value);
            if (accountFilter == null) {
                accountFilter = dimQFilter;
                continue;
            }
            accountFilter.and(dimQFilter);
        }
        return accountFilter;
    }

    public static QFilter getBusinessRulePeriodFilter(Long businessRuleId, Long analysisModelId) {
        DynamicObject businessRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)businessRuleId, (String)"pa_businessrule");
        if (businessRuleDy == null) {
            return null;
        }
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        QFilter periodTypeQFilter = PAExecutorHelper.getBaseQFilter(analysisModelDy, DimensionNecessityEnum.PERIOD.getCode());
        DynamicObject periodTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{periodTypeQFilter});
        Long startPeriodId = businessRuleDy.getLong("startperiod_id");
        QFilter startPeriodIdFilter = new QFilter("id", "=", (Object)startPeriodId);
        DynamicObject startPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{startPeriodIdFilter});
        Long endPeriodId = businessRuleDy.getLong("endperiod_id");
        QFilter endPeriodIdFilter = new QFilter("id", "=", (Object)endPeriodId);
        DynamicObject endPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{endPeriodIdFilter});
        if (periodTypeDy == null || startPeriodDy == null || endPeriodDy == null) {
            return null;
        }
        Object periodTypeId = periodTypeDy.getDynamicObject("periodtype").getPkValue();
        Date startDate = startPeriodDy.getDate("begindate");
        Date endDate = endPeriodDy.getDate("enddate");
        QFilter typeFilter = new QFilter("periodtype", "=", periodTypeId);
        QFilter startDateFilter = new QFilter("begindate", ">=", (Object)startDate);
        QFilter endDateFilter = new QFilter("enddate", "<=", (Object)endDate);
        return typeFilter.and(startDateFilter).and(endDateFilter);
    }

    public static QFilter getBusinessRuleAccountFilter(Long businessRuleId, Long analysisModelId) {
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        DynamicObject businessRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)businessRuleId, (String)"pa_businessrule");
        if (analysisModelDy == null || businessRuleDy == null) {
            return null;
        }
        long accountDimId = 0L;
        DynamicObjectCollection dimensionEntryDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dimDy : dimensionEntryDyCol) {
            if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(dimDy.getString("necessity_dim"))) continue;
            accountDimId = dimDy.getLong("dimension_id");
        }
        DynamicObject accountDimDy = PADimensionHelper.loadDimension(accountDimId);
        if (accountDimDy == null) {
            return null;
        }
        String accountEntityName = accountDimDy.getDynamicObject("dimensionsource").getPkValue().toString();
        String accountDimNumber = accountDimDy.getString("number");
        String accountFilterTag = businessRuleDy.getString("accountfilter_tag");
        String filterJson = accountFilterTag.replace(accountDimNumber + ".", "");
        if (StringUtils.isEmpty((CharSequence)filterJson)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)accountEntityName), filterCondition);
        filterBuilder.buildFilter(false);
        QFilter accountFilter = filterBuilder.getQFilter();
        QFilter dimensionTypeQFilter = PADimensionHelper.getDimensionTypeQFilter(accountDimDy);
        return accountFilter.and(dimensionTypeQFilter);
    }

    public static List<Long> getAllocationRuleReceiverDimList(Long allocationRuleId) {
        DynamicObject allocationRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)allocationRuleId, (String)"pa_sharerulenew");
        if (allocationRuleDy == null) {
            return new ArrayList<Long>();
        }
        DynamicObjectCollection receiveEntryDyCol = allocationRuleDy.getDynamicObjectCollection("receiveentryentity");
        return receiveEntryDyCol.stream().map(dy -> dy.getLong("receivedimension_id")).collect(Collectors.toList());
    }
}

