/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PASyncDataParamHelper {
    private static final String ALGO_KEY = PASyncDataParamHelper.class.getName();

    private PASyncDataParamHelper() {
    }

    public static Map<String, String> validateSyncDataParam(Long systemId, Long modelId, String operation, Set<Long> orgIdSet, Long businessPlanId, Long businessRuleId, Long editPKId) {
        QFilter systemFilter = new QFilter("system.id", "=", (Object)systemId);
        QFilter modelFilter = new QFilter("model.id", "=", (Object)modelId);
        QFilter operationFilter = new QFilter("operation", "=", (Object)operation);
        QFilter orgIdFilter = new QFilter("org.fbasedataid.id", "in", orgIdSet);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(systemFilter);
        qFilterList.add(modelFilter);
        qFilterList.add(operationFilter);
        qFilterList.add(orgIdFilter);
        if (businessPlanId != 0L) {
            qFilterList.add(new QFilter("businessplan.id", "=", (Object)businessPlanId));
        }
        if (businessRuleId != 0L) {
            qFilterList.add(new QFilter("businessrule.id", "=", (Object)businessRuleId));
        }
        if (editPKId != 0L) {
            qFilterList.add(new QFilter("id", "!=", (Object)editPKId));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_syncdataparam", (String)"id,name,number,org.fbasedataid.name,org.fbasedataid.number", (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"org.fbasedataid.number");){
            HashMap<String, String> map = new HashMap<String, String>(6);
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put("name", row.getString("name"));
                map.put("number", row.getString("number"));
                map.put("orgName", row.getString("org.fbasedataid.name"));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Object, DynamicObject> querySyncDataParam(Long id, String operation) {
        QFilter basicFilter = new QFilter("enable", "=", (Object)"1");
        if (id != null) {
            basicFilter.and(new QFilter("id", "=", (Object)id));
        }
        if (!StringUtils.isEmpty((CharSequence)operation)) {
            basicFilter.and(new QFilter("operation", "=", (Object)operation));
        }
        return BusinessDataServiceHelper.loadFromCache((String)"pa_syncdataparam", (QFilter[])new QFilter[]{basicFilter});
    }
}

