/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.RecordSaveFormServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.dto.ModelTableSummaryDetailMappingDTO;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.model.impl.PAAnalysisModelModel;
import kd.fi.pa.model.impl.PADimensionModel;
import kd.fi.pa.model.impl.PAMeasureModel;

public class PATableDataHelper {
    public static DataSet fixDimStatistic(String entity, String[] groupByDim, boolean isCalculate) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fixDimStatistic", (String)entity, (String)PATableDataHelper.arrayToStr(groupByDim), (QFilter[])new QFilter[]{PATableDataHelper.fixFilter(isCalculate)}, null);
        if (dataSet == null) {
            return null;
        }
        return dataSet.distinct();
    }

    public static String arrayToStr(String[] array) {
        StringBuilder sb = new StringBuilder(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                sb.append(',').append(array[i]);
            }
        }
        return sb.toString();
    }

    public static QFilter fixFilter(boolean isCalculate) {
        if (isCalculate) {
            return new QFilter("collectstatus", "=", (Object)PACollectStatusEnum.COLLECT.getCode());
        }
        QFilter filter = new QFilter("operationstatus", "=", (Object)OperationStatusEnum.UNUSED.getCode());
        filter.and("collectstatus", "=", (Object)PACollectStatusEnum.DETAIL.getCode());
        return filter;
    }

    public static Map<Object, List<Object>> queryDimensionData(PADimensionModel dimensionModel, String[] attrs, Collection<Object> idList) {
        String entityName = dimensionModel.getSource().getNumber();
        StringBuilder selectField = new StringBuilder("id");
        for (String attr : attrs) {
            selectField.append(',').append(attr);
        }
        HashMap<Object, List<Object>> classifyMap = new HashMap<Object, List<Object>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDimensionData", (String)entityName, (String)selectField.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);){
            for (Row row : dataSet) {
                StringBuilder keyBuild = new StringBuilder();
                for (String attr : attrs) {
                    keyBuild.append(row.get(attr));
                }
                String attrValue = keyBuild.toString();
                List classifyIdList = classifyMap.computeIfAbsent(attrValue, k -> new ArrayList(10));
                classifyIdList.add(row.get("id"));
            }
        }
        return classifyMap;
    }

    public static String[] dimToField(List<PADimensionModel> dimList) {
        String[] fields = new String[dimList.size()];
        int i = 0;
        for (PADimensionModel dimension : dimList) {
            fields[i] = dimension.getNumber();
            ++i;
        }
        return fields;
    }

    public static String selectField(PAAnalysisModelModel analysisModelMode, boolean needCal) {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        for (PADimensionModel dimensionModel : analysisModelMode.getAllDim()) {
            sb.append(",").append(dimensionModel.getNumber());
        }
        for (PAMeasureModel measureModel : analysisModelMode.getOrdinaryMeasure()) {
            sb.append(",").append(measureModel.getNumber());
        }
        if (needCal && analysisModelMode.getCalMeasure() != null) {
            for (PAMeasureModel measureModel : analysisModelMode.getCalMeasure()) {
                sb.append(",").append(measureModel.getNumber());
            }
        }
        return sb.toString();
    }

    public static DynamicObject[] load(String entityNumber, String measureField, QFilter filter) {
        return BusinessDataServiceHelper.load((String)entityNumber, (String)("id," + measureField), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject[] load(String entityNumber, String measureField, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)entityNumber, (String)("id," + measureField), (QFilter[])filters);
    }

    public static void save(Collection<DynamicObject> dataList, boolean isInsert) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        int row = 0;
        Object[] dynamicObjects = new DynamicObject[1000];
        IDataEntityType dt = dataList.iterator().next().getDataEntityType();
        for (DynamicObject data : dataList) {
            dynamicObjects[row++] = data;
            if (row != dynamicObjects.length) continue;
            if (isInsert) {
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])dynamicObjects);
            } else {
                BusinessDataWriter.update((IDataEntityType)dt, (Object[])dynamicObjects);
            }
            dynamicObjects = new DynamicObject[1000];
            row = 0;
        }
        if (row > 0) {
            if (isInsert) {
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])Arrays.copyOf(dynamicObjects, row));
            } else {
                BusinessDataWriter.update((IDataEntityType)dt, (Object[])Arrays.copyOf(dynamicObjects, row));
            }
        }
    }

    public static void insert(Collection<DynamicObject> dataList) {
        PATableDataHelper.save(dataList, true);
    }

    public static void update(Collection<DynamicObject> dataList) {
        PATableDataHelper.save(dataList, false);
    }

    public static void saveModelTableSummaryDetailMappings(Collection<ModelTableSummaryDetailMappingDTO> modelTableSummaryDetailMappingDTOS) {
        if (CollectionUtils.isEmpty(modelTableSummaryDetailMappingDTOS)) {
            return;
        }
        int row = 0;
        Date date = new Date();
        Object[] dynamicObjects = new DynamicObject[2000];
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pa_detailsummarymapping");
        for (ModelTableSummaryDetailMappingDTO modelTableMappingDTO : modelTableSummaryDetailMappingDTOS) {
            for (Long detailId : modelTableMappingDTO.getDetailIds()) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"pa_detailsummarymapping");
                dynamicObject.set("analysismodel", (Object)modelTableMappingDTO.getAnaModelId());
                dynamicObject.set("summaryid", (Object)modelTableMappingDTO.getSummaryId());
                dynamicObject.set("detailid", (Object)detailId);
                dynamicObject.set("createtime", (Object)date);
                dynamicObject.set("createtimestamp", (Object)date.getTime());
                dynamicObjects[row++] = dynamicObject;
                if (row != dynamicObjects.length) continue;
                BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])dynamicObjects);
                dynamicObjects = new DynamicObject[2000];
                row = 0;
            }
        }
        BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])Arrays.copyOf(dynamicObjects, row));
    }

    public static List<ModelTableSummaryDetailMappingDTO> queryModelTableSummaryDetailMappings(String detailModelEntityNumber, boolean throwException, Long ... summaryIds) {
        if (StringUtils.isEmpty((String)detailModelEntityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u5206\u6790\u6a21\u578b\u4e0d\u5408\u6cd5", (String)"PATableDataHelper_2", (String)"fi-pa-common", (Object[])new Object[0]));
        }
        if (summaryIds == null || summaryIds.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e\u7684\u6c47\u603b-\u660e\u7ec6\u8bb0\u5f55", (String)"PATableDataHelper_4", (String)"fi-pa-common", (Object[])new Object[0]));
        }
        ArrayList<ModelTableSummaryDetailMappingDTO> modelTableSummaryDetailMappingDTOS = new ArrayList<ModelTableSummaryDetailMappingDTO>(summaryIds.length);
        try (DataSet detailsDataSet = QueryServiceHelper.queryDataSet((String)"PATableDataHelper.queryModelTableSummaryDetailMappings", (String)detailModelEntityNumber, (String)"id,summaryid,createtime", (QFilter[])new QFilter[]{new QFilter("summaryid", "in", (Object)summaryIds)}, (String)"summaryid,createtime desc");){
            if (detailsDataSet != null) {
                Long preSumId = 0L;
                ModelTableSummaryDetailMappingDTO modelTableSummaryDetailMappingDTO = new ModelTableSummaryDetailMappingDTO();
                for (Row row : detailsDataSet) {
                    Long curSumId = row.getLong("summaryid");
                    if (!curSumId.equals(preSumId)) {
                        preSumId = curSumId;
                        modelTableSummaryDetailMappingDTO = new ModelTableSummaryDetailMappingDTO();
                        modelTableSummaryDetailMappingDTO.setSummaryId(curSumId);
                        modelTableSummaryDetailMappingDTOS.add(modelTableSummaryDetailMappingDTO);
                    }
                    modelTableSummaryDetailMappingDTO.addDetailId(row.getLong("id"));
                }
            }
        }
        if (CollectionUtils.isEmpty(modelTableSummaryDetailMappingDTOS) && throwException) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e\u7684\u6c47\u603b-\u660e\u7ec6\u8bb0\u5f55", (String)"PATableDataHelper_4", (String)"fi-pa-common", (Object[])new Object[0]));
        }
        return modelTableSummaryDetailMappingDTOS;
    }

    public static List<Long> querySummaryIdByDetails(String detailModelEntityNumber, Long ... details) {
        if (StringUtils.isEmpty((String)detailModelEntityNumber) || details == null || details.length == 0) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> summaryIds = new HashSet<Long>(details.length);
        try (DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)"PATableDataHelper.querySummaryIdByDetails", (String)detailModelEntityNumber, (String)"summaryid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)details)}, null);){
            if (detailDataSet != null) {
                for (Row row : detailDataSet) {
                    summaryIds.add(row.getLong("summaryid"));
                }
            }
        }
        return new ArrayList<Long>(summaryIds);
    }

    public static List<Object> delete(String entityName, QFilter[] qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        String pkProperty = dt.getPrimaryKey().getName();
        ArrayList<Object> pks = new ArrayList<Object>(50);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)("fi.pa.PATableDataHelper" + entityName), (String)entityName, (String)pkProperty, (QFilter[])qFilters, null);){
            Iterator iter = ds.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks.toArray());
                    break;
                }
                pks.add(((Row)iter.next()).get(0));
            }
        }
        catch (Exception ex) {
            throw new KDBizException("delete erro" + ex.getMessage());
        }
        RecordSaveFormServiceHelper.recordSaveFormToCache((String)entityName);
        return pks;
    }
}

