/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.model;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BdPeriod {
    private static final Log logger = LogFactory.getLog(BdPeriod.class);
    public static final String PERIOD_AGG_YEAR = "periodyear";
    public static final String PERIOD_AGG_QUARTER = "periodquarter";
    public static final String PERIOD_AGG_NONE = "periodnone";
    private DynamicObject period;

    public BdPeriod(DynamicObject period) {
        if (period == null) {
            throw new KDBizException("period is null");
        }
        this.period = period;
    }

    public BdPeriod(Long periodId) {
        if (periodId == null || periodId == 0L) {
            throw new KDBizException("periodId is null or zero");
        }
        try {
            this.period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        }
        catch (Exception e) {
            logger.error("load period " + periodId + " error", (Throwable)e);
            throw new KDBizException("periodId " + periodId + "does not exist");
        }
    }

    public DynamicObject queryPreviousPeriod() {
        if (this.period == null) {
            throw new KDBizException("period is null");
        }
        Long periodId = this.period.getLong("id");
        Long periodTypeId = this.period.getLong("periodtype_id");
        QFilter qFilter = new QFilter("periodtype", "=", (Object)periodTypeId).and("isadjustperiod", "=", (Object)"0").and("id", "<", (Object)periodId);
        Long previousPeriodId = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryPreviousPeriod", (String)"bd_period", (String)"id", (QFilter[])qFilter.toArray(), (String)"number desc", (int)1);){
            for (Row row : dataSet) {
                previousPeriodId = row.getLong("id");
                if (previousPeriodId == null) continue;
                break;
            }
        }
        if (previousPeriodId != null) {
            return BusinessDataServiceHelper.loadSingleFromCache(previousPeriodId, (String)"bd_period");
        }
        return null;
    }

    public DynamicObject queryPreviousPeriod(Set<String> periodAggSet) {
        DynamicObject previousPeriod = this.queryPreviousPeriod();
        if (previousPeriod == null) {
            return null;
        }
        if (periodAggSet == null || periodAggSet.isEmpty()) {
            return null;
        }
        if (periodAggSet.contains(PERIOD_AGG_NONE)) {
            return previousPeriod;
        }
        if (periodAggSet.contains(PERIOD_AGG_YEAR) ? this.period.getInt(PERIOD_AGG_YEAR) == previousPeriod.getInt(PERIOD_AGG_YEAR) : periodAggSet.contains(PERIOD_AGG_QUARTER) && this.period.getInt(PERIOD_AGG_QUARTER) == previousPeriod.getInt(PERIOD_AGG_QUARTER)) {
            return previousPeriod;
        }
        return null;
    }

    public DynamicObject queryPreviousPeriod(String periodAggAttr) {
        if (StringUtils.isEmpty((CharSequence)periodAggAttr)) {
            return null;
        }
        DynamicObject previousPeriod = this.queryPreviousPeriod();
        if (previousPeriod == null) {
            return null;
        }
        if (periodAggAttr.equals(PERIOD_AGG_NONE)) {
            return previousPeriod;
        }
        if (periodAggAttr.contains(PERIOD_AGG_YEAR) ? this.period.getInt(PERIOD_AGG_YEAR) == previousPeriod.getInt(PERIOD_AGG_YEAR) : periodAggAttr.contains(PERIOD_AGG_QUARTER) && this.period.getInt(PERIOD_AGG_QUARTER) == previousPeriod.getInt(PERIOD_AGG_QUARTER)) {
            return previousPeriod;
        }
        return null;
    }

    public static String parsePeriodAggAttr(String dimAttrNumber) {
        if (StringUtils.isEmpty((CharSequence)dimAttrNumber)) {
            return PERIOD_AGG_NONE;
        }
        if (dimAttrNumber.contains(PERIOD_AGG_QUARTER)) {
            return PERIOD_AGG_QUARTER;
        }
        if (dimAttrNumber.contains(PERIOD_AGG_YEAR)) {
            return PERIOD_AGG_YEAR;
        }
        return null;
    }
}

