/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.MeasureTypeEnum;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PAMeasureHelper;
import kd.fi.pa.model.impl.BasePropModel;
import kd.fi.pa.model.impl.PADimensionModel;
import kd.fi.pa.model.impl.PAMeasureModel;

public class PAAnalysisModelModel
extends BasePropModel {
    private static Log logger = LogFactory.getLog(PAAnalysisModelModel.class);
    private static final long serialVersionUID = 2736669290109976384L;
    private static final int DIMENSION_TYPE_FIX = 1;
    private static final int DIMENSION_TYPE_OTHER = 2;
    private Map<Integer, List<PADimensionModel>> dimensionMap;
    private Map<Integer, List<PAMeasureModel>> measureMap;
    private String modelEntity;
    private PADimensionModel orgDim;
    private PADimensionModel periodDim;
    private String periodDimNumber;
    private String periodSourceNumber = null;
    private String accountDimNumber;
    private Long accountTableId;

    @Override
    public void loadFromDynamicObject(DynamicObject sourceDynamicObject, boolean fetchBaseValue) {
        DynamicObject[] measureCols;
        DynamicObject[] dimensionCols;
        super.loadFromDynamicObject(sourceDynamicObject, fetchBaseValue);
        DynamicObjectCollection dimensionEntry = sourceDynamicObject.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureEntry = sourceDynamicObject.getDynamicObjectCollection("measure_entry");
        HashSet<String> necessityDimSet = new HashSet<String>(3);
        Object[] dimensionIds = new Object[dimensionEntry.size()];
        Object[] measureIds = new Object[measureEntry.size()];
        String orgNumber = "";
        String periodNumber = "";
        int i = 0;
        for (DynamicObject[] entry : dimensionEntry) {
            String necessityDim = entry.getString("necessity_dim");
            DynamicObject dimension = entry.getDynamicObject("dimension");
            dimensionIds[i] = dimension.getPkValue();
            if (StringUtils.isNotBlank((CharSequence)necessityDim)) {
                String dimNumber = dimension.getString("number");
                necessityDimSet.add(dimNumber);
                if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                    orgNumber = dimNumber;
                } else if (DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) {
                    periodNumber = dimNumber;
                    this.periodDimNumber = dimNumber;
                } else if (DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim)) {
                    this.accountDimNumber = dimNumber;
                    this.accountTableId = (Long)dimension.get("group_id");
                }
            }
            ++i;
        }
        i = 0;
        for (DynamicObject[] entry : measureEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            measureIds[i] = measure.getPkValue();
            ++i;
        }
        for (DynamicObject dim : dimensionCols = PADimensionHelper.loadDimension(dimensionIds)) {
            String number = dim.getString("number");
            PADimensionModel dimensionModel = new PADimensionModel();
            dimensionModel.loadFromDynamicObject(dim, true);
            if (necessityDimSet.contains(number)) {
                this.addFixDim(dimensionModel);
                if (orgNumber.equals(number)) {
                    this.orgDim = dimensionModel;
                    continue;
                }
                if (!periodNumber.equals(number)) continue;
                this.periodDim = dimensionModel;
                this.periodSourceNumber = dim.getString("dimensionsource.number");
                continue;
            }
            this.addOtherDim(dimensionModel);
        }
        for (DynamicObject measure : measureCols = PAMeasureHelper.loadMeasure(measureIds)) {
            PAMeasureModel measureModel = new PAMeasureModel();
            measureModel.loadFromDynamicObject(measure, true);
            MeasureTypeEnum measureType = measureModel.getMeasureType();
            if (MeasureTypeEnum.CALCULATION == measureType) {
                DynamicObject dimensionObject = measure.getDynamicObject("dimension");
                PADimensionModel dimensionModel = this.getDim(dimensionObject.getPkValue());
                measureModel.setDimension(dimensionModel);
            }
            this.addMeasure(measureType.getCode(), measureModel);
        }
        String tableNumber = sourceDynamicObject.getString("tablenumber");
        this.modelEntity = PACommonConstans.buildEntityName(tableNumber);
    }

    public String getModelEntity() {
        return this.modelEntity;
    }

    public List<PADimensionModel> getOtherDim() {
        return this.dimensionMap.get(2);
    }

    public List<PADimensionModel> getFixDim() {
        return this.dimensionMap.get(1);
    }

    public List<PADimensionModel> getAllDim() {
        ArrayList<PADimensionModel> list = new ArrayList<PADimensionModel>(2);
        List<PADimensionModel> otherList = this.dimensionMap.get(2);
        logger.info("model otherList :%s ", otherList);
        if (otherList != null) {
            list.addAll(otherList);
        }
        List<PADimensionModel> fixList = this.dimensionMap.get(1);
        logger.info("model fixList :%s ", fixList);
        if (fixList != null) {
            list.addAll(fixList);
        }
        return list;
    }

    public PADimensionModel getDim(Object id) {
        for (List<PADimensionModel> list : this.dimensionMap.values()) {
            for (PADimensionModel model : list) {
                if (!id.equals(model.getId())) continue;
                return model;
            }
        }
        return null;
    }

    public void addFixDim(PADimensionModel dimension) {
        this.addDim(1, dimension);
    }

    public void addOtherDim(PADimensionModel dimension) {
        this.addDim(2, dimension);
    }

    public void addDim(Integer dimensionType, PADimensionModel dimension) {
        List<PADimensionModel> list;
        if (this.dimensionMap == null) {
            this.dimensionMap = new HashMap<Integer, List<PADimensionModel>>(2);
        }
        if ((list = this.dimensionMap.get(dimensionType)) == null) {
            list = new ArrayList<PADimensionModel>(2);
            this.dimensionMap.put(dimensionType, list);
        }
        list.add(dimension);
    }

    public void addMeasure(Integer measureType, PAMeasureModel measure) {
        List<PAMeasureModel> list;
        if (this.measureMap == null) {
            this.measureMap = new HashMap<Integer, List<PAMeasureModel>>(2);
        }
        if ((list = this.measureMap.get(measureType)) == null) {
            list = new ArrayList<PAMeasureModel>(2);
            this.measureMap.put(measureType, list);
        }
        list.add(measure);
    }

    public List<PAMeasureModel> getCalMeasure() {
        return this.measureMap.get(MeasureTypeEnum.CALCULATION.getCode());
    }

    public List<PAMeasureModel> getOrdinaryMeasure() {
        return this.measureMap.get(MeasureTypeEnum.ORDINARY.getCode());
    }

    public List<PAMeasureModel> getAllMeasure() {
        ArrayList<PAMeasureModel> allMeasures = new ArrayList<PAMeasureModel>(16);
        for (MeasureTypeEnum type : MeasureTypeEnum.values()) {
            List<PAMeasureModel> measures = this.measureMap.get(type.getCode());
            if (measures == null) continue;
            allMeasures.addAll(measures);
        }
        return allMeasures;
    }

    public PAMeasureModel findOrdinaryMeasure(String number) {
        return this.findMeasureByNumber(MeasureTypeEnum.ORDINARY, number);
    }

    public PAMeasureModel findCalMeasure(String number) {
        return this.findMeasureByNumber(MeasureTypeEnum.CALCULATION, number);
    }

    public PAMeasureModel findMeasureByNumber(MeasureTypeEnum type, String number) {
        for (PAMeasureModel measure : this.measureMap.get(type.getCode())) {
            if (!number.equals(measure.getNumber())) continue;
            return measure;
        }
        return null;
    }

    public List<PADimensionModel> getIndexDimList() {
        ArrayList<PADimensionModel> indexDimList = new ArrayList<PADimensionModel>(2);
        indexDimList.add(this.orgDim);
        indexDimList.add(this.periodDim);
        return indexDimList;
    }

    public PADimensionModel getOrgDim() {
        return this.orgDim;
    }

    public PADimensionModel getPeriodDim() {
        return this.periodDim;
    }

    public String getPeriodDimNumber() {
        return this.periodDimNumber;
    }

    public String getPeriodSourceNumber() {
        return this.periodSourceNumber;
    }

    public String getAccountDimNumber() {
        return this.accountDimNumber;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }
}

